/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.MSCryptoDSAPrivateKey;
import com.sun.deploy.security.MSCryptoPrivateKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public final class WIExplorerMyKeyStore
extends KeyStoreSpi {
    private Collection<KeyEntry> keyEntries = new ArrayList<KeyEntry>();

    @Override
    public Enumeration<String> engineAliases() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (password != null && password.length > 0) {
            throw new UnrecoverableKeyException("Password is not required for WIExplorer MY keystore.");
        }
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        for (KeyEntry entry : this.keyEntries) {
            if (!alias.equals(entry.getAlias())) continue;
            return entry.getPrivateKey();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        for (KeyEntry entry : this.keyEntries) {
            if (!alias.equals(entry.getAlias())) continue;
            X509Certificate[] certChain = entry.getCertificateChain();
            Certificate[] tmp = new X509Certificate[certChain.length];
            System.arraycopy(certChain, 0, tmp, 0, certChain.length);
            return tmp;
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        for (KeyEntry entry : this.keyEntries) {
            if (!alias.equals(entry.getAlias())) continue;
            X509Certificate[] certChain = entry.getCertificateChain();
            return certChain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return new Date();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given certificate to the given alias.");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("WIExplorer does not support alias removal.");
    }

    public Iterator<KeyEntry> keyIterator() {
        return this.keyEntries.iterator();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Iterator<KeyEntry> iter = this.keyIterator();
        while (iter.hasNext()) {
            String a = iter.next().getAlias();
            if (!a.equals(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int engineSize() {
        return this.keyEntries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return alias.startsWith("MSCryptoRSAPrivateKey") || alias.startsWith("MSCryptoDSAPrivateKey");
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        for (KeyEntry entry : this.keyEntries) {
            if (entry.certChain == null || !entry.certChain[0].equals(cert)) continue;
            return entry.getAlias();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("WIExplorer cert store cannot be stored into stream.");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("authProvider.SunDeploy-MSCrypto"));
        }
        if (stream != null) {
            throw new IOException("WIExplorer cert store cannot be loaded from stream.");
        }
        this.keyEntries.clear();
        this.loadKeysAndCertificateChains(this.getName(), this.keyEntries);
    }

    private native void loadKeysAndCertificateChains(String var1, Collection<KeyEntry> var2);

    private void generateDSAKeyAndCertificateChain(int hCryptProv, int hCryptKey, int keyLength, Collection<X509Certificate> certCollection, Collection<KeyEntry> keyEntries) {
        try {
            X509Certificate[] certChain = new X509Certificate[certCollection.size()];
            int i = 0;
            Iterator<X509Certificate> iter = certCollection.iterator();
            while (iter.hasNext()) {
                certChain[i] = iter.next();
                ++i;
            }
            KeyEntry entry = new KeyEntry(new MSCryptoDSAPrivateKey(hCryptProv, hCryptKey, keyLength), certChain);
            keyEntries.add(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void generateCertificate(byte[] data, Collection<X509Certificate> certCollection) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(bis);
            for (X509Certificate x509Certificate : c) {
                certCollection.add(x509Certificate);
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (Throwable te) {
            te.printStackTrace();
        }
    }

    protected String getName() {
        return "MY";
    }

    static {
        Platform.get().loadDeployNativeLib();
    }

    class KeyEntry {
        private MSCryptoPrivateKey privateKey;
        private X509Certificate[] certChain;

        KeyEntry(MSCryptoPrivateKey key, X509Certificate[] chain) {
            this.privateKey = key;
            this.certChain = chain;
        }

        String getAlias() {
            return this.privateKey.toString();
        }

        Key getPrivateKey() {
            return this.privateKey;
        }

        X509Certificate[] getCertificateChain() {
            return this.certChain;
        }
    }
}

