/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.AuthInfoItem;
import com.sun.deploy.security.WIExplorerBrowserAuthenticator14;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;

public final class WIExplorerBrowserAuthenticator
extends WIExplorerBrowserAuthenticator14 {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static HashMap<URL, AuthInfoItem> authCache;

    @Override
    public PasswordAuthentication getAuthentication(String protocol, String siteName, int port, String scheme, String realm, URL requestingURL, boolean proxyRequest) {
        char[] credential = null;
        if (requestingURL != null && (credential = this.getCredentialFromInet(requestingURL, proxyRequest)) != null) {
            PasswordAuthentication pa = this.getPAFromCharArray(credential);
            return pa;
        }
        return super.getAuthentication(protocol, siteName, port, scheme, realm, requestingURL, proxyRequest);
    }

    private char[] getCredentialFromInet(URL requestURL, boolean proxyRequest) {
        char[] credential = null;
        AuthInfoItem item = authCache.get(requestURL);
        if (item == null) {
            int port = requestURL.getPort();
            String protocol = requestURL.getProtocol();
            boolean isSecure = false;
            if (PROTOCOL_HTTPS.equalsIgnoreCase(protocol)) {
                isSecure = true;
            }
            if (port == -1) {
                if (PROTOCOL_HTTP.equalsIgnoreCase(protocol)) {
                    port = 80;
                }
                if (PROTOCOL_HTTPS.equalsIgnoreCase(protocol)) {
                    port = 443;
                }
            }
            item = this.getAuthFromInet(requestURL.getHost(), port, isSecure, requestURL.getPath(), proxyRequest);
        }
        if (item == null) {
            return null;
        }
        char[] cArray = credential = proxyRequest ? item.getProxyCredential() : item.getServerCredential();
        if (item.shouldRemove()) {
            authCache.remove(item);
        } else {
            authCache.put(requestURL, item);
        }
        return credential;
    }

    private native AuthInfoItem getAuthFromInet(String var1, int var2, boolean var3, String var4, boolean var5);

    static {
        Platform.get().loadDeployNativeLib();
        authCache = new HashMap();
    }
}

