/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.TrustedLibraries;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SimpleJarVerifier
extends JarVerifier {
    public static JarVerifier create(URL location, String version, File jar, File nativePath) {
        return new SimpleJarVerifier(location, version, jar, nativePath);
    }

    private SimpleJarVerifier(URL location, String jarVersion, File f, File nativePath) {
        super(location, jarVersion, f, nativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(DownloadDelegate dd) throws IOException, JARSigningException {
        JarFile jar = JarUtil.createJarFile(this.jarFile, true);
        this.manifest = jar.getManifest();
        try {
            int total = jar.size();
            int count = 0;
            boolean blacklistDone = false;
            boolean trustedLibrariesDone = false;
            Enumeration<JarEntry> entries = jar.entries();
            if (dd != null) {
                dd.validating(this.jarLocation, 0, total);
            }
            while (entries.hasMoreElements()) {
                ++count;
                String name = null;
                JarEntry entry = null;
                entry = entries.nextElement();
                name = entry.getName();
                if (!blacklistDone) {
                    try {
                        blacklistDone = BlackList.getInstance().checkJarEntry(jar, entry);
                    }
                    catch (GeneralSecurityException e) {
                        throw new JARSigningException(this.jarLocation, this.jarVersion, 5, e);
                    }
                }
                if (!trustedLibrariesDone) {
                    try {
                        trustedLibrariesDone = TrustedLibraries.checkJarEntry(jar, entry);
                    }
                    catch (GeneralSecurityException e) {
                        Attributes attrs = this.manifest.getMainAttributes();
                        attrs.putValue("Trusted-Library", Boolean.TRUE.toString());
                    }
                }
                if (JarUtil.canSkipEntry(entry)) continue;
                this.authenticateJarEntry(jar, entry);
                this.processCertificates(jar, entry, name);
                this.processSigners(jar, entry, name);
                if (dd == null || count % 10 != 0 && count < total) continue;
                dd.validating(this.jarLocation, count, total);
            }
            if (dd != null) {
                dd.validating(this.jarLocation, total, total);
            }
        }
        finally {
            jar.close();
            this.warnIfUnsigned();
        }
    }

    @Override
    protected void authenticateJarEntry(JarFile jar, JarEntry entry) throws IOException, JARSigningException {
        String name = entry.getName();
        boolean needToSave = this.nativePath != null && name.indexOf("/") == -1 && name.indexOf("\\") == -1;
        try {
            SimpleJarVerifier.readAndMaybeSaveStreamTo(jar.getInputStream(entry), needToSave, name, this.nativePath);
        }
        catch (SecurityException se) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, se);
        }
    }
}

