/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

abstract class MozillaCertStore
implements CertStore {
    protected static final int VALID_PEER = 1;
    protected static final int TRUSTED_PEER = 2;
    protected static final int VALID_CA = 8;
    protected static final int TRUSTED_CA = 16;
    protected static final int USER = 64;
    protected static final int TRUSTED_CLIENT_CA = 128;
    private Collection<X509Certificate> certs = new ArrayList<X509Certificate>();

    MozillaCertStore() {
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("mozilla.cert.loading", new Object[]{this.getName()});
        this.certs.clear();
        try {
            Class<?> jsscm = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
            Object cm = BrowserKeystore.getJSSCryptoManager();
            Method gccsmeth = jsscm.getMethod("getCACerts", new Class[0]);
            Object[] certsArray = (Object[])gccsmeth.invoke(cm, (Object[])null);
            for (int i = 0; i < certsArray.length; ++i) {
                Field sslcafield;
                Object[] arglist3;
                Boolean sslca;
                Class<?> jsscertarr = Class.forName("org.mozilla.jss.crypto.X509Certificate", true, ClassLoader.getSystemClassLoader());
                Method getNickNameMeth = jsscertarr.getMethod("getNickname", new Class[0]);
                String nickname = (String)getNickNameMeth.invoke(certsArray[i], (Object[])null);
                Class<?> jsscertusage = Class.forName("org.mozilla.jss.CryptoManager$CertUsage", true, ClassLoader.getSystemClassLoader());
                Class[] partypes2 = new Class[]{String.class, Boolean.TYPE, jsscertusage};
                Method isCertValidMeth = jsscm.getMethod("isCertValid", partypes2);
                if (this.isTrustedSigningCACertStore()) {
                    Field osfield = jsscertusage.getField("ObjectSigner");
                    Object[] arglist2 = new Object[]{nickname, Boolean.FALSE, osfield.get(certsArray[i])};
                    Boolean objSigner = (Boolean)isCertValidMeth.invoke(cm, arglist2);
                    Field esfield = jsscertusage.getField("EmailSigner");
                    arglist2[2] = esfield.get(certsArray[i]);
                    Boolean emailSigner = (Boolean)isCertValidMeth.invoke(cm, arglist2);
                    if (!objSigner.booleanValue() && !emailSigner.booleanValue()) continue;
                }
                if (this.isTrustedSSLCACertStore() && !(sslca = (Boolean)isCertValidMeth.invoke(cm, arglist3 = new Object[]{nickname, Boolean.FALSE, (sslcafield = jsscertusage.getField("SSLCA")).get(certsArray[i])})).booleanValue()) continue;
                Method getEncodedMeth = jsscertarr.getMethod("getEncoded", new Class[0]);
                byte[] certdata = (byte[])getEncodedMeth.invoke(certsArray[i], (Object[])null);
                this.generateCertificate(certdata, this.certs);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Trace.msgSecurityPrintln("mozilla.cert.loaded", new Object[]{this.getName()});
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        throw new KeyStoreException("Cannot store certificate in Mozilla \"" + this.getName() + "\" certificate store.");
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        return this.add(cert, null, false);
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        throw new KeyStoreException("Cannot add certificate in Mozilla \"" + this.getName() + "\" certificate store.");
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        throw new KeyStoreException("Cannot remove certificate from Mozilla \"" + this.getName() + "\" certificate store.");
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.contains(cert, null, false);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        Trace.msgSecurityPrintln("mozilla.cert.instore", new Object[]{this.getName()});
        return this.certs.contains(cert);
    }

    @Override
    public boolean verify(Certificate cert) {
        Trace.msgSecurityPrintln("mozilla.cert.canverify", new Object[]{this.getName()});
        Trace.msgSecurityPrintln("mozilla.cert.tobeverified", new Object[]{cert});
        for (X509Certificate rootCert : this.getCertificates()) {
            Trace.msgSecurityPrintln("mozilla.cert.tobecompared", new Object[]{this.getName(), rootCert});
            try {
                cert.verify(rootCert.getPublicKey());
                Trace.msgSecurityPrintln("mozilla.cert.verify.ok", new Object[]{this.getName()});
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("mozilla.cert.verify.fail", new Object[]{this.getName()});
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() {
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        for (X509Certificate cert : this.certs) {
            certCollection.add(cert);
        }
        return certCollection;
    }

    private void generateCertificate(byte[] data, Collection<X509Certificate> certCollection) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(bis);
            for (X509Certificate x509Certificate : c) {
                certCollection.add(x509Certificate);
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (Throwable te) {
            te.printStackTrace();
        }
    }

    protected abstract String getName();

    protected abstract boolean isTrustedSigningCACertStore();

    protected abstract boolean isTrustedSSLCACertStore();
}

