/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;

final class ImmutableCertStore
implements CertStore {
    private CertStore certStore = null;

    ImmutableCertStore(CertStore certStore) {
        this.certStore = certStore;
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.certStore.load();
    }

    @Override
    public void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.certStore.load(integrityCheck);
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        throw new IOException("Cannot modify certificate store.");
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Cannot modify certificate store.");
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        throw new KeyStoreException("Cannot modify certificate store.");
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        throw new IOException("Cannot modify certificate store.");
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.certStore.contains(cert);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        return this.certStore.contains(cert, loc, tsFlag);
    }

    @Override
    public boolean verify(Certificate cert) throws KeyStoreException {
        return this.certStore.verify(cert);
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        return this.certStore.getCertificates();
    }
}

