/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ref;

import java.net.URL;

public class AppRef {
    private Type type;
    private final String title;
    private final URL location;
    private final URL htmlLocation;
    private final URL jnlpLocation;
    private final String jnlpHash;
    private final URL anchorURL;

    public AppRef(Type type, String title, URL htmlLocation, URL jnlpLocation, URL anchorURL) {
        this(type, title, htmlLocation, jnlpLocation, anchorURL, null);
    }

    public AppRef(Type type, String title, URL htmlLocation, URL jnlpLocation, URL anchorURL, String jnlpHash) {
        this.type = type;
        this.title = title;
        this.htmlLocation = htmlLocation;
        this.jnlpLocation = jnlpLocation;
        this.jnlpHash = jnlpHash;
        this.location = jnlpLocation != null ? jnlpLocation : htmlLocation;
        this.anchorURL = anchorURL;
    }

    public String getJnlpHash() {
        return this.jnlpHash;
    }

    public String getTitle() {
        return this.title;
    }

    public URL getLocation() {
        return this.location;
    }

    public URL getHTMLLocation() {
        return this.htmlLocation;
    }

    public URL getJNLPLocation() {
        return this.jnlpLocation;
    }

    public URL getAnchorURL() {
        return this.anchorURL;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        boolean jnlpLocationMatch;
        boolean htmlLocationMatch;
        boolean titleMatch;
        boolean typeMatch;
        if (!(other instanceof AppRef)) {
            return false;
        }
        AppRef appRef = (AppRef)other;
        boolean bl = this.type == null ? appRef.type == null : (typeMatch = this.type.equals((Object)appRef.type));
        boolean bl2 = this.title == null ? appRef.title == null : (titleMatch = this.title.equals(appRef.title));
        boolean bl3 = this.htmlLocation == null ? appRef.htmlLocation == null : (htmlLocationMatch = this.htmlLocation.equals(appRef.htmlLocation));
        boolean bl4 = this.jnlpLocation == null ? appRef.jnlpLocation == null : (jnlpLocationMatch = this.jnlpLocation.equals(appRef.jnlpLocation));
        boolean anchorMatch = this.anchorURL == null ? appRef.anchorURL == null : this.anchorURL.equals(appRef.anchorURL);
        return typeMatch && titleMatch && htmlLocationMatch && jnlpLocationMatch && anchorMatch;
    }

    public int hashCode() {
        return (this.type == null ? 0 : this.type.hashCode()) + (this.title == null ? 0 : this.title.hashCode()) + (this.htmlLocation == null ? 0 : this.htmlLocation.hashCode()) + (this.jnlpLocation == null ? 0 : this.jnlpLocation.hashCode()) + (this.anchorURL == null ? 0 : this.anchorURL.hashCode());
    }

    public String toString() {
        String appRefString = "\n        type: " + this.type + "\n        title: " + this.title + "\n        location: " + this.location + "\n        htmlLocation: " + this.htmlLocation + "\n        jnlpLocation: " + this.jnlpLocation + "\n        anchorURL: " + this.anchorURL;
        return appRefString;
    }

    public static enum Type {
        HTML,
        JNLP,
        DOCBASE;

    }
}

