/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.util.StringTokenizer;

public abstract class AbstractBrowserProxyHandler
implements ProxyHandler {
    @Override
    public final boolean isSupported(int proxyType) {
        return proxyType == 3;
    }

    @Override
    public final boolean isProxyCacheSupported() {
        return false;
    }

    @Override
    public final void init(BrowserProxyInfo info) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.browser");
        if (!this.isSupported(info.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + info.getType());
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    @Override
    public final ProxyInfo[] getProxyInfo(URL u) {
        String s = this.findProxyForURL(u.toString());
        return this.extractAutoProxySetting(s);
    }

    protected abstract String findProxyForURL(String var1);

    private ProxyInfo[] extractAutoProxySetting(String s) {
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, ";", false);
            ProxyInfo[] proxyInfoArray = new ProxyInfo[st.countTokens()];
            int index = 0;
            while (st.hasMoreTokens()) {
                String pattern = st.nextToken();
                int i = pattern.indexOf("PROXY");
                if (i != -1) {
                    proxyInfoArray[index++] = new ProxyInfo(pattern.substring(i + 6));
                    continue;
                }
                i = pattern.indexOf("SOCKS");
                if (i != -1) {
                    proxyInfoArray[index++] = new ProxyInfo(null, pattern.substring(i + 6));
                    continue;
                }
                proxyInfoArray[index++] = new ProxyInfo(null, -1);
            }
            return proxyInfoArray;
        }
        return new ProxyInfo[]{new ProxyInfo(null)};
    }
}

