/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.CookieStore;
import com.sun.deploy.net.cookie.HttpCookie;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.TreeMap;

final class NetscapeCookieStore
extends CookieStore {
    private Date lastAccessDate = new Date(0L);
    private File cookieFile = null;
    private static final AccessControlContext ACC_COOKIE_INSTANCE;

    NetscapeCookieStore(File cookieFile) {
        this.cookieFile = cookieFile;
    }

    @Override
    protected void loadCookieJar() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NetscapeCookieStore.this.loadCookieJarFromStorage();
                return null;
            }
        }, ACC_COOKIE_INSTANCE);
    }

    private void loadCookieJarFromStorage() {
        Date fileModifiedDate;
        if (this.cookieFile.exists() && (fileModifiedDate = new Date(this.cookieFile.lastModified())).after(this.lastAccessDate)) {
            TreeMap<String, ArrayList<HttpCookie>> tempCookieJar = new TreeMap<String, ArrayList<HttpCookie>>();
            try {
                FileInputStream fis = new FileInputStream(this.cookieFile);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    HttpCookie cookie;
                    if (line.startsWith("#") || line.trim().equals("") || (cookie = this.readCookieRecord(line)) == null || cookie.hasExpired() || this.shouldRejectCookie(cookie)) continue;
                    String domain = cookie.getDomain().toLowerCase();
                    ArrayList<HttpCookie> cookieList = (ArrayList<HttpCookie>)tempCookieJar.get(domain);
                    if (cookieList == null) {
                        cookieList = new ArrayList<HttpCookie>();
                    }
                    if (!this.addOrReplaceCookie(cookieList, cookie)) continue;
                    tempCookieJar.put(domain, cookieList);
                }
                br.close();
                isr.close();
                fis.close();
                this.lastAccessDate = new Date(this.cookieFile.lastModified());
                this.cookieJar = tempCookieJar;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void saveCookieJar() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NetscapeCookieStore.this.saveCookieJarToStorage();
                return null;
            }
        }, ACC_COOKIE_INSTANCE);
    }

    private void saveCookieJarToStorage() {
        try {
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            sb.append("# Java Deployment HTTP Cookie File");
            sb.append(lineSeparator);
            sb.append("# http://www.netscape.com/newsref/std/cookie_spec.html");
            sb.append(lineSeparator);
            sb.append("# This is a generated file!  Do not edit.");
            sb.append(lineSeparator);
            sb.append(lineSeparator);
            for (List cookieList : this.cookieJar.values()) {
                for (HttpCookie cookie : cookieList) {
                    if (cookie.hasExpired()) continue;
                    this.writeCookieRecord(cookie, sb);
                    sb.append(lineSeparator);
                }
            }
            this.cookieFile.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(this.cookieFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            PrintWriter pw = new PrintWriter(bos);
            pw.println(sb.toString());
            pw.close();
            bos.close();
            fos.close();
            this.lastAccessDate = new Date(this.cookieFile.lastModified());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getName() {
        return "Persistent Cookie Store";
    }

    @Override
    protected boolean shouldRejectCookie(HttpCookie cookie) {
        if (super.shouldRejectCookie(cookie)) {
            return true;
        }
        return cookie.getExpirationDate() == null || cookie.hasExpired();
    }

    private HttpCookie readCookieRecord(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, "\t", true);
            if (st.countTokens() < 10) {
                return null;
            }
            String domain = st.nextToken();
            if (domain.indexOf(".") == -1) {
                return null;
            }
            st.nextToken();
            String flag = st.nextToken();
            if (flag.equals("\t")) {
                flag = "FALSE";
            } else {
                st.nextToken();
            }
            String path = st.nextToken();
            if (path.equals("\t")) {
                path = "/";
            } else {
                st.nextToken();
            }
            String secure = st.nextToken();
            if (secure.equals("\t")) {
                secure = "TRUE";
            } else {
                st.nextToken();
            }
            boolean isSecure = !secure.equalsIgnoreCase("false");
            Date expirationDate = new Date(Long.parseLong(st.nextToken()) * 1000L);
            st.nextToken();
            String name = st.nextToken();
            if (name.equals("\t") || name.trim().equals("")) {
                return null;
            }
            st.nextToken();
            Object value = st.nextToken();
            while (st.hasMoreTokens()) {
                value = (String)value + st.nextToken();
            }
            String nameAndValue = name + "=" + (String)value;
            return HttpCookie.create(expirationDate, nameAndValue, path, domain, isSecure);
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private void writeCookieRecord(HttpCookie cookie, StringBuffer buffer) {
        String domain = cookie.getDomain();
        buffer.append(domain);
        buffer.append("\t");
        if (domain.startsWith(".")) {
            buffer.append("TRUE\t");
        } else {
            buffer.append("FALSE\t");
        }
        buffer.append(cookie.getPath());
        buffer.append("\t");
        if (cookie.isSecure()) {
            buffer.append("TRUE\t");
        } else {
            buffer.append("FALSE\t");
        }
        buffer.append(cookie.getExpirationDate().getTime() / 1000L + "\t");
        buffer.append(cookie.getName());
        buffer.append("\t");
        buffer.append(cookie.getValue());
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm1 = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)perms).add(perm1);
        PropertyPermission perm2 = new PropertyPermission("line.separator", "read");
        ((PermissionCollection)perms).add(perm2);
        ACC_COOKIE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

