/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.nativesandbox;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.nativesandbox.NativeSandboxOutputStream;
import com.sun.deploy.nativesandbox.comm.Request;
import com.sun.deploy.nativesandbox.comm.Response;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.BufferUtil;
import com.sun.deploy.util.ByteBufferWrapper;
import com.sun.deploy.util.SyncFileAccess;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class NativeSandboxBrokerImpl
implements NativeSandboxBroker {
    private static final boolean TRACE = false;
    private static final AccessControlContext ACC_INSTANCE;
    private static final String[] showDocumentWhiteList;
    private static final String[] denyLAPKeys;
    private static final Object clientWriteLock;
    private static NativeSandboxJNLPService jnlpService;
    public static final int NSB_BUFFER_SIZE = 0x100000;
    public static final String NSB_WRITE_PIPE = "NSBWP";
    public static final String NSB_READ_PIPE = "NSBRP";
    private static final int NSB_COMMAND_WRITE = 0;
    private static final int NSB_COMMAND_APPEND = 1;
    private static final int NSB_COMMAND_DELETE = 2;
    private static final int NSB_COMMAND_DELETEONEXIT = 3;
    private static final int NSB_COMMAND_RENAME = 4;
    private static final int NSB_COMMAND_SHOWDOCUMENT = 5;
    private static final int NSB_COMMAND_BUFFERSIZE = 6;
    private static final int NSB_COMMAND_OPENFILEDIALOG = 7;
    private static final int NSB_COMMAND_OPENMULTIFILEDIALOG = 8;
    private static final int NSB_COMMAND_SAVEFILE = 9;
    private static final int NSB_COMMAND_RAF = 10;
    private static final int NSB_COMMAND_OPENFILE = 11;
    private static final int NSB_COMMAND_OPENFILES = 12;
    private static final int NSB_COMMAND_REMOVEASSOCIATION = 13;
    private static final int NSB_COMMAND_REMOVESHORTCUTS = 14;
    private static final int NSB_COMMAND_REQUESTASSOCIATION = 15;
    private static final int NSB_COMMAND_REQUESTSHORTCUT = 16;
    private static final int NSB_COMMAND_MUFFIN_CREATE = 17;
    private static final int NSB_COMMAND_MUFFIN_GET = 18;
    private static final int NSB_COMMAND_MUFFIN_DELETE = 19;
    private static final int NSB_COMMAND_MUFFIN_SET_TAG = 20;
    private static final int NSB_COMMAND_PARENT_WINDOW = 21;
    private static final int NSB_COMMAND_SET_PROP = 22;
    private final long readPipe;
    private final long writePipe;
    private static final ArrayList<String> verifiedPaths;
    private static final HashMap<String, RandomAccessFile> rafsFile;
    private static final Map<Integer, Long> windowParents;
    private ByteBufferWrapper byteBuffer = null;
    private byte[] buffer = null;
    private int currentBufferSize = 0;

    public NativeSandboxBrokerImpl(long readPipe, long writePipe) {
        this.readPipe = readPipe;
        this.writePipe = writePipe;
        this.allocateBuffers(0x100000);
    }

    public static long[] getNativeSandboxPipeHandles() {
        return NativeSandboxBrokerImpl.getNativeSandboxPipeHandles0();
    }

    private synchronized void allocateBuffers(int size) {
        if (this.byteBuffer == null || this.byteBuffer.capacity() < size) {
            this.byteBuffer = BufferUtil.allocateDirect(size);
            this.byteBuffer.order(ByteOrder.nativeOrder());
            this.currentBufferSize = size;
        }
        if (this.buffer == null || this.buffer.length < size) {
            this.buffer = new byte[size];
            this.currentBufferSize = size;
        }
    }

    private static native long[] getNativeSandboxPipeHandles0();

    private int readPipe(byte[] data) {
        this.byteBuffer.rewind();
        int len = this.readPipe0(this.readPipe, this.byteBuffer.getBuffer());
        this.byteBuffer.getBuffer().get(data);
        return len;
    }

    private native int readPipe0(long var1, ByteBuffer var3);

    private int writePipe(byte[] data, int len) {
        this.byteBuffer.rewind();
        this.byteBuffer.getBuffer().put(data, 0, len);
        return this.writePipe0(this.writePipe, this.byteBuffer.getBuffer(), len);
    }

    private native int writePipe0(long var1, ByteBuffer var3, int var4);

    private synchronized Response sendRequest(Request request) {
        int result;
        byte[] requestBytes = this.getObjectBytes(request);
        if (requestBytes == null || requestBytes.length <= 0) {
            Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
            return null;
        }
        if (this.currentBufferSize < requestBytes.length) {
            this.allocateBuffers(requestBytes.length);
            Request sizeUpdate = new Request(6);
            sizeUpdate.setSize(requestBytes.length);
            byte[] sizeUpdateBytes = this.getObjectBytes(sizeUpdate);
            if (sizeUpdateBytes == null || sizeUpdateBytes.length <= 0) {
                Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
                return null;
            }
            int result2 = this.writePipe(sizeUpdateBytes, sizeUpdateBytes.length);
            if (result2 < 0) {
                Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
                return null;
            }
        }
        if ((result = this.writePipe(requestBytes, requestBytes.length)) < 0) {
            Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
            return null;
        }
        int len = this.readPipe(this.buffer);
        if (len <= 0) {
            Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
        }
        Response response = (Response)this.getObjectFromBytes(this.buffer, len, true);
        return response;
    }

    public void runNativeSandboxBroker() {
        boolean run = true;
        block28: do {
            int len;
            if ((len = this.readPipe(this.buffer)) <= 0) {
                Trace.println("NativeSandboxBroker.runNativeSandboxBroker() failed", TraceLevel.BASIC);
                break;
            }
            Request request = (Request)this.getObjectFromBytes(this.buffer, len, false);
            Response response = new Response(request.getCommand());
            boolean result = false;
            try {
                switch (request.getCommand()) {
                    case 0: {
                        result = this.writeFile(request);
                        break;
                    }
                    case 1: {
                        result = this.appendFile(request);
                        break;
                    }
                    case 2: {
                        result = this.deleteFile(request);
                        break;
                    }
                    case 3: {
                        result = this.deleteOnExitFile(request);
                        break;
                    }
                    case 4: {
                        result = this.renameFile(request);
                        break;
                    }
                    case 5: {
                        result = this.showDocument(request);
                        break;
                    }
                    case 6: {
                        this.allocateBuffers(request.getSize());
                        continue block28;
                    }
                    case 7: {
                        String file = this.openFileDialog(request);
                        if (file != null) {
                            response.setFileList(new String[]{file});
                            result = true;
                        }
                        break;
                    }
                    case 8: {
                        String[] files = this.openMultiFileDialog(request);
                        if (files != null & files.length > 0) {
                            response.setFileList(files);
                            result = true;
                        }
                        break;
                    }
                    case 9: {
                        String file = this.saveFile(request);
                        if (file != null) {
                            response.setFileList(new String[]{file});
                            result = true;
                        }
                        break;
                    }
                    case 10: {
                        NativeSandboxBroker.RAF raf = this.sendRAF(request);
                        if (raf != null) {
                            response.setRAF(raf);
                            result = true;
                        }
                        break;
                    }
                    case 11: {
                        result = this.openFile(request);
                        break;
                    }
                    case 12: {
                        result = this.openFiles(request);
                        break;
                    }
                    case 13: {
                        result = this.removeAssociation(request);
                        break;
                    }
                    case 14: {
                        result = this.removeShortcuts(request);
                        break;
                    }
                    case 15: {
                        result = this.requestAssociation(request);
                        break;
                    }
                    case 16: {
                        result = this.requestShortcut(request);
                        break;
                    }
                    case 17: {
                        long value = this.createMuffin(request);
                        response.setLongResult(value);
                        result = true;
                        break;
                    }
                    case 19: {
                        this.deleteMuffin(request);
                        result = true;
                        break;
                    }
                    case 18: {
                        String file = this.getMuffin(request);
                        if (file != null) {
                            response.setFileList(new String[]{file});
                            result = true;
                        }
                        break;
                    }
                    case 20: {
                        this.setMuffinTag(request);
                        result = true;
                        break;
                    }
                    case 21: {
                        this.parentWindow(request);
                        result = true;
                        break;
                    }
                    case 22: {
                        this.setProperty(request);
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            }
            catch (IOException e) {
                response.setException(e.getMessage());
            }
            catch (Exception e) {
                result = false;
            }
            response.setBooleanResult(result);
            byte[] responseBytes = this.getObjectBytes(response);
            if (responseBytes == null || responseBytes.length <= 0) {
                Trace.println("NativeSandboxBroker.runNativeSandboxBroker() failed", TraceLevel.BASIC);
                continue;
            }
            int res = this.writePipe(responseBytes, responseBytes.length);
            if (res >= 0) continue;
            Trace.println("NativeSandboxBroker.runNativeSandboxBroker() failed", TraceLevel.BASIC);
        } while (run);
    }

    private boolean isValidCacheEntryPath(String path) {
        String certsFile = Config.getSandboxTrustedCertificateFile();
        if (path.equals(certsFile)) {
            return true;
        }
        String splashDir = Config.getSplashDir();
        if (path.startsWith(splashDir)) {
            return true;
        }
        String defaultCacheFolder = Config.getDefaultCacheDirectory();
        if (path.startsWith(defaultCacheFolder)) {
            String subpath = path.substring(defaultCacheFolder.length());
            String[] tokens = subpath.split("\\\\");
            if (tokens.length != 4) {
                return false;
            }
            if (!tokens[0].isEmpty()) {
                return false;
            }
            if (!tokens[1].equals("6.0")) {
                return false;
            }
            if (!tokens[2].matches("^[0-9]{1}$") && !tokens[2].matches("^[0-9]{2}$")) {
                return false;
            }
            int bucket = Integer.parseInt(tokens[2]);
            return bucket >= 0 && bucket <= 63;
        }
        return false;
    }

    private boolean isLAPFile(String path) {
        String ext;
        return path.length() > 5 && (ext = path.substring(path.length() - 4)).equalsIgnoreCase(".lap") && this.isValidCacheEntryPath(path);
    }

    private boolean isLAPFileDataValid(byte[] data) {
        try {
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(data));
            for (int i = 0; i < denyLAPKeys.length; ++i) {
                String value = (String)props.get(denyLAPKeys[i]);
                if (value == null) continue;
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean verifyFilePath(String path) {
        if (path == null) {
            return false;
        }
        if (verifiedPaths.contains(path)) {
            return true;
        }
        if (path.contains("..") || path.contains("/")) {
            return false;
        }
        if (!this.isValidCacheEntryPath(path)) {
            return false;
        }
        verifiedPaths.add(path);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(Request request) throws IOException {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        if (this.isLAPFile(request.getPath1()) && !this.isLAPFileDataValid(request.getData())) {
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(request.getData());
        FilterOutputStream bof = null;
        SyncFileAccess.FileOutputStreamLock fosL = null;
        FileOutputStream fos = null;
        try {
            SyncFileAccess syncFileAccess = new SyncFileAccess(new File(request.getPath1()));
            fosL = syncFileAccess.openLockFileOutputStream(false, 1000, false);
            fos = fosL.getFileOutputStream();
            if (fos == null) {
                fos = new FileOutputStream(new File(request.getPath1()));
            }
            bof = new BufferedOutputStream(fos);
            byte[] data = new byte[request.getData().length];
            int n = is.read(data);
            while (n >= 0) {
                ((BufferedOutputStream)bof).write(data, 0, n);
                n = is.read(data);
            }
        }
        finally {
            if (fosL != null) {
                fosL.release();
            } else if (fos != null) {
                fos.close();
            }
            if (bof != null) {
                bof.close();
            }
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean appendFile(Request request) {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        if (this.isLAPFile(request.getPath1())) {
            return false;
        }
        InputStream is = null;
        SyncFileAccess.RandomAccessFileLock rafL = null;
        RandomAccessFile raf = null;
        try {
            SyncFileAccess syncFileAccess = new SyncFileAccess(new File(request.getPath1()));
            rafL = syncFileAccess.openLockRandomAccessFile("rw", 1000, false);
            raf = rafL != null ? rafL.getRandomAccessFile() : new RandomAccessFile(request.getPath1(), "rw");
            is = new ByteArrayInputStream(request.getData());
            if (request.getOffset() >= 0L) {
                raf.seek(request.getOffset());
            } else {
                raf.seek(raf.length());
            }
            byte[] data = new byte[request.getData().length];
            int n = is.read(data);
            while (n >= 0) {
                raf.write(data, 0, n);
                n = is.read(data);
            }
        }
        catch (IOException ex) {
            Trace.ignoredException(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rafL != null) {
                    rafL.release();
                }
                if (is != null) {
                    is.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException ex) {
                Trace.ignoredException(ex);
            }
        }
        return true;
    }

    private boolean deleteFile(Request request) {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        File file = new File(request.getPath1());
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    private boolean deleteOnExitFile(Request request) {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        File file = new File(request.getPath1());
        if (file.exists()) {
            file.deleteOnExit();
        }
        return true;
    }

    private boolean renameFile(Request request) {
        if (!this.verifyFilePath(request.getPath1()) || !this.isValidCacheEntryPath(request.getPath1()) || this.isLAPFile(request.getPath1()) || !this.verifyFilePath(request.getPath2()) || !this.isValidCacheEntryPath(request.getPath2()) || this.isLAPFile(request.getPath2())) {
            return false;
        }
        File from = new File(request.getPath1());
        File to = new File(request.getPath2());
        return from.renameTo(to);
    }

    private boolean showDocument(Request request) {
        String url = request.getPath1();
        for (int i = 0; i < showDocumentWhiteList.length; ++i) {
            if (!showDocumentWhiteList[i].equals(url)) continue;
            Platform.get().showDocument(url);
            return true;
        }
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.showDocument(url);
    }

    private String openFileDialog(Request request) {
        if (jnlpService == null) {
            return null;
        }
        String file = jnlpService.openFileDialog(request.getPath1(), request.getStrings());
        if (file != null) {
            verifiedPaths.add(file);
        }
        return file;
    }

    private String[] openMultiFileDialog(Request request) {
        if (jnlpService == null) {
            return null;
        }
        String[] files = jnlpService.openMultiFileDialog(request.getPath1(), request.getStrings());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                verifiedPaths.add(files[i]);
            }
        }
        return files;
    }

    private String saveFile(Request request) {
        if (jnlpService == null) {
            return null;
        }
        String file = jnlpService.saveFile(request.getPath1(), request.getStrings(), request.getPath2());
        if (file != null) {
            verifiedPaths.add(file);
        }
        return file;
    }

    private NativeSandboxBroker.RAF sendRAF(Request request) {
        NativeSandboxBroker.RAF raf = request.getRAF();
        if (raf == null) {
            return null;
        }
        if (!this.verifyFilePath(raf.getFile()) || this.isValidCacheEntryPath(raf.getFile())) {
            return null;
        }
        NativeSandboxBroker.RAF rafResponse = new NativeSandboxBroker.RAF(raf.getCommand(), null);
        RandomAccessFile rafFile = rafsFile.get(raf.getFile());
        if (rafFile == null) {
            try {
                rafFile = new RandomAccessFile(raf.getFile(), "rw");
            }
            catch (FileNotFoundException ex) {
                rafResponse.setIOException(ex.getMessage());
                return rafResponse;
            }
            rafsFile.put(raf.getFile(), rafFile);
        }
        try {
            switch (raf.getCommand()) {
                case 0: {
                    rafFile.close();
                    rafsFile.remove(raf.getFile());
                    break;
                }
                case 1: {
                    rafResponse.setLongValue(rafFile.getFilePointer());
                    break;
                }
                case 2: {
                    rafResponse.setLongValue(rafFile.length());
                    break;
                }
                case 3: {
                    int length = (int)raf.getLongValue();
                    if (length <= 0) {
                        throw new IOException("b.length <= 0");
                    }
                    byte[] data = new byte[length];
                    rafFile.read(data);
                    rafResponse.setData(data);
                    break;
                }
                case 4: {
                    rafResponse.setString(rafFile.readLine());
                    break;
                }
                case 5: {
                    rafResponse.setString(rafFile.readUTF());
                    break;
                }
                case 6: {
                    rafFile.seek(raf.getLongValue());
                    break;
                }
                case 7: {
                    rafFile.setLength(raf.getLongValue());
                    break;
                }
                case 8: {
                    int skipped = rafFile.skipBytes((int)raf.getLongValue());
                    rafResponse.setLongValue(skipped);
                    break;
                }
                case 9: {
                    rafFile.write(raf.getData());
                }
            }
        }
        catch (EOFException ex) {
            rafResponse.setEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            rafResponse.setIOException(ex.getMessage());
        }
        return rafResponse;
    }

    private boolean openFile(Request request) {
        if (jnlpService == null) {
            return false;
        }
        boolean result = jnlpService.openFile(request.getPath1());
        if (result) {
            verifiedPaths.add(request.getPath1());
        }
        return result;
    }

    private boolean openFiles(Request request) {
        if (jnlpService == null) {
            return false;
        }
        boolean result = jnlpService.openFiles(request.getStrings());
        if (result) {
            String[] files = request.getStrings();
            for (int i = 0; i < files.length; ++i) {
                verifiedPaths.add(files[i]);
            }
        }
        return result;
    }

    private boolean removeAssociation(Request request) {
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.removeAssociation(request.getPath1(), request.getStrings());
    }

    private boolean removeShortcuts(Request request) {
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.removeShortcuts();
    }

    private boolean requestAssociation(Request request) {
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.requestAssociation(request.getPath1(), request.getStrings());
    }

    private boolean requestShortcut(Request request) {
        if (jnlpService == null) {
            return false;
        }
        byte[] data = request.getData();
        if (data == null || data.length != 2) {
            return false;
        }
        boolean desktop = data[0] == 1;
        boolean menu = data[1] == 1;
        String submenu = request.getPath1();
        return jnlpService.requestShortcut(desktop, menu, submenu);
    }

    private long createMuffin(Request request) throws IOException {
        if (jnlpService == null) {
            return 0L;
        }
        String url = request.getPath1();
        long maxsize = request.getOffset();
        return jnlpService.createMuffin(url, maxsize);
    }

    private void deleteMuffin(Request request) throws IOException {
        if (jnlpService == null) {
            // empty if block
        }
        String url = request.getPath1();
        jnlpService.deleteMuffin(url);
    }

    private String getMuffin(Request request) throws IOException {
        if (jnlpService == null) {
            return null;
        }
        String url = request.getPath1();
        String file = jnlpService.getMuffin(url);
        if (file != null) {
            verifiedPaths.add(file);
        }
        return file;
    }

    private void setMuffinTag(Request request) throws IOException {
        if (jnlpService == null) {
            // empty if block
        }
        String url = request.getPath1();
        int tag = request.getSize();
        jnlpService.setMuffinTag(url, tag);
    }

    private native void parentWindow0(long var1, long var3);

    private void parentWindow(Request request) {
        int appletID = request.getAppletID();
        Long parent = windowParents.get(appletID);
        if (parent == null) {
            return;
        }
        this.parentWindow0(parent, request.getChild());
    }

    private void setProperty(Request request) {
        switch (request.getIntValue()) {
            case 1: {
                Config.setBooleanProperty("deployment.deprecation.plugin.dialog.show", false);
            }
        }
        Config.get().storeIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParentWindow(int appletID, long parentNativeWindow) {
        Map<Integer, Long> map = windowParents;
        synchronized (map) {
            windowParents.put(appletID, parentNativeWindow);
        }
    }

    public static synchronized void setNativeSandboxJNLPService(NativeSandboxJNLPService service) {
        if (jnlpService == null) {
            jnlpService = service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(String path, byte[] data, long offset, boolean append) throws IOException {
        Object object = clientWriteLock;
        synchronized (object) {
            Response response;
            Request request = new Request(append ? 1 : 0);
            request.setPath1(path);
            request.setData(data);
            if (append) {
                request.setOffset(offset);
            }
            if ((response = this.sendRequest(request)) != null) {
                if (response.getException() != null) {
                    throw new IOException(response.getException());
                }
                return response.getBooleanResult();
            }
            return false;
        }
    }

    @Override
    public boolean writeFile(File file, byte[] data) throws IOException {
        if (file == null) {
            return false;
        }
        return this.writeFile(file.getAbsolutePath(), data, -1L, false);
    }

    @Override
    public boolean writeFile(RandomAccessFile raf, File file, long offset, byte[] data) throws IOException {
        if (file == null) {
            return false;
        }
        return this.writeFile(file.getAbsolutePath(), data, offset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(File file) {
        Object object = clientWriteLock;
        synchronized (object) {
            if (!file.exists()) {
                return false;
            }
            Request request = new Request(2);
            request.setPath1(file.getAbsolutePath());
            Response response = this.sendRequest(request);
            if (response != null) {
                return response.getBooleanResult();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteOnExitFile(File file) {
        Object object = clientWriteLock;
        synchronized (object) {
            if (!file.exists()) {
                return false;
            }
            Request request = new Request(3);
            request.setPath1(file.getAbsolutePath());
            Response response = this.sendRequest(request);
            if (response != null) {
                return response.getBooleanResult();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameFile(File fromFile, String toPath) {
        Object object = clientWriteLock;
        synchronized (object) {
            if (fromFile == null || toPath == null) {
                return false;
            }
            Request request = new Request(4);
            request.setPath1(fromFile.getAbsolutePath());
            request.setPath2(toPath);
            Response response = this.sendRequest(request);
            if (response != null) {
                return response.getBooleanResult();
            }
            return false;
        }
    }

    @Override
    public OutputStream getOutputStream(File file, boolean overwrite) throws IOException {
        if (file == null) {
            return null;
        }
        return new BufferedOutputStream(new NativeSandboxOutputStream(file.getAbsolutePath(), overwrite), 0x100000);
    }

    @Override
    public boolean showDocument(String url) {
        Request request = new Request(5);
        request.setPath1(url);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public String openFileDialog(String pathHint, String[] extensions) {
        Request request = new Request(7);
        request.setPath1(pathHint);
        request.setStrings(extensions);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getFileList()[0];
        }
        return null;
    }

    @Override
    public String[] openMultiFileDialog(String pathHint, String[] extensions) {
        Request request = new Request(8);
        request.setPath1(pathHint);
        request.setStrings(extensions);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getFileList();
        }
        return null;
    }

    @Override
    public String saveFile(String pathHint, String[] extensions, String filename) {
        Request request = new Request(9);
        request.setPath1(pathHint);
        request.setPath2(filename);
        request.setStrings(extensions);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getFileList()[0];
        }
        return null;
    }

    @Override
    public NativeSandboxBroker.RAF sendRAF(NativeSandboxBroker.RAF raf) {
        Request request = new Request(10);
        request.setRAF(raf);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getRAF();
        }
        return null;
    }

    @Override
    public boolean openFile(String file) {
        Request request = new Request(11);
        request.setPath1(file);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean openFiles(String[] files) {
        Request request = new Request(12);
        request.setStrings(files);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean removeAssociation(String mimetype, String[] extensions) {
        Request request = new Request(13);
        request.setPath1(mimetype);
        request.setStrings(extensions);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean removeShortcuts() {
        Request request = new Request(14);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean requestAssociation(String mimetype, String[] extensions) {
        Request request = new Request(15);
        request.setPath1(mimetype);
        request.setStrings(extensions);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean requestShortcut(boolean desktop, boolean menu, String submenu) {
        Request request = new Request(16);
        request.setPath1(submenu);
        byte[] data = new byte[]{desktop ? (byte)1 : 0, menu ? (byte)1 : 0};
        request.setData(data);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public long createMuffin(String url, long maxsize) throws IOException {
        Request request = new Request(17);
        request.setPath1(url);
        request.setOffset(maxsize);
        Response response = this.sendRequest(request);
        if (response != null) {
            if (response.getException() != null) {
                throw new IOException(response.getException());
            }
            return response.getLongResult();
        }
        return 0L;
    }

    @Override
    public void deleteMuffin(String url) throws IOException {
        Request request = new Request(19);
        request.setPath1(url);
        Response response = this.sendRequest(request);
        if (response != null && response.getException() != null) {
            throw new IOException(response.getException());
        }
    }

    @Override
    public String getMuffin(String url) throws IOException {
        Request request = new Request(18);
        request.setPath1(url);
        Response response = this.sendRequest(request);
        if (response != null) {
            if (response.getException() != null) {
                throw new IOException(response.getException());
            }
            return response.getFileList()[0];
        }
        return null;
    }

    @Override
    public void setMuffinTag(String url, int tag) throws IOException {
        Request request = new Request(20);
        request.setPath1(url);
        request.setSize(tag);
        Response response = this.sendRequest(request);
        if (response != null && response.getException() != null) {
            throw new IOException(response.getException());
        }
    }

    @Override
    public boolean parentWindow(int appletID, long child) {
        Request request = new Request(21);
        request.setAppletID(appletID);
        request.setChild(child);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean setProperty(int value) {
        Request request = new Request(22);
        request.setIntValue(value);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getObjectBytes(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutput objectOutput = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutput = new ObjectOutputStream(byteArrayOutputStream);
            objectOutput.flush();
            objectOutput.writeObject(object);
            objectOutput.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            Trace.ignoredException(ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (objectOutput != null) {
                try {
                    objectOutput.close();
                }
                catch (IOException ex) {
                    Trace.ignoredException(ex);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException ex) {
                    Trace.ignoredException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectFromBytes(byte[] bytes, int len, boolean privileged) {
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInput objectInput = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(bytes, 0, len);
            objectInput = new ObjectInputStream(byteArrayInputStream);
            if (privileged) {
                final ObjectInput oi = objectInput;
                Object object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException, ClassNotFoundException {
                        return oi.readObject();
                    }
                }, ACC_INSTANCE);
                return object;
            }
            Object oi = objectInput.readObject();
            return oi;
        }
        catch (IOException ex) {
            Trace.ignoredException(ex);
            Object var7_14 = null;
            return var7_14;
        }
        catch (ClassNotFoundException ex) {
            Trace.ignoredException(ex);
            Object var7_15 = null;
            return var7_15;
        }
        catch (PrivilegedActionException ex) {
            Trace.ignoredException(ex);
            Object var7_16 = null;
            return var7_16;
        }
        finally {
            if (objectInput != null) {
                try {
                    objectInput.close();
                }
                catch (IOException ex) {
                    Trace.ignoredException(ex);
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException ex) {
                    Trace.ignoredException(ex);
                }
            }
        }
    }

    static {
        RuntimePermission perm = new RuntimePermission("accessClassInPackage.com.sun.deploy.nativesandbox.comm");
        PermissionCollection perms = perm.newPermissionCollection();
        perms.add(perm);
        ACC_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        showDocumentWhiteList = new String[]{"http://bugs.sun.com", "http://www.java.com", "http://java.com/jcpsecurity", "http://java.com/nativesandbox", "http://java.com/sitelistfaq", "http://java.com/javaplugin"};
        denyLAPKeys = new String[]{"ssv.decision.all-perms.time", "ssv.enable.custom.preloader"};
        clientWriteLock = new Object();
        verifiedPaths = new ArrayList();
        rafsFile = new HashMap();
        windowParents = new HashMap<Integer, Long>();
    }
}

