/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.association.utility.WinRegistryWrapper;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.nativesandbox.IntegrityProcess;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.nativesandbox.NativeSandboxBrokerImpl;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemPropertyUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.WinRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public final class WinPlatform
extends Platform {
    private static final String SYSTEM_CONFIG_FILE_NAME = "\\Oracle\\Java\\java.settings.cfg";
    private static final String SPONSORS_KEY = "SPONSORS";
    private static final String SPONSORS_DISABLED_VALUE = "0";
    private String _userHome;
    private String _userHomeLocal;
    private String _userHomeRoaming;
    private String _systemHome;
    private String _osHome;
    private String _systemExeHome;
    private final Object sandboxLock = new Object();
    private boolean runInNativeSandbox = false;
    private boolean runInNativeSandboxIsSet = false;
    private long sandboxNativeWindowHandle = 0L;
    private static boolean _loaded = false;
    public static final String JRE_SUBKEY = "SOFTWARE\\JavaSoft\\JRE";
    private static final String OLD_JRE_SUBKEY = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    private static final String DEPLOYMENT_SUBKEY = "SOFTWARE\\JavaSoft\\Java Web Start";
    private static final String DEPLOYMENT_CACHE_UPGRADE_SUBKEY = "SOFTWARE\\JavaSoft\\Java Web Start\\Cache Upgrade";
    private static final String JAVA_HOME = "JavaHome";
    private static final String DEPLOYMENT_PROP_SUBKEY = "SOFTWARE\\JavaSoft\\DeploymentProperties";
    private static String SUN_JAVA_DEPLOYMENT = "Sun" + File.separator + "Java" + File.separator + "Deployment";
    private Process nativeSandboxProcess = null;
    private static final int[] DEFAULT_SIZES = new int[]{32, 16, 48, 64};
    private static final String SECURITY_BASELINE_SUBKEY = "SOFTWARE\\JavaSoft\\JRE\\Security Baseline";
    private static final int MAX_NAME_LENGTH = 2048;
    private WinWebJavaSwitch javaSwitch = new WinWebJavaSwitch();

    public WinPlatform() {
        this.loadDeployNativeLib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDeployNativeLib() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (_loaded) {
                return;
            }
            String dir = Environment.getDeploymentHome() + File.separator + "bin" + File.separator;
            String vclib = dir + BuiltInProperties.getProperty("MSVCR_DLL_NAME");
            try {
                if (new File(vclib).exists()) {
                    String vcplib;
                    System.load(vclib);
                    String msvcp = BuiltInProperties.getProperty("MSVCP_DLL_NAME");
                    if (!msvcp.isEmpty() && new File(vcplib = dir + msvcp).exists()) {
                        System.load(vcplib);
                    }
                } else {
                    vclib = dir + "msvcr71.dll";
                    System.load(vclib);
                }
            }
            catch (UnsatisfiedLinkError e) {
                Trace.ignored(e);
            }
            try {
                System.load(dir + "deploy.dll");
            }
            catch (UnsatisfiedLinkError e) {
                Trace.ignored(e);
            }
            _loaded = true;
        }
    }

    @Override
    public String getNativeLibPath() {
        return "bin" + File.separator + "deploy.dll";
    }

    @Override
    public void resetJavaHome() {
        String path;
        String version = WinRegistry.getString(-2147483646, JRE_SUBKEY, "CurrentVersion");
        if (version != null && (path = WinRegistry.getString(-2147483646, "SOFTWARE\\JavaSoft\\JRE\\" + version, JAVA_HOME)) != null) {
            Trace.println("_javaHome set to: " + path, TraceLevel.NETWORK);
            Environment.setJavaHome(path);
        }
    }

    @Override
    public String getSecureLauncherName() {
        return "jweblauncher.exe";
    }

    @Override
    void setDefaultConfigProperties(DefaultConfig inConfig) {
        inConfig.setProperty("deployment.system.tray.icon", "false");
    }

    public String escapeBackslashAndQuoteString(String in) {
        if (in == null) {
            return in;
        }
        StringBuffer e = new StringBuffer();
        e.append("\"");
        for (int i = 0; i < in.length(); ++i) {
            char a = in.charAt(i);
            if (a == '\\') {
                e.append('\\');
            }
            e.append(a);
        }
        e.append("\"");
        return e.toString();
    }

    @Override
    public String getPlatformNativeEncoding() {
        return "UTF-16LE";
    }

    private String getPendingDeploymentPropSubKey() {
        return "SOFTWARE\\JavaSoft\\DeploymentProperties\\pending";
    }

    private String getDeploymentPropSubKey() {
        return DEPLOYMENT_PROP_SUBKEY;
    }

    @Override
    long getUserDeploymentPropCacheTimestamp() {
        String timeS = WinRegistryWrapper.WinRegQueryValueEx(-2147483647, this.getDeploymentPropSubKey(), "deployment.modified.timestamp");
        try {
            return Long.parseLong(timeS);
        }
        catch (NumberFormatException nfe) {
            Trace.ignored(nfe);
            return -1L;
        }
    }

    @Override
    long getSysDeploymentPropCacheTimestamp() {
        String timeS = WinRegistryWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Oracle\\JavaDeploy", "deployment.modified.timestamp");
        try {
            return Long.parseLong(timeS);
        }
        catch (NumberFormatException nfe) {
            Trace.ignored(nfe);
            return -1L;
        }
    }

    @Override
    public synchronized String getUserHome() {
        if (this._userHome == null) {
            File logDir;
            String profile = SystemPropertyUtil.getProperty("javaplugin.user.profile");
            if (profile == null || profile.trim().equals("")) {
                String buserHome = this.getPlatformUserHome();
                profile = buserHome != null ? buserHome : SystemPropertyUtil.getProperty("user.home");
            }
            this._userHome = profile + (profile.endsWith(File.separator) ? "" : File.separator) + SUN_JAVA_DEPLOYMENT;
            File homeDir = new File(this._userHome);
            if (!homeDir.exists()) {
                homeDir.mkdirs();
            }
            if (!(logDir = new File(this._userHome + File.separator + "log")).exists()) {
                logDir.mkdirs();
            }
            this.verifyPermissionsForFileSystem(homeDir, logDir);
        }
        return this._userHome;
    }

    @Override
    public String getLocalStorageDir() {
        String path;
        String os;
        if (this._userHomeLocal == null && (os = System.getProperty("os.name").toLowerCase()).startsWith("windows xp") && (path = WinRegistryWrapper.WinRegQueryValueEx(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Local AppData")) != null) {
            this._userHomeLocal = path + File.separator + SUN_JAVA_DEPLOYMENT;
        }
        if (this._userHomeLocal == null) {
            this._userHomeLocal = this.getUserHome();
        }
        return this._userHomeLocal;
    }

    @Override
    public String getRoamingUserHome() {
        String profile;
        if (this._userHomeRoaming == null && (profile = this.getPlatformRoamingUserDir()) != null) {
            String path = profile + (profile.endsWith(File.separator) ? "" : File.separator) + SUN_JAVA_DEPLOYMENT;
            File userHomeDir = new File(path);
            if (!userHomeDir.exists()) {
                userHomeDir.mkdirs();
            }
            if (WinPlatform.isLowIntegrityPath(path) && !WinPlatform.setMediumIntegrityLabel(path)) {
                Trace.println("setMediumIntegrityLabel() for " + path + " failed", TraceLevel.BASIC);
            }
            this._userHomeRoaming = path;
        }
        return this._userHomeRoaming;
    }

    @Override
    public String getDefaultSystemCache() {
        return this.getLocalStorageDir() + File.separator + "SystemCache";
    }

    @Override
    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = this.getPlatformSystemHome() + File.separator + "Sun" + File.separator + "Java" + File.separator + "Deployment";
        }
        return this._systemHome;
    }

    @Override
    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = this.getPlatformSystemHome();
        }
        return this._osHome;
    }

    private static String replace(String input, String oldPattern, String newPattern) {
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = input.indexOf(oldPattern, startIdx)) >= 0) {
            result.append(input.substring(startIdx, idxOld));
            result.append(newPattern);
            startIdx = idxOld + oldPattern.length();
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }

    @Override
    public String getSystemJavawsPath() {
        String path;
        File execFile;
        if (this._systemExeHome == null) {
            this._systemExeHome = this.getSystemExecutableHome();
        }
        if ((execFile = new File(path = this._systemExeHome + File.separator + "javaws.exe")).exists()) {
            return execFile.getPath();
        }
        return Environment.getJavawsCommand();
    }

    public long getSysStartupTime() {
        return System.currentTimeMillis() - this.getSysTickCount();
    }

    @Override
    public String getPlatformExtension() {
        return ".exe";
    }

    @Override
    public String toExecArg(String path) {
        return "\"" + path + "\"";
    }

    @Override
    public String getLibraryPrefix() {
        return "";
    }

    @Override
    public String getLibrarySufix() {
        return ".dll";
    }

    @Override
    public boolean useAltFileSystemView() {
        return true;
    }

    @Override
    public boolean systemLookAndFeelDefault() {
        return true;
    }

    @Override
    public String getPlatformSpecificJavaName() {
        return "javaw.exe";
    }

    @Override
    public String getSessionSpecificString() {
        return "-" + System.getProperty("os.arch");
    }

    @Override
    public String getDebugJavaPath(String path) {
        return path.substring(0, path.lastIndexOf(".")).concat(".exe");
    }

    @Override
    public String getMozillaUserProfileDirectory() {
        String appDataDir = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String mozillaUserProfileDir = null;
        if (appDataDir != null) {
            try {
                File regFile = new File(appDataDir + "\\Mozilla\\registry.dat");
                if (regFile.exists()) {
                    mozillaUserProfileDir = NSPreferences.getNS6UserProfileDirectory(regFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return mozillaUserProfileDir;
    }

    private static native boolean isLowIntegrityPath(String var0);

    private static native boolean isMediumIntegrityPath(String var0);

    private static native boolean setLowIntegrityLabel(String var0);

    private static native boolean setMediumIntegrityLabel(String var0);

    public void verifyPermissionsForFileSystem(File home, File log) {
        if (WinPlatform.isLowIntegrityPath(home.getAbsolutePath()) && !WinPlatform.setMediumIntegrityLabel(home.getAbsolutePath())) {
            Trace.println("setMediumIntegrityLabel() failed", TraceLevel.BASIC);
        }
        if (WinPlatform.isMediumIntegrityPath(log.getAbsolutePath()) && !WinPlatform.setLowIntegrityLabel(log.getAbsolutePath())) {
            Trace.println("setMediumIntegrityLabel() failed", TraceLevel.BASIC);
        }
    }

    private native long prepareWaitForProcessToValidateParent();

    private native void waitForProcessToValidateParent(long var1);

    @Override
    public Process startProcessBuilder(ProcessBuilder builder) throws IOException {
        Process process;
        boolean waitForProcessToValidateParent = false;
        long waitHandle = 0L;
        List<String> command = builder.command();
        if (this.runInNativeSandbox) {
            waitForProcessToValidateParent = true;
        } else {
            for (int i = 1; i < command.size(); ++i) {
                String arg = command.get(i);
                if (!arg.equals("-ta") && !arg.equals("-javaws") && !arg.equals("-checkParent")) continue;
                waitForProcessToValidateParent = true;
                break;
            }
        }
        if (waitForProcessToValidateParent) {
            waitHandle = this.prepareWaitForProcessToValidateParent();
        }
        if (this.runInNativeSandbox) {
            process = IntegrityProcess.getIntegrityProcess(command);
        } else {
            WinPlatform.validateProcessBuilder(builder.command());
            process = builder.start();
        }
        if (waitForProcessToValidateParent) {
            this.waitForProcessToValidateParent(waitHandle);
        }
        if (this.runInNativeSandbox) {
            this.nativeSandboxProcess = process;
        }
        return process;
    }

    @Override
    public void checkAndUpdateSandboxWindow(boolean force) {
        if (force || this.runInNativeSandboxIsSet && this.runInNativeSandbox && this.sandboxNativeWindowHandle != 0L) {
            this.UpdateSandboxWindow(this.sandboxNativeWindowHandle);
            this.runInNativeSandboxIsSet = false;
            this.sandboxNativeWindowHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRunInNativeSandbox(boolean runInNativeSandbox) {
        Object object = this.sandboxLock;
        synchronized (object) {
            if (runInNativeSandbox) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                IntegrityProcess.setClassLoader(loader);
            }
            this.runInNativeSandbox = runInNativeSandbox;
            this.runInNativeSandboxIsSet = true;
            this.checkAndUpdateSandboxWindow(false);
        }
    }

    @Override
    public boolean getRunInNativeSandbox() {
        return this.runInNativeSandbox;
    }

    @Override
    public boolean isNativeSandbox() {
        return IntegrityProcess.getIntegrityLevel() == 1;
    }

    @Override
    public boolean getUseNativeSandboxWindow() {
        return Config.useNativeSandbox(null);
    }

    private native long CreateSandboxParentWindow0(long var1);

    private native void UpdateSandboxWindow(long var1);

    private native void RunSandboxWindowLoop();

    private long CreateSandboxParentWindow(final long parentNativeWindow) {
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = WinPlatform.this.sandboxLock;
                synchronized (object) {
                    WinPlatform.this.sandboxNativeWindowHandle = WinPlatform.this.CreateSandboxParentWindow0(parentNativeWindow);
                }
                latch.countDown();
                WinPlatform.this.RunSandboxWindowLoop();
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Trace.ignored(ex);
        }
        return this.sandboxNativeWindowHandle;
    }

    @Override
    public long createNativeWindowSandboxHandle(long handle) {
        return this.CreateSandboxParentWindow(handle);
    }

    private native void setNativeSandboxWindowSize0(long var1, int var3, int var4);

    @Override
    public void setNativeSandboxWindowSize(long handle, int width, int height) {
        this.setNativeSandboxWindowSize0(handle, width, height);
    }

    private synchronized boolean initNativeSandboxBroker() {
        if (this.sandboxBroker == null) {
            String prop = SystemUtils.priviledgedGetSystemProperty("NSBRP");
            if (prop == null) {
                return false;
            }
            long readPipe = Long.parseLong(prop);
            prop = SystemUtils.priviledgedGetSystemProperty("NSBWP");
            if (prop == null) {
                return false;
            }
            long writePipe = Long.parseLong(prop);
            this.sandboxBroker = new NativeSandboxBrokerImpl(readPipe, writePipe);
        }
        return true;
    }

    @Override
    public NativeSandboxBroker getNativeSandboxBroker() {
        if (this.isNativeSandbox()) {
            if (this.initNativeSandboxBroker()) {
                return this.sandboxBroker;
            }
            return null;
        }
        return super.getNativeSandboxBroker();
    }

    @Override
    public void setNativeSandboxJNLPService(NativeSandboxJNLPService service) {
        NativeSandboxBrokerImpl.setNativeSandboxJNLPService(service);
    }

    @Override
    public void addParentWindow(int appletID, long parentNativeWindow) {
        NativeSandboxBrokerImpl.addParentWindow(appletID, parentNativeWindow);
    }

    @Override
    public void waitForNativeSandboxProcess() {
        if (this.nativeSandboxProcess != null) {
            try {
                this.nativeSandboxProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nativeSandboxProcess = null;
        }
    }

    private static native boolean isScreenLockedNative();

    @Override
    public boolean isScreenLocked() {
        boolean result = WinPlatform.isScreenLockedNative();
        if (DEBUG) {
            Trace.println("WinPlatform:isScreenLocked() result: " + result);
        }
        return result;
    }

    @Override
    public String getFireFoxUserProfileDirectory() {
        String appDataDir = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String fireFoxUserProfileDir = null;
        if (appDataDir != null) {
            try {
                File iniFile = new File(appDataDir + "\\Mozilla\\Firefox\\profiles.ini");
                if (iniFile.exists()) {
                    fireFoxUserProfileDir = NSPreferences.getFireFoxUserProfileDirectory(iniFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fireFoxUserProfileDir;
    }

    @Override
    public boolean canAutoDownloadJRE() {
        return this.canBecomeAdmin();
    }

    @Override
    public int[] getIconSizes() {
        return (int[])DEFAULT_SIZES.clone();
    }

    @Override
    public int getSystemShortcutIconSize(boolean isDesktop) {
        if (isDesktop) {
            int size = this.getDesktopIconSize();
            if (size >= 16 && size <= 64) {
                return size;
            }
            return 48;
        }
        return 16;
    }

    @Override
    public List<JREInfo> getInstalledJREList() {
        ArrayList<JREInfo> jreList = new ArrayList<JREInfo>();
        this.extractInstalledJREListForRegistryView(jreList, true);
        this.extractInstalledJREListForRegistryView(jreList, false);
        return jreList;
    }

    private void extractInstalledJREListForRegistryView(List<JREInfo> jreList, boolean is32bit) {
        int registryViewAccessFlag = is32bit ? 512 : 256;
        for (String subkey : new String[]{JRE_SUBKEY, OLD_JRE_SUBKEY}) {
            String subKeyName;
            int subKeyIndex = 0;
            while ((subKeyName = WinRegistryWrapper.WinRegEnumKeyEx(-2147483646, subkey, subKeyIndex, 255, 0x20019 | registryViewAccessFlag)) != null) {
                String javaHomePath = WinRegistryWrapper.WinRegQueryValueEx(-2147483646, subkey + "\\" + subKeyName, JAVA_HOME, 0x20019 | registryViewAccessFlag);
                JREInfo jre = new JREInfo(null, subKeyName, null, javaHomePath != null ? javaHomePath : "", "", Config.getOSName(), is32bit ? "x86" : "x86_64", true, true);
                jreList.add(jre);
                ++subKeyIndex;
            }
        }
    }

    @Override
    public String getUserHomeOverride() {
        return Environment.getenv("USERPROFILE");
    }

    @Override
    public void setUserHomeOverride(String userHome) {
        Properties systemProps = System.getProperties();
        systemProps.put("user.home", userHome);
    }

    @Override
    public boolean samePaths(String path1, String path2) {
        try {
            return new File(path1.toLowerCase()).getCanonicalPath().equals(new File(path2.toLowerCase()).getCanonicalPath());
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public long getNativePID() {
        return this.getPlatformPID();
    }

    @Override
    public boolean isLocalInstallSupported() {
        return true;
    }

    @Override
    public boolean isPlatformIconType(String name) {
        return name.toLowerCase().endsWith(".ico");
    }

    @Override
    public void storeCacheUpgradeInfo(Properties info) {
        if (info == null) {
            WinRegistry.deleteKey(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY);
            return;
        }
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = info.getProperty(name);
            if (value == null) continue;
            WinRegistry.setStringValue(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY, name, value);
        }
    }

    @Override
    public Properties getCacheUpgradeInfo(String[] names) {
        Properties info = new Properties();
        for (int i = 0; i < names.length; ++i) {
            String value = WinRegistry.getString(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY, names[i]);
            if (value == null) continue;
            info.setProperty(names[i], value);
        }
        return info;
    }

    @Override
    public boolean getSponsorOffersDisabledSettings() {
        Properties props = this.readSystemConfig();
        return SPONSORS_DISABLED_VALUE.equals(props.getProperty(SPONSORS_KEY));
    }

    @Override
    public void enableSponsorOffering(boolean enable) {
        this.enableSponsorOfferingImpl(enable);
    }

    @Override
    public void enableRoamingProfile(boolean enable) {
        File roamingPropertiesFile = new File(Config.getRoamingUserPropertiesFile());
        File localPropertiesFile = new File(Config.getUserPropertiesFile());
        File localSecurityDir = new File(localPropertiesFile.getParentFile(), "security");
        File roaminglSecurityDir = new File(roamingPropertiesFile.getParentFile(), "security");
        try {
            if (enable && !roamingPropertiesFile.exists()) {
                if (localPropertiesFile.exists()) {
                    roamingPropertiesFile.getParentFile().mkdirs();
                    Cache.copyFile(localPropertiesFile, roamingPropertiesFile);
                } else {
                    roamingPropertiesFile.createNewFile();
                }
                if (localSecurityDir.exists()) {
                    WinPlatform.copyDirIgnoresErrors(localSecurityDir, roaminglSecurityDir);
                }
                Config.getExceptionSitesFile().getParentFile().mkdirs();
            }
            if (!enable && roamingPropertiesFile.exists()) {
                localPropertiesFile.getParentFile().mkdirs();
                Cache.copyFile(roamingPropertiesFile, localPropertiesFile);
                roamingPropertiesFile.delete();
                if (roaminglSecurityDir.exists()) {
                    WinPlatform.copyDirIgnoresErrors(roaminglSecurityDir, localSecurityDir);
                }
            }
        }
        catch (IOException e) {
            Trace.ignored(e);
        }
    }

    protected static void copyDirIgnoresErrors(File src, File dst) {
        if (src.isDirectory()) {
            dst.mkdirs();
            File[] files = src.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File source = files[i];
                File target = new File(dst, source.getName());
                if (files[i].isDirectory()) continue;
                try {
                    Cache.copyFile(source, target);
                    continue;
                }
                catch (IOException e) {
                    Trace.ignored(e);
                }
            }
        }
    }

    private native void enableSponsorOfferingImpl(boolean var1);

    private Properties readSystemConfig() {
        File configFile = new File(this.getPlatformCommonAppDir() + SYSTEM_CONFIG_FILE_NAME);
        Properties props = new Properties();
        try {
            props.load(new FileReader(configFile));
        }
        catch (FileNotFoundException e) {
            Trace.ignored(e);
        }
        catch (IOException e) {
            Trace.ignored(e);
        }
        return props;
    }

    @Override
    public void cacheSecurityBaseline(String familyVersion, String securityBaseline) {
        if (familyVersion != null && securityBaseline != null && WinRegistryWrapper.WinRegCreateNoReflectionKey(-2147483647, SECURITY_BASELINE_SUBKEY) == 0) {
            WinRegistryWrapper.WinRegSetValueEx(-2147483647, SECURITY_BASELINE_SUBKEY, familyVersion, securityBaseline);
        }
    }

    @Override
    public String getJucheckPath() {
        String path = WinRegistry.getString(-2147483646, "Software\\Microsoft\\Windows\\CurrentVersion", "CommonFilesDir (x86)");
        if (path == null) {
            path = WinRegistry.getString(-2147483646, "Software\\Microsoft\\Windows\\CurrentVersion", "CommonFilesDir");
        }
        return path + File.separator + "Java" + File.separator + "Java Update" + File.separator + "jucheck.exe";
    }

    @Override
    public Properties getPendingConfigProperties() {
        int valueIndex = 0;
        String name = WinRegistryWrapper.WinRegEnumValue(-2147483647, this.getPendingDeploymentPropSubKey(), valueIndex, 2048);
        Properties p = null;
        while (name != null) {
            String value = WinRegistryWrapper.WinRegQueryValueEx(-2147483647, this.getPendingDeploymentPropSubKey(), name);
            if (p == null) {
                p = new Properties();
            }
            p.put(name, value);
            name = WinRegistryWrapper.WinRegEnumValue(-2147483647, this.getPendingDeploymentPropSubKey(), ++valueIndex, 2048);
        }
        return p;
    }

    @Override
    public void cacheCurrentConfig(Properties p) {
        if (Platform.get().isNativeSandbox()) {
            return;
        }
        if (p == null) {
            return;
        }
        WinRegistryWrapper.WinRegDeleteKey(-2147483647, this.getDeploymentPropSubKey());
        Enumeration<Object> enumeration = p.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = p.getProperty(name);
            if (WinRegistryWrapper.WinRegCreateNoReflectionKey(-2147483647, this.getDeploymentPropSubKey()) != 0) continue;
            WinRegistryWrapper.WinRegSetValueEx(-2147483647, this.getDeploymentPropSubKey(), name, value);
        }
    }

    @Override
    public Platform.WebJavaSwitch getWebJavaSwitch() {
        return this.javaSwitch;
    }

    @Override
    public boolean isCompatibleArch(String arch1, String arch2) {
        return arch1.equals(arch2) || this.isSystem64Bit() && ("x86".equals(arch1) || "x86_64".equals(arch1)) && ("x86".equals(arch2) || "x86_64".equals(arch2));
    }

    @Override
    public native boolean shouldPromptForAutoCheck();

    @Override
    public native void handleUserResponse(int var1);

    @Override
    public native boolean canBecomeAdmin();

    @Override
    public native boolean hasAdminPrivileges();

    @Override
    public native String getLongPathName(String var1);

    @Override
    public native void onLoad(Object var1);

    @Override
    public native void onSave(Object var1);

    private native long getSysTickCount();

    @Override
    public boolean showDocument(String url) {
        if (IntegrityProcess.getIntegrityLevel() == 1) {
            if (this.initNativeSandboxBroker()) {
                return this.sandboxBroker.showDocument(url);
            }
            return false;
        }
        return super.showDocument(url);
    }

    @Override
    public void openControlPanel(String[] args) {
        WinPlatform.nativeOpenControlPanel(args);
    }

    private static native void nativeOpenControlPanel(String[] var0);

    @Override
    public native String getBrowserPath();

    @Override
    public native String getBrowserHomePath();

    @Override
    public native boolean isNativeModalDialogUp();

    @Override
    public native int getPlatformMaxCommandLineLength();

    @Override
    public native int updateShortcut(String var1, String var2);

    @Override
    public native int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    @Override
    public native String getShortcutJnlpName(String var1);

    @Override
    public native void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    @Override
    public native void addRemoveProgramsRemove(String var1, boolean var2);

    public native boolean isPlatformWindows8orLater();

    @Override
    public native boolean isBrowserFireFox();

    public native boolean isProcessWow64();

    public native boolean isSystem64Bit();

    public native String getPlatformUserHome();

    public native String getPlatformUserLocalDir();

    public native String getPlatformRoamingUserDir();

    public native String getPlatformCommonAppDir();

    private native String getPlatformSystemHome();

    private native String getSystemExecutableHome();

    protected native long getPlatformPID();

    protected native int getDesktopIconSize();

    @Override
    public native String getLoadedNativeLibPath(String var1);

    public static final class WinWebJavaSwitch
    extends Platform.WebJavaSwitch {
        private WinWebJavaSwitch() {
        }

        @Override
        protected boolean isSystemWebJavaEnabled() {
            String disabled = WinRegistry.getString(-2147483646, "Software\\Oracle\\JavaDeploy", "WebDeployJava");
            return !"disabled".equals(disabled);
        }

        @Override
        protected void setSystemWebJavaEnabled(boolean enabled) {
            this.setSystemWebJavaEnabledImpl(enabled);
        }

        private native void setSystemWebJavaEnabledImpl(boolean var1);
    }
}

