/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CacheUpgrader;
import com.sun.deploy.trace.Trace;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;

class Cache6Upgrader
extends CacheUpgrader {
    static final String CACHE_6_UPGRADER_NAME = "Cache6Upgrader";
    static final String SYSTEM_CACHE_6_UPGRADER_NAME = "SystemCache6Upgrader";

    private Cache6Upgrader(String name, File oldCache6Dir, File cacheDir) {
        super(name, oldCache6Dir, cacheDir);
    }

    static Cache6Upgrader createInstance(boolean system, File oldDir, File newDir) {
        String upgraderName = CACHE_6_UPGRADER_NAME;
        if (system) {
            upgraderName = SYSTEM_CACHE_6_UPGRADER_NAME;
        }
        return new Cache6Upgrader(upgraderName, oldDir, newDir);
    }

    @Override
    protected void upgradeImpl() {
        this.copySplashDir();
        this.copyMuffinDir();
        this.copyCacheEntries();
    }

    @Override
    protected CacheEntry upgradeItemImpl(URL itemRef, String version, int contentType) {
        CacheEntry oldEntry = this.getOldCacheEntry(itemRef, version, contentType);
        if (oldEntry == null) {
            if (Cache6Upgrader.isTracing()) {
                Cache6Upgrader.trace(this + ": found no old cache for: " + itemRef.toString() + " version: " + version + " contentType: " + contentType);
            }
            return null;
        }
        CacheEntry newEntry = this.copyToNewCache(oldEntry);
        if (Cache6Upgrader.isTracing()) {
            if (newEntry != null) {
                Cache6Upgrader.trace(this + " copied " + itemRef.toString() + " to: " + newEntry.getDataFile());
            } else {
                Cache6Upgrader.trace(this + " failed to copy: " + itemRef.toString());
            }
        }
        return newEntry;
    }

    private void copySplashDir() {
        File oldFlashDir = new File(this.oldCacheDir, "splash");
        File newFlashDir = new File(this.newCacheDir, "splash");
        Cache6Upgrader.copyDirIgnoresErrors(oldFlashDir, newFlashDir);
    }

    private void copyMuffinDir() {
        File old = new File(this.oldCacheDir, "muffin");
        File now = new File(this.newCacheDir, "muffin");
        Cache6Upgrader.copyDirIgnoresErrors(old, now, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                return name.toLowerCase().endsWith(".muf");
            }
        });
    }

    private void copyCacheEntries() {
        File[] idxFiles = Cache.getIndexFiles(this.oldCacheDir);
        for (int i = 0; i < idxFiles.length; ++i) {
            File indexFile = idxFiles[i];
            CacheEntry oldEntry = this.getCacheEntryFromIndexFile(indexFile);
            if (oldEntry == null) continue;
            try {
                if (this.resourcePresentInNewCache(new URL(oldEntry.getURL()))) continue;
                this.copyToNewCache(oldEntry);
                continue;
            }
            catch (Exception ex) {
                Trace.ignoredException(ex);
            }
        }
    }
}

