/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class MeteredFileOutputStream
extends OutputStream {
    static String _message = null;
    private final FileContentsImpl _contents;
    private long _written = 0L;
    private final FileOutputStream _fis;

    MeteredFileOutputStream(File file, boolean append, FileContentsImpl callback) throws IOException {
        this._fis = new FileOutputStream(file.getAbsolutePath(), append);
        this._contents = callback;
        this._written = file.length();
        if (_message == null) {
            _message = ResourceManager.getString((String)"api.persistence.filesizemessage");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkWrite(1);
        this._fis.write(b);
        ++this._written;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkWrite(len);
        this._fis.write(b, off, len);
        this._written += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this._fis.close();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this._fis.flush();
        super.flush();
    }

    private void checkWrite(int len) throws IOException {
        if (len < 0 || this._contents.getMaxLength() - this._written < (long)len) {
            throw new IOException(_message);
        }
    }
}

