/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.jar.Manifest;

public abstract class Resource {
    public abstract String getName();

    public abstract URL getURL();

    public abstract URL getCodeSourceURL();

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] b;
        try (InputStream in = this.getInputStream();){
            int len;
            if (len != -1) {
                int n;
                b = new byte[len];
                for (len = this.getContentLength(); len > 0; len -= n) {
                    n = in.read(b, b.length - len, len);
                    if (n != -1) continue;
                    throw new IOException("unexpected EOF");
                }
            } else {
                byte[] tmp;
                b = new byte[1024];
                int total = 0;
                while ((len = in.read(b, total, b.length - total)) != -1) {
                    if ((total += len) < b.length) continue;
                    tmp = new byte[total * 2];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
                if (total != b.length) {
                    tmp = new byte[total];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
            }
        }
        return b;
    }

    public Manifest getManifest() throws IOException {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public CodeSigner[] getCodeSigners() {
        return null;
    }
}

