/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.MissingFieldException;
import java.net.MalformedURLException;
import java.net.URL;

public class XMLUtils {
    public static int getIntAttribute(String source, XMLNode root, String path, String name, int defaultvalue) throws BadFieldException {
        String value = XMLUtils.getAttribute(root, path, name);
        if (value == null) {
            return defaultvalue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new BadFieldException(source, XMLUtils.getPathString(root) + path + name, value);
        }
    }

    public static String getAttribute(XMLNode root, String path, String name) throws BadFieldException {
        return XMLUtils.getAttribute(root, path, name, null);
    }

    public static String getRequiredAttributeEmptyOK(String source, XMLNode root, String path, String name) throws MissingFieldException {
        String value = null;
        XMLNode elem = XMLUtils.findElementPath(root, path);
        if (elem != null) {
            value = elem.getAttribute(name);
        }
        if (value == null) {
            throw new MissingFieldException(source, XMLUtils.getPathString(root) + path + name);
        }
        return value;
    }

    public static String getClassName(String source, XMLNode root, String path, String name, boolean required) throws BadFieldException, MissingFieldException {
        String className = null;
        className = required ? XMLUtils.getRequiredAttribute(source, root, path, name) : XMLUtils.getAttribute(root, path, name);
        if (className != null && className.endsWith(".class")) {
            int i = className.lastIndexOf(".class");
            String cname = className.substring(0, i);
            Trace.println((String)("invalid class cname in jnlp file: " + className + " - using " + cname + " instead"), (TraceLevel)TraceLevel.BASIC);
            return cname;
        }
        return className;
    }

    public static String getRequiredAttribute(String source, XMLNode root, String path, String name) throws MissingFieldException, BadFieldException {
        String s = XMLUtils.getAttribute(root, path, name, null);
        if (s == null) {
            throw new MissingFieldException(source, XMLUtils.getPathString(root) + path + name);
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static String getAttribute(XMLNode root, String path, String name, String def) throws BadFieldException {
        XMLNode elem = XMLUtils.findElementPath(root, path);
        if (elem == null) {
            return def;
        }
        String value = elem.getAttribute(name);
        if (value != null && value.contains("\u0000")) {
            Trace.println((String)("invalid " + name + ": " + value + " - it contains null"), (TraceLevel)TraceLevel.SECURITY);
            throw new BadFieldException("", path + name, value);
        }
        return value == null || value.length() == 0 ? def : value;
    }

    public static URL getAttributeURL(String source, URL base, XMLNode root, String path, String name) throws BadFieldException {
        String value = XMLUtils.getAttribute(root, path, name);
        if (value == null) {
            return null;
        }
        try {
            int bang;
            if (value.startsWith("jar:") && (bang = value.indexOf("!/")) > 0) {
                String entry = value.substring(bang);
                String urlString = value.substring(4, bang);
                URL url = base == null ? new URL(urlString) : new URL(base, urlString);
                return new URL("jar:" + url.toString() + entry);
            }
            return base == null ? new URL(value) : new URL(base, value);
        }
        catch (MalformedURLException mue) {
            if (mue.getMessage().indexOf("https") != -1) {
                throw new BadFieldException(source, "<jnlp>", "https");
            }
            throw new BadFieldException(source, XMLUtils.getPathString(root) + path + name, value);
        }
    }

    public static URL getAttributeURL(String source, XMLNode root, String path, String name) throws BadFieldException {
        return XMLUtils.getAttributeURL(source, null, root, path, name);
    }

    public static URL getRequiredURL(String source, URL base, XMLNode root, String path, String name) throws BadFieldException, MissingFieldException {
        URL url = XMLUtils.getAttributeURL(source, base, root, path, name);
        if (url == null) {
            throw new MissingFieldException(source, XMLUtils.getPathString(root) + path + name);
        }
        return url;
    }

    public static URL getRequiredURL(String source, XMLNode root, String path, String name) throws BadFieldException, MissingFieldException {
        return XMLUtils.getRequiredURL(source, null, root, path, name);
    }

    public static boolean isElementPath(XMLNode root, String path) {
        return XMLUtils.findElementPath(root, path) != null;
    }

    public static URL getElementURL(String source, XMLNode root, String path) throws BadFieldException {
        String value = XMLUtils.getElementContents(root, path);
        try {
            return new URL(value);
        }
        catch (MalformedURLException mue) {
            throw new BadFieldException(source, XMLUtils.getPathString(root) + path, value);
        }
    }

    public static String getPathString(XMLNode e) {
        return e == null || !e.isElement() ? "" : XMLUtils.getPathString(e.getParent()) + "<" + e.getName() + ">";
    }

    public static String getElementContentsWithAttribute(XMLNode root, String path, String attr, String val, String defaultvalue) throws BadFieldException, MissingFieldException {
        XMLNode e = XMLUtils.getElementWithAttribute(root, path, attr, val);
        if (e == null) {
            return defaultvalue;
        }
        return XMLUtils.getElementContents(e, "", defaultvalue);
    }

    public static URL getAttributeURLWithAttribute(String source, XMLNode root, String path, String attrcond, String val, String name, URL defaultvalue) throws BadFieldException, MissingFieldException {
        XMLNode e = XMLUtils.getElementWithAttribute(root, path, attrcond, val);
        if (e == null) {
            return defaultvalue;
        }
        URL url = XMLUtils.getAttributeURL(source, e, "", name);
        if (url == null) {
            return defaultvalue;
        }
        return url;
    }

    public static XMLNode getElementWithAttribute(XMLNode root, String path, final String attr, final String val) throws BadFieldException, MissingFieldException {
        final XMLNode[] result = new XMLNode[]{null};
        XMLUtils.visitElements(root, path, new ElementVisitor(){

            @Override
            public void visitElement(XMLNode e) throws BadFieldException, MissingFieldException {
                if (result[0] == null && e.getAttribute(attr).equals(val)) {
                    result[0] = e;
                }
            }
        });
        return result[0];
    }

    public static String getElementContents(XMLNode root, String path) {
        return XMLUtils.getElementContents(root, path, null);
    }

    public static String getElementContents(XMLNode root, String path, String defaultvalue) {
        XMLNode e = XMLUtils.findElementPath(root, path);
        if (e == null) {
            return defaultvalue;
        }
        XMLNode n = e.getNested();
        if (n != null && !n.isElement()) {
            return n.getName();
        }
        return defaultvalue;
    }

    public static XMLNode findElementPath(XMLNode elem, String path) {
        if (elem == null) {
            return null;
        }
        if (path == null || path.length() == 0) {
            return elem;
        }
        int idx = path.indexOf(62);
        if (path.charAt(0) != '<') {
            throw new IllegalArgumentException("bad path. Missing begin tag");
        }
        if (idx == -1) {
            throw new IllegalArgumentException("bad path. Missing end tag");
        }
        String head = path.substring(1, idx);
        String tail = path.substring(idx + 1);
        return XMLUtils.findElementPath(XMLUtils.findChildElement(elem, head), tail);
    }

    public static XMLNode findChildElement(XMLNode elem, String tag) {
        for (XMLNode n = elem.getNested(); n != null; n = n.getNext()) {
            if (!n.isElement() || !n.getName().equals(tag)) continue;
            return n;
        }
        return null;
    }

    public static void visitElements(XMLNode root, String path, ElementVisitor ev) throws BadFieldException, MissingFieldException {
        int idx = path.lastIndexOf(60);
        if (idx == -1) {
            throw new IllegalArgumentException("bad path. Must contain atleast one tag");
        }
        if (path.length() == 0 || path.charAt(path.length() - 1) != '>') {
            throw new IllegalArgumentException("bad path. Must end with a >");
        }
        String head = path.substring(0, idx);
        String tag = path.substring(idx + 1, path.length() - 1);
        XMLNode elem = XMLUtils.findElementPath(root, head);
        if (elem == null) {
            return;
        }
        for (XMLNode n = elem.getNested(); n != null; n = n.getNext()) {
            if (!n.isElement() || !n.getName().equals(tag)) continue;
            ev.visitElement(n);
        }
    }

    public static void visitChildrenElements(XMLNode elem, ElementVisitor ev) throws BadFieldException, MissingFieldException {
        for (XMLNode n = elem.getNested(); n != null; n = n.getNext()) {
            if (!n.isElement()) continue;
            ev.visitElement(n);
        }
    }

    public static abstract class ElementVisitor {
        public abstract void visitElement(XMLNode var1) throws BadFieldException, MissingFieldException;
    }
}

