/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

public class HtmlOptions {
    private static final String DOCBASE_KEY = "docbase";
    private static final String JNLPHREF_KEY = "jnlphref";
    private static final String EMBEDDED_KEY = "embedded";
    private static final String APPARG_KEY = "apparg";
    private static final String VMARG_KEY = "vmarg";
    private static final String PNAME_KEY = "name";
    private static final String PVALUE_KEY = "value";
    private String _embedded_jnlp = null;
    private String[] _htmlApplicationArgs = null;
    private String[] _htmlVmArgs = null;
    private Properties _htmlParameters;
    private URL _docbase = null;
    private String _jnlphref = null;
    private Properties rawProperties = null;
    static HtmlOptions theInstance = null;

    private HtmlOptions() {
    }

    private HtmlOptions(InputStream data) throws MalformedURLException, IOException {
        this.importProperties(data);
    }

    public static synchronized HtmlOptions get() {
        return theInstance;
    }

    public static synchronized HtmlOptions create(InputStream data) throws MalformedURLException, IOException {
        theInstance = new HtmlOptions(data);
        return theInstance;
    }

    public void export(OutputStream out) throws IOException {
        if (this.rawProperties != null) {
            OutputStreamWriter fw = new OutputStreamWriter(out);
            this.rawProperties.store(fw, null);
            fw.close();
        }
    }

    public synchronized void init(String launchFilePath) {
        theInstance = new HtmlOptions();
    }

    private byte[] readFully(InputStream data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int len = 0;
        byte[] buff = new byte[16384];
        while ((len = data.read(buff)) != -1) {
            bos.write(buff, 0, len);
        }
        data.close();
        return bos.toByteArray();
    }

    private void importProperties(InputStream dataStream) throws MalformedURLException, IOException {
        byte[] data = this.readFully(dataStream);
        this.rawProperties = this.load(data, Platform.get().getPlatformNativeEncoding());
        if (this.rawProperties.getProperty(DOCBASE_KEY) == null) {
            this.rawProperties = this.load(data, "UTF-8");
        }
        String docbase = this.rawProperties.getProperty(DOCBASE_KEY);
        this._jnlphref = this.rawProperties.getProperty(JNLPHREF_KEY);
        String embedded_jnlp = this.rawProperties.getProperty(EMBEDDED_KEY);
        this._htmlApplicationArgs = this.extractList(APPARG_KEY);
        this._htmlVmArgs = this.extractList(VMARG_KEY);
        this._htmlParameters = this.extractParameters();
        if (docbase != null && docbase.length() > 0) {
            this._docbase = new URL(docbase);
        }
        if (embedded_jnlp != null && embedded_jnlp.length() > 0) {
            this._embedded_jnlp = embedded_jnlp;
        }
    }

    private Properties extractParameters() {
        String nameKey;
        Properties params = new Properties();
        int i = 0;
        while (this.rawProperties.containsKey(nameKey = "name." + i)) {
            String valueKey = "value." + i;
            params.setProperty(this.rawProperties.getProperty(nameKey), this.rawProperties.getProperty(valueKey));
            ++i;
        }
        return params.isEmpty() ? null : params;
    }

    String[] extractList(String key) {
        String fullKey;
        String value;
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while ((value = this.rawProperties.getProperty(fullKey = key + "." + i)) != null) {
            al.add(value);
            ++i;
        }
        if (al.isEmpty() && this.rawProperties.getProperty(key + ".length") == null) {
            return null;
        }
        return al.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(byte[] inputData, String encoding) {
        ByteArrayInputStream is = null;
        InputStreamReader isr = null;
        try {
            is = new ByteArrayInputStream(inputData);
            isr = new InputStreamReader((InputStream)is, encoding);
            Properties p = new Properties();
            p.load(isr);
            Properties properties = p;
            return properties;
        }
        catch (Exception e) {
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException ioe) {
                    Trace.ignoredException((Exception)ioe);
                }
            } else if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioe) {
                    Trace.ignoredException((Exception)ioe);
                }
            }
        }
    }

    public String getEmbedded() {
        return this._embedded_jnlp;
    }

    public String[] getHtmlApplicationArgs() {
        return this._htmlApplicationArgs != null ? (String[])this._htmlApplicationArgs.clone() : null;
    }

    public String[] getHtmlVmArgs() {
        return this._htmlVmArgs != null ? (String[])this._htmlVmArgs.clone() : null;
    }

    public Properties getParameters() {
        return this._htmlParameters;
    }

    public String getAbsoluteHref(URL codebase) throws MalformedURLException {
        block3: {
            if (this._jnlphref != null && this._jnlphref.length() > 0) {
                try {
                    return new URL(this._jnlphref).toString();
                }
                catch (MalformedURLException mue) {
                    if (codebase == null) break block3;
                    boolean hasSlash = codebase.toString().endsWith("/");
                    return new URL(codebase.toString() + (hasSlash ? "" : "/") + this._jnlphref).toString();
                }
            }
        }
        return null;
    }

    public URL getDocBase() {
        return this._docbase;
    }
}

