/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import java.util.ArrayList;
import java.util.Arrays;

public class VersionID
implements Comparable<VersionID> {
    private final String[] _tuple;
    private final boolean _usePrefixMatch;
    private final boolean _useGreaterThan;
    private final boolean _isCompound;
    private final VersionID _rest;

    public VersionID(String str) {
        if (str == null || str.length() == 0) {
            this._tuple = new String[0];
            this._useGreaterThan = false;
            this._usePrefixMatch = false;
            this._isCompound = false;
            this._rest = null;
            return;
        }
        int amp = str.indexOf("&");
        if (amp >= 0) {
            this._isCompound = true;
            VersionID firstPart = new VersionID(str.substring(0, amp));
            this._rest = new VersionID(str.substring(amp + 1));
            this._tuple = firstPart._tuple;
            this._usePrefixMatch = firstPart._usePrefixMatch;
            this._useGreaterThan = firstPart._useGreaterThan;
        } else {
            this._isCompound = false;
            this._rest = null;
            if (str.endsWith("+")) {
                this._useGreaterThan = true;
                this._usePrefixMatch = false;
                str = str.substring(0, str.length() - 1);
            } else if (str.endsWith("*")) {
                this._useGreaterThan = false;
                this._usePrefixMatch = true;
                str = str.substring(0, str.length() - 1);
            } else {
                this._useGreaterThan = false;
                this._usePrefixMatch = false;
            }
            ArrayList<String> list = new ArrayList<String>();
            int start = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (".-_".indexOf(str.charAt(i)) == -1) continue;
                if (start < i) {
                    String value = str.substring(start, i);
                    list.add(value);
                }
                start = i + 1;
            }
            if (start < str.length()) {
                list.add(str.substring(start, str.length()));
            }
            this._tuple = list.toArray(new String[0]);
        }
    }

    public boolean isSimpleVersion() {
        return !this._useGreaterThan && !this._usePrefixMatch && !this._isCompound;
    }

    public boolean match(VersionID vid) {
        if (this._isCompound && !this._rest.match(vid)) {
            return false;
        }
        return this._usePrefixMatch ? this.isPrefixMatchTuple(vid) : (this._useGreaterThan ? vid.isGreaterThanOrEqualTuple(this) : this.matchTuple(vid));
    }

    public boolean equals(Object o) {
        if (this.matchTuple(o)) {
            VersionID ov = (VersionID)o;
            if ((this._rest == null || this._rest.equals(ov._rest)) && this._useGreaterThan == ov._useGreaterThan && this._usePrefixMatch == ov._usePrefixMatch) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        boolean first = true;
        int hashCode = 0;
        for (int i = 0; i < this._tuple.length; ++i) {
            if (first) {
                first = false;
                hashCode = this._tuple[i].hashCode();
                continue;
            }
            hashCode ^= this._tuple[i].hashCode();
        }
        return hashCode;
    }

    private boolean matchTuple(Object o) {
        if (o == null || !(o instanceof VersionID)) {
            return false;
        }
        VersionID vid = (VersionID)o;
        String[] t1 = this.normalize(this._tuple, vid._tuple.length);
        String[] t2 = this.normalize(vid._tuple, this._tuple.length);
        for (int i = 0; i < t1.length; ++i) {
            Object o2;
            Object o1 = this.getValueAsObject(t1[i]);
            if (o1.equals(o2 = this.getValueAsObject(t2[i]))) continue;
            return false;
        }
        return true;
    }

    private Object getValueAsObject(String value) {
        if (value.length() > 0 && value.charAt(0) != '-') {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean isGreaterThan(VersionID vid) {
        if (vid == null) {
            return false;
        }
        return this.isGreaterThanOrEqualHelper(vid, false, true);
    }

    public boolean isGreaterThanOrEqual(VersionID vid) {
        if (vid == null) {
            return false;
        }
        return this.isGreaterThanOrEqualHelper(vid, true, true);
    }

    boolean isGreaterThanOrEqualTuple(VersionID vid) {
        return this.isGreaterThanOrEqualHelper(vid, true, false);
    }

    private boolean isGreaterThanOrEqualHelper(VersionID vid, boolean allowEqual, boolean useRest) {
        if (useRest && this._isCompound && !this._rest.isGreaterThanOrEqualHelper(vid, allowEqual, true)) {
            return false;
        }
        String[] t1 = this.normalize(this._tuple, vid._tuple.length);
        String[] t2 = this.normalize(vid._tuple, this._tuple.length);
        for (int i = 0; i < t1.length; ++i) {
            String s2;
            Object e2;
            Object e1 = this.getValueAsObject(t1[i]);
            if (e1.equals(e2 = this.getValueAsObject(t2[i]))) continue;
            if (e1 instanceof Integer && e2 instanceof Integer) {
                return (Integer)e1 > (Integer)e2;
            }
            if (e1 instanceof Integer) {
                return false;
            }
            if (e2 instanceof Integer) {
                return true;
            }
            String s1 = t1[i].toString();
            return s1.compareTo(s2 = t2[i].toString()) > 0;
        }
        return allowEqual;
    }

    private boolean isPrefixMatchTuple(VersionID vid) {
        String[] t2 = this.normalize(vid._tuple, this._tuple.length);
        for (int i = 0; i < this._tuple.length; ++i) {
            String e1 = this._tuple[i];
            String e2 = t2[i];
            if (e1.equals(e2)) continue;
            return false;
        }
        return true;
    }

    private String[] normalize(String[] list, int minlength) {
        if (list.length < minlength) {
            Object[] newlist = new String[minlength];
            System.arraycopy(list, 0, newlist, 0, list.length);
            Arrays.fill(newlist, list.length, newlist.length, "0");
            return newlist;
        }
        return list;
    }

    @Override
    public int compareTo(VersionID o) {
        if (o == null || !(o instanceof VersionID)) {
            return -1;
        }
        VersionID vid = o;
        return this.equals(vid) ? 0 : (this.isGreaterThanOrEqual(vid) ? 1 : -1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._tuple.length - 1; ++i) {
            sb.append(this._tuple[i]);
            sb.append('.');
        }
        if (this._tuple.length > 0) {
            sb.append(this._tuple[this._tuple.length - 1]);
        }
        if (this._useGreaterThan) {
            sb.append('+');
        }
        if (this._usePrefixMatch) {
            sb.append('*');
        }
        if (this._isCompound) {
            sb.append("&");
            sb.append(this._rest);
        }
        return sb.toString();
    }

    public VersionID getFamilyVersionID() {
        if (this._tuple.length < 3) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            sb.append(this._tuple[i]);
            sb.append('.');
        }
        sb.append('*');
        return new VersionID(sb.toString());
    }
}

