/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.ArgumentParsingUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ManagementPermission;
import java.lang.management.RuntimeMXBean;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;

public class ParameterUtil {
    private static final AccessControlContext ACC_ARGS_INSTANCE;

    private ParameterUtil() {
    }

    public static boolean hasRunningVMRequiredArgs(final String args) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (args == null) {
                    return true;
                }
                List<Object> runtimeVMArgs = new LinkedList();
                String cp = null;
                try {
                    RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
                    runtimeVMArgs = runtimemxBean.getInputArguments();
                    cp = runtimemxBean.getClassPath();
                }
                catch (Throwable t) {
                    Trace.ignored(t);
                }
                if (runtimeVMArgs.isEmpty()) {
                    return args.trim().length() == 0;
                }
                List<String> requiredArgs = ArgumentParsingUtil.parseCommandLine(args.trim());
                Set requiredVMArgSet = ParameterUtil.toVMParameters(requiredArgs);
                Set runningVMArgSet = ParameterUtil.toVMParameters(runtimeVMArgs);
                if (cp != null) {
                    runningVMArgSet.add(ParameterUtil.parseVMParameter("-cp"));
                    runningVMArgSet.add(ParameterUtil.parseVMParameter(cp));
                }
                return runningVMArgSet.containsAll(requiredVMArgSet);
            }
        }, ACC_ARGS_INSTANCE);
    }

    public static List<String> mergeArgs(List<String> args1, List<String> args2, int mode) {
        VMParameter vmParam;
        String param;
        if (args1.isEmpty()) {
            return new LinkedList<String>(args2);
        }
        if (args2.isEmpty()) {
            return new LinkedList<String>(args1);
        }
        LinkedHashMap<VMParameter, String> vmParameters = new LinkedHashMap<VMParameter, String>();
        Iterator<String> it = args1.iterator();
        while (it.hasNext()) {
            param = it.next().trim();
            vmParam = ParameterUtil.parseVMParameter(param);
            vmParameters.put(vmParam, param);
        }
        it = args2.iterator();
        while (it.hasNext()) {
            param = it.next().trim();
            vmParam = ParameterUtil.parseVMParameter(param);
            switch (mode) {
                case 0: {
                    vmParameters.put(vmParam, param);
                    break;
                }
                case 2: {
                    if (vmParameters.containsKey(vmParam)) break;
                    vmParameters.put(vmParam, param);
                    break;
                }
                case 1: {
                    if (vmParameters.containsKey(vmParam) && Config.isSecureVmArg(param)) break;
                    vmParameters.put(vmParam, param);
                    break;
                }
            }
        }
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry entry : vmParameters.entrySet()) {
            result.add((String)entry.getValue());
        }
        return result;
    }

    private static Set<VMParameter> toVMParameters(List<String> args) {
        HashSet<VMParameter> result = new HashSet<VMParameter>();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String param = it.next().trim();
            result.add(ParameterUtil.parseVMParameter(param));
        }
        return result;
    }

    private static VMParameter parseVMParameter(String param) {
        String key = param;
        if (param.indexOf(61) > 0) {
            key = param.split("=")[0];
        } else if (param.startsWith("-XX:")) {
            key = param;
        } else if (param.indexOf(58) > 0) {
            key = param.split(":")[0];
        } else if (param.startsWith("-Xms")) {
            key = "-Xms";
        } else if (param.startsWith("-Xmx")) {
            key = "-Xmx";
        } else if (param.startsWith("-Xss")) {
            key = "-Xss";
        }
        return new VMParameter(key, param);
    }

    static {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new ManagementPermission("monitor"));
        ((PermissionCollection)perms).add(new PropertyPermission("*", "read"));
        ACC_ARGS_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    private static class VMParameter {
        private final String key;
        private final String parameter;

        public VMParameter(String key, String parameter) {
            this.key = "-classpath".equals(key) ? "-cp" : key;
            this.parameter = parameter;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VMParameter)) {
                return false;
            }
            if (this.key.startsWith("-Xbootclasspath")) {
                return this.parameter.equals(((VMParameter)obj).parameter);
            }
            return this.key.equals(((VMParameter)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String getKey() {
            return this.key;
        }

        public String getParameter() {
            return this.parameter;
        }

        public String toString() {
            return "  key: " + this.key + " - parameter: " + this.parameter;
        }
    }

    public static interface MergeMode {
        public static final int OVERRIDE_ALL = 0;
        public static final int OVERRIDE_INSECURE = 1;
        public static final int NO_OVERRIDE = 2;
    }
}

