/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt.ui;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.impl.awt.ui.FileFilterImpl;
import com.sun.deploy.uitoolkit.impl.awt.ui.SwingConsoleWindow;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.uitoolkit.ui.DialogHook;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;

public class UIFactoryImpl
extends com.sun.deploy.uitoolkit.ui.UIFactory {
    private SwingConsoleWindow console;

    @Override
    public int showMessageDialog(Object owner, AppInfo ainfo, int messageType, String title, String masthead, String message, String MoreInfo, String btnString1, String btnString2, String btnString3, String showAlways) {
        return this.showMessageDialog(owner, ainfo, messageType, title, masthead, message, MoreInfo, btnString1, btnString2, btnString3, null, null, 0, showAlways);
    }

    @Override
    public int showMessageDialog(Object owner, AppInfo ainfo, int messageType, String title, String masthead, String message, String MoreInfo, String btnString1, String btnString2, String btnString3) {
        return this.showMessageDialog(owner, ainfo, messageType, title, masthead, message, MoreInfo, btnString1, btnString2, btnString3, null, null, 0, null);
    }

    @Override
    public int showMessageDialog(Object owner, AppInfo ainfo, int messageType, String title, String masthead, String message, String MoreInfo, String btnString1, String btnString2, String btnString3, URL moreURL, String moreText, int defaultButton) {
        return this.showMessageDialog(owner, ainfo, messageType, title, masthead, message, MoreInfo, btnString1, btnString2, btnString3, moreURL, moreText, defaultButton, null);
    }

    public int showMessageDialog(Object owner, AppInfo ainfo, int messageType, String title, String masthead, String message, String detailString, String btnString1, String btnString2, String btnString3, URL moreURL, String moreText, int defaultButton, String showAlways) {
        switch (messageType) {
            default: {
                return UIFactory.showContentDialog((Component)owner, ainfo, title, message, true, btnString1, btnString2);
            }
            case 0: {
                if (detailString != null) {
                    if (masthead == null) {
                        masthead = message;
                        message = null;
                    }
                    AppInfo appInfo = ainfo != null ? ainfo : new AppInfo();
                    return UIFactory.showErrorDialog((Component)owner, ainfo, title, masthead, message, btnString1, btnString2, appInfo.getThrowable(), detailString, null);
                }
                return UIFactory.showErrorDialog((Component)owner, ainfo, title, masthead, message, btnString1, btnString2, btnString3);
            }
            case 1: {
                UIFactory.showInformationDialog((Component)owner, masthead, message, title);
                return -1;
            }
            case 8: {
                return UIFactory.showDeprecationWarningDialog((Component)owner, ainfo, masthead, message, title, showAlways);
            }
            case 2: {
                return UIFactory.showWarningDialog((Component)owner, ainfo, title, masthead, message, btnString1, btnString2, moreURL, moreText, defaultButton);
            }
            case 3: {
                return UIFactory.showConfirmDialog((Component)owner, ainfo, title, message, detailString, btnString1, btnString2, true);
            }
            case 5: {
                return UIFactory.showIntegrationDialog((Component)owner, ainfo);
            }
            case 7: {
                return UIFactory.showApiDialog(null, ainfo, title, message, detailString, btnString1, btnString2, false);
            }
            case 4: 
        }
        return UIFactory.showMixedCodeDialog((Component)owner, ainfo, title, masthead, message, detailString, btnString1, btnString2, true, showAlways);
    }

    @Override
    public void showExceptionDialog(Object owner, AppInfo appInfo, Throwable throwable, String title, String masthead, String message, Certificate[] certs) {
        if (certs == null && !(throwable instanceof BlockedException)) {
            UIFactory.showExceptionDialog((Component)owner, appInfo, throwable, masthead, message, title);
        } else {
            UIFactory.showCertificateExceptionDialog((Component)owner, appInfo, throwable, masthead, title, certs);
        }
    }

    @Override
    public int showSecurityDialog(AppInfo ainfo, String title, String topText, String publisher, URL appFrom, boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] securityAlerts, String[] securityInfo, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning) {
        return UIFactory.showSecurityDialog(ainfo, title, topText, publisher, appFrom, showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, securityInfo, showMoreInfo, certs, start, end, majorWarning, false, false, false);
    }

    @Override
    public int showSecurityDialog(AppInfo ainfo, String title, String topText, String publisher, URL appFrom, boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] securityAlerts, String[] securityInfo, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning, boolean httpsDialog, boolean selfSigned) {
        return UIFactory.showSecurityDialog(ainfo, title, topText, publisher, appFrom, showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, securityInfo, showMoreInfo, certs, start, end, majorWarning, httpsDialog, false, selfSigned);
    }

    @Override
    public int showSandboxSecurityDialog(AppInfo ainfo, String title, String topText, String publisher, URL appFrom, boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] securityAlerts, String[] securityInfo, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning, boolean selfSigned) {
        return UIFactory.showSecurityDialog(ainfo, title, topText, publisher, appFrom, showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, securityInfo, showMoreInfo, certs, start, end, majorWarning, false, true, selfSigned);
    }

    @Override
    public void showAboutJavaDialog() {
        UIFactory.showAboutJavaDialog();
    }

    @Override
    public CredentialInfo showPasswordDialog(Object owner, String title, String notes, boolean showUsername, boolean showDomain, CredentialInfo info, boolean saveEnabled, String scheme, String warning) {
        return UIFactory.showPasswordDialog((Component)owner, title, notes, showUsername, showDomain, info, saveEnabled, scheme, warning);
    }

    @Override
    public int showListDialog(Object owner, String title, String message, String label, boolean details, Vector<String> certs, TreeMap<String, X509Certificate[]> clientAuthCertsMap) {
        JList<String> certList = new JList<String>();
        certList.setSelectionMode(0);
        certList.setListData(certs);
        if (certs.size() > 0) {
            certList.setSelectedIndex(0);
        }
        return UIFactory.showListDialog((Component)owner, title, message, label, details, certList, clientAuthCertsMap);
    }

    @Override
    public int showUpdateCheckDialog() {
        return UIFactory.showUpdateCheckDialog();
    }

    @Override
    public void setDialogHook(DialogHook dh) {
        UIFactory.setDialogHook(dh);
    }

    @Override
    public synchronized ConsoleWindow getConsole(ConsoleController controller) {
        if (null == this.console) {
            try {
                this.console = SwingConsoleWindow.create(controller);
            }
            catch (Exception failed) {
                this.console = null;
                throw new RuntimeException("Could not create Swing Console due to exception", failed);
            }
        }
        return this.console;
    }

    @Override
    public int showSSVDialog(Object owner, AppInfo ainfo, String title, String masthead, String message, String moreInfoText, URL moreInfoURL, String choiceText, String choice1Label, String choice2Label, String btnOneLabel, String btnTwoLabel) {
        return UIFactory.showSSVDialog(owner, ainfo, title, masthead, message, moreInfoText, moreInfoURL, choiceText, choice1Label, choice2Label, btnOneLabel, btnTwoLabel);
    }

    private File[] showFileChooser_EDT(String initDir, String[] extensions, int mode, boolean showMultiple, String filename) {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        JFileChooser jfc = new JFileChooser(initDir, fsv);
        if (extensions != null) {
            jfc.addChoosableFileFilter(new FileFilterImpl(extensions));
        }
        jfc.setFileSelectionMode(0);
        if (mode == 8) {
            jfc.setDialogType(0);
        } else {
            jfc.setDialogType(1);
        }
        if (filename != null) {
            jfc.setSelectedFile(new File(filename));
        }
        jfc.setMultiSelectionEnabled(showMultiple);
        int state = jfc.showDialog(null, null);
        if (state == 1) {
            return null;
        }
        if (showMultiple) {
            return jfc.getSelectedFiles();
        }
        return new File[]{jfc.getSelectedFile()};
    }

    @Override
    public File[] showFileChooser(final String initDir, final String[] extensions, final int mode, final boolean showMultiple, final String filename) {
        final Object[] ret = new Object[1];
        if (SwingUtilities.isEventDispatchThread()) {
            ret[0] = this.showFileChooser_EDT(initDir, extensions, mode, showMultiple, filename);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ret[0] = UIFactoryImpl.this.showFileChooser_EDT(initDir, extensions, mode, showMultiple, filename);
                    }
                });
            }
            catch (InterruptedException ie) {
                Trace.ignored(ie);
            }
            catch (InvocationTargetException ite) {
                Trace.ignored(ite);
            }
        }
        File[] files = (File[])ret[0];
        if (mode == 9 && files[0] != null && !this.fileChk(files[0])) {
            return null;
        }
        return files;
    }

    private boolean fileChk(File filetotest) {
        if (filetotest.exists()) {
            String cancelBtn;
            String okBtn;
            String message = ResourceManager.getString("api.file.save.fileExist", filetotest.getPath());
            String title = ResourceManager.getString("api.file.save.fileExistTitle");
            int ret = this.showMessageDialog(null, null, 3, title, null, message, null, okBtn = ResourceManager.getString("common.ok_btn"), cancelBtn = ResourceManager.getString("common.cancel_btn"), null);
            return ret == 0;
        }
        return true;
    }

    @Override
    public int showSSV3Dialog(Object owner, AppInfo ainfo, int messageType, String title, String masthead, String mainText, String location, String prompt, String multiPrompt, String multiText, String run, String update, String cancel, String always, URL updateURL) {
        return UIFactory.showSSV3Dialog(owner, ainfo, messageType, title, masthead, mainText, location, prompt, multiPrompt, multiText, run, update, cancel, always, updateURL);
    }

    @Override
    public int showPublisherInfo(Object owner, AppInfo ainfo, String title, String masthead, String message, String okBtnStr, String detailBtnStr, String detailString) {
        return UIFactory.showPublisherInfo((Component)owner, ainfo, title, masthead, message, okBtnStr, detailBtnStr, detailString);
    }

    @Override
    public int showBlockedDialog(Object owner, AppInfo ainfo, String title, String masthead, String message, String okBtnStr, String detailBtnStr, String detailString) {
        return UIFactory.showBlockedDialog((Component)owner, ainfo, title, masthead, message, okBtnStr, detailBtnStr, detailString);
    }
}

