/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

abstract class WIExplorerCertStore
implements CertStore {
    protected static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    protected static final String OID_EKU_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    protected static final String OID_EKU_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    private Collection<Certificate> certs = new ArrayList<Certificate>();

    WIExplorerCertStore() {
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("iexplorer.cert.loading", new Object[]{this.getName()});
        this.certs.clear();
        this.loadCertificates(this.getName(), this.getExtendedKeyUsageFilters(), this.certs);
        Trace.msgSecurityPrintln("iexplorer.cert.loaded", new Object[]{this.getName()});
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        throw new KeyStoreException("Cannot store certificate in Internet Explorer \"" + this.getName() + "\" certificate store.");
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        return this.add(cert, null, false);
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        throw new KeyStoreException("Cannot add certificate in Internet Explorer \"" + this.getName() + "\" certificate store.");
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        throw new KeyStoreException("Cannot remove certificate from Internet Explorer \"" + this.getName() + "\" certificate store.");
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.contains(cert, null, false);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        Trace.msgSecurityPrintln("iexplorer.cert.instore", new Object[]{this.getName()});
        return this.certs.contains(cert);
    }

    @Override
    public boolean verify(Certificate cert) {
        Trace.msgSecurityPrintln("iexplorer.cert.canverify", new Object[]{this.getName()});
        Trace.msgSecurityPrintln("iexplorer.cert.tobeverified", new Object[]{cert});
        for (X509Certificate rootCert : this.getCertificates()) {
            Trace.msgSecurityPrintln("iexplorer.cert.tobecompared", new Object[]{this.getName(), rootCert});
            try {
                cert.verify(rootCert.getPublicKey());
                Trace.msgSecurityPrintln("iexplorer.cert.verify.ok", new Object[]{this.getName()});
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("iexplorer.cert.verify.fail", new Object[]{this.getName()});
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() {
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        for (X509Certificate x509Certificate : this.certs) {
            certCollection.add(x509Certificate);
        }
        return certCollection;
    }

    private native void loadCertificates(String var1, String[] var2, Collection<Certificate> var3);

    private void generateCertificate(byte[] data, Collection<Certificate> certCollection) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(bis);
            for (X509Certificate x509Certificate : c) {
                certCollection.add(x509Certificate);
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (Throwable te) {
            te.printStackTrace();
        }
    }

    protected abstract String getName();

    protected abstract String[] getExtendedKeyUsageFilters();

    static {
        Platform.get().loadDeployNativeLib();
    }
}

