/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DecisionTime;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.TrustRecorder;
import com.sun.deploy.security.UserDeclinedException;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLException;

public class SandboxSecurity {
    protected static final String FILENAME = "sandbox.properties";
    private static final String SESSION_VALUE_TRUE = "true";
    private static final String SESSION_VALUE_FALSE = "false";
    private static final String SESSION_VALUE_INPROGRESS = "in-progress";
    private static final String LOOSE_RESOURCE_KEY_SUFIX = ".loose.resource";
    private static SessionProperties sessionProps = new SessionProperties("sandbox.properties");
    private static final Set<String> verifiedHttpsConnection;
    private static Object lock;
    private static String masthead;
    private static String runKey;
    private static String cancel;
    private static String securityInfoDescription;
    private static String securityInfoCanel;
    private static String securityInfoTrusted;
    private static String securityRisk;

    public static void addConnectPermission(PermissionCollection pc, URL url) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = URLUtil.getPort(url);
        if ("https".equalsIgnoreCase(protocol) && !SandboxSecurity.verifyHttpsConnection(url)) {
            return;
        }
        if (Config.isJavaVersionAtLeast18()) {
            pc.add(new URLPermission(protocol + "://" + host + ":" + port + "/-"));
            pc.add(new URLPermission(protocol + "://" + host + ":" + port));
        } else {
            pc.add(new SocketPermission(host, "connect,accept"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyHttpsConnection(URL url) {
        String host = url.getHost();
        int port = URLUtil.getPort(url);
        String urlString = "https://" + host + ":" + port;
        Object object = lock;
        synchronized (object) {
            if (verifiedHttpsConnection.contains(urlString)) {
                return true;
            }
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.getResponseCode();
        }
        catch (SSLException sse) {
            Trace.ignored(sse);
            return false;
        }
        catch (IOException e) {
            Trace.ignored(e);
            return false;
        }
        object = lock;
        synchronized (object) {
            verifiedHttpsConnection.add(urlString);
        }
        return true;
    }

    public static void resetAcceptedVersion(LocalApplicationProperties lap, AppInfo ai) {
        if (lap != null) {
            DecisionTime.reset(lap);
            String loc = TrustDecider.getLocString(lap.getLocation(), ai);
            if (loc != null) {
                sessionProps.remove(loc);
                sessionProps.remove(loc + LOOSE_RESOURCE_KEY_SUFIX);
            }
        }
    }

    public static void isPermissionGranted(CodeSource cs, AppInfo ai, DeploymentRuleSet drs, Preloader p, URL baseURL) {
        SandboxSecurity.isPermissionGranted(cs, ai, drs, p, false, baseURL);
    }

    public static void isPermissionGranted(CodeSource cs, AppInfo ai, DeploymentRuleSet drs, Preloader p, boolean looseResource, URL baseURL) {
        Config.getHooks().trackUsage(ai, drs);
        boolean blocked = true;
        try {
            if (TrustRecorder.isGranted(cs.getLocation(), false)) {
                blocked = false;
                return;
            }
            if (drs.isRuleBlock()) {
                String key = "deployment.blocked.by.rule";
                if (drs instanceof BlockRule && ((BlockRule)drs).isFromExceptionList()) {
                    key = "deployment.blocked.by.exception.list";
                }
                BlockedDialog.show(ai, drs.getMessage(), key, drs.getException(), cs, drs);
            }
            if (cs != null && cs.getCertificates() != null) {
                try {
                    DeployManifestChecker.verify(drs, cs.getLocation(), false, ai);
                }
                catch (SecurityException se) {
                    Trace.ignored(se);
                    BlockedDialog.show(ai, null, null, se, cs, drs);
                }
                SandboxSecurity.checkSignedSandboxSecurity(cs, ai, drs, p);
            } else {
                if (!(JarVerifier.getWeakAlgorithmMessage() != null || looseResource || baseURL != null && cs.getLocation().equals(baseURL) || !JarUtil.hasPerEntryManifestEntry(cs.getLocation()))) {
                    JARSigningException jse = new JARSigningException(cs.getLocation(), null, 2);
                    Trace.ignored(jse);
                    BadCertificateDialog.showDialog(cs, ai, jse);
                    throw new SecurityException(jse.getRealMessage(), jse);
                }
                SandboxSecurity.checkUnsignedSandboxSecurity(ai, cs, drs, looseResource);
            }
            TrustRecorder.grant(cs.getLocation(), false);
            blocked = false;
        }
        catch (UserDeclinedException ude) {
            Config.getHooks().confirmAppDenied(drs);
            blocked = false;
            throw ude;
        }
        finally {
            if (blocked) {
                Config.getHooks().confirmAppBlocked(drs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSignedSandboxSecurity(CodeSource cs, AppInfo ai, DeploymentRuleSet drs, Preloader p) {
        String blockedKey = null;
        try {
            List<List<X509Certificate>> chains;
            TrustDecider.grabDeployLock();
            ValidationState state = new ValidationState(ValidationState.TYPE.SANDBOX_PERMISSIONS);
            Certificate[] certArr = null;
            X509Certificate firstCert = null;
            Certificate[] certs = cs.getCertificates();
            boolean casigned = false;
            try {
                TrustDecider.ensureBasicStoresLoaded();
                chains = TrustDecider.breakDownMultiSignerChains(certs);
            }
            catch (Exception e) {
                BadCertificateDialog.showDialog(cs, ai, e);
                throw new SecurityException(e.getMessage(), e);
            }
            Iterator<List<X509Certificate>> iterChains = chains.iterator();
            if (iterChains.hasNext()) {
                List<X509Certificate> certList = iterChains.next();
                certArr = certList.toArray(new X509Certificate[0]);
                while (drs.skipThisCertArray((X509Certificate[])certArr) && iterChains.hasNext()) {
                    certList = iterChains.next();
                    certArr = certList.toArray(new X509Certificate[0]);
                }
                try {
                    firstCert = certArr[0];
                    boolean bestEffort = drs.isRevocationCheckBestEffort();
                    boolean runRule = drs.isRuleRun();
                    state = TrustDecider.getValidationState((X509Certificate[])certArr, cs, 0, ValidationState.TYPE.SANDBOX_PERMISSIONS, bestEffort, runRule, ai, drs, false);
                    LocalApplicationProperties lap = Cache.getLocalApplicationProperties(ai.getLapURL());
                    if (lap != null) {
                        lap.storeMainPublisherAndTitle(state.getPublisher(), ai.getDisplayTitle());
                    }
                    casigned = state.rootCAValid;
                    if (state.trustDecision == 0L) {
                        String location = cs.getLocation() != null ? cs.getLocation().toString() : null;
                        TrustDecider.notifyOnUserDeclined(p, location);
                    } else if (casigned) {
                        if (drs.isCaSignedNever()) {
                            blockedKey = "deployment.run.sandbox.signed.never.text";
                        }
                    } else if (drs.isSelfSignedNever()) {
                        blockedKey = "deployment.run.sandbox.selfsigned.never.text";
                    } else if (SecurityBaseline.isExpired() && drs.isSSVModeNever()) {
                        blockedKey = "deployment.ssv2.mode.never.text";
                    }
                    if (blockedKey == null && !state.timeValid && drs.isExpiredBlocked()) {
                        blockedKey = "deployment.block.expired.text";
                    }
                    if (blockedKey == null && !casigned && SandboxSecurity.isLocalApp(ai) && drs.isRunLocalAppletsNever()) {
                        blockedKey = "deployment.local.applet.never.text";
                    }
                }
                catch (Exception e) {
                    if (e instanceof CertificateRevokedException) {
                        BlockedException be = new BlockedException(ResourceManager.getString("security.badcert.blocked.revoked.reason"), (Throwable)e, cs, ai);
                        if (Environment.isJavaPlugin()) {
                            throw be;
                        }
                        BadCertificateDialog.showDialog(cs, ai, be);
                        throw new SecurityException(e.getMessage(), be);
                    }
                    BadCertificateDialog.showDialog(cs, ai, e);
                    throw new SecurityException(e.getMessage(), e);
                }
            }
            if (blockedKey != null) {
                BlockedDialog.show(ai, null, blockedKey, null, cs, drs);
            }
            if (state.trustDecision == 0L) {
                throw new UserDeclinedException("user declined to run signed sandbox app");
            }
            try {
                TrustDecider.checkMainJarManifest(drs, cs.getLocation(), ai, false);
                if (drs.isRuleRun()) {
                    state.trustDecision = 1L;
                    SandboxSecurity.checkRunRuleMessage(drs, cs.getLocation(), ai, firstCert);
                }
            }
            catch (SecurityException e) {
                String key = "deployment.blocked.permissions";
                BlockedDialog.show(ai, null, key, e, cs, drs);
            }
            if (state.trustDecision == 2L) {
                if (DecisionTime.withinTime(cs.getLocation(), ai, firstCert, "ssv.decision.sandbox.time")) {
                    state.trustDecision = 1L;
                    return;
                }
                int result = SandboxSecurity.showSandboxDialog(cs.getLocation(), ai, drs, (X509Certificate[])certArr, !state.timeValid, !state.rootCAValid, state.revStatusUnknown);
                TrustDecider.recordSandboxAnswer(certArr, cs, state, p, result, ai);
                if (result == 0) {
                    DecisionTime.setTime(cs.getLocation(), ai, firstCert, "ssv.decision.sandbox.time");
                }
            }
        }
        catch (InterruptedException ie) {
            Trace.ignored(ie);
            BlockedDialog.show(ai, null, "deployment.run.sandbox.signed.error", ie, cs, drs);
        }
        finally {
            TrustDecider.releaseDeployLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUnsignedSandboxSecurity(AppInfo ai, CodeSource cs, DeploymentRuleSet drs, boolean looseResource) {
        if (drs.isRuleRun()) {
            SandboxSecurity.checkRunRuleMessage(drs, cs.getLocation(), ai, null);
            return;
        }
        SessionProperties sessionProperties = sessionProps;
        synchronized (sessionProperties) {
            String key = TrustDecider.getLocString(ai.getLapURL(), ai);
            String key1 = key + LOOSE_RESOURCE_KEY_SUFIX;
            String value = sessionProps.getProperty(key);
            String value1 = sessionProps.getProperty(key1);
            if (SESSION_VALUE_TRUE.equals(value) || looseResource && SESSION_VALUE_TRUE.equals(value1)) {
                return;
            }
            if (SESSION_VALUE_FALSE.equals(value) || looseResource && SESSION_VALUE_FALSE.equals(value1)) {
                throw new UserDeclinedException("User declined to run unsigned sandbox content");
            }
            if (SESSION_VALUE_INPROGRESS.equals(value)) {
                throw new ClassCircularityError("re-entrant call to checkUnsignedSandboxSecurity()");
            }
            sessionProps.setProperty(key, SESSION_VALUE_INPROGRESS);
            try {
                if (SecurityBaseline.isExpired()) {
                    SandboxSecurity.checkRunExpired(ai, drs, looseResource);
                } else if (SandboxSecurity.isLocalApp(ai)) {
                    SandboxSecurity.checkRunLocal(ai, cs, drs, looseResource);
                } else {
                    SandboxSecurity.checkRunUntrusted(ai, cs, drs, looseResource);
                }
            }
            finally {
                if (SESSION_VALUE_INPROGRESS.equals(sessionProps.getProperty(key))) {
                    sessionProps.remove(key);
                }
            }
            if (looseResource) {
                sessionProps.setProperty(key1, SESSION_VALUE_TRUE);
            } else {
                sessionProps.setProperty(key, SESSION_VALUE_TRUE);
            }
        }
    }

    private static void checkRunUntrusted(AppInfo ai, CodeSource cs, DeploymentRuleSet drs, boolean looseResource) {
        if (drs.isRunUntrustedNever() && !looseResource) {
            BlockedDialog.show(ai, null, "deployment.run.untrusted.never.text", drs.getException(), null, drs);
        }
        if (DecisionTime.withinTime(cs.getLocation(), ai, null, "ssv.decision.unsigned.time")) {
            return;
        }
        SandboxSecurity.showUntrustedDialog(ai, drs, looseResource, false);
        DecisionTime.setTime(cs.getLocation(), ai, null, "ssv.decision.unsigned.time");
    }

    private static void checkRunExpired(AppInfo ai, DeploymentRuleSet drs, boolean looseResource) {
        if (drs.isSSVModeNever() && !looseResource) {
            BlockedDialog.show(ai, null, "deployment.ssv2.mode.never.text", drs.getException(), null, drs);
        }
        SandboxSecurity.showUntrustedDialog(ai, drs, looseResource, true);
    }

    private static void checkRunLocal(AppInfo ai, CodeSource cs, DeploymentRuleSet drs, boolean looseResource) {
        if (drs.isRunLocalAppletsNever()) {
            BlockedDialog.show(ai, null, "deployment.local.applet.never.text", drs.getException(), null, drs);
        }
        if (drs.isRunUntrustedNever() && !looseResource) {
            BlockedDialog.show(ai, null, "deployment.run.untrusted.never.text", drs.getException(), null, drs);
        }
        if (DecisionTime.withinTime(cs.getLocation(), ai, null, "ssv.decision.unsigned.time")) {
            return;
        }
        SandboxSecurity.showUntrustedDialog(ai, drs, looseResource, false);
        DecisionTime.setTime(cs.getLocation(), ai, null, "ssv.decision.unsigned.time");
    }

    private static boolean isLocalApp(AppInfo ai) {
        URL u = ai.getFrom();
        return u != null && u.getProtocol().equals("file");
    }

    private static LocalApplicationProperties getLap(AppInfo ai) {
        return Cache.getLocalApplicationProperties(ai.getLapURL());
    }

    public static boolean showUntrustedDialog(AppInfo ai, DeploymentRuleSet drs, boolean looseResource, boolean expired) {
        UIFactory uiFactory;
        int result;
        LocalApplicationProperties lap;
        String title = "deployment.ssv.title";
        String masthead = "deployment.ssv.masthead";
        String location = ai.isMultiHost() ? "deployment.ssv.location.multihost" : "deployment.ssv.location";
        Object recommend = null;
        Object prompt = "deployment.ssv.prompt";
        String multiPrompt = null;
        String multiText = null;
        if (drs.isRunUntrustedMultiClick()) {
            multiPrompt = "deployment.ssv.multi.prompt";
            multiText = "deployment.ssv.multi.text";
        }
        String run = "deployment.ssv.run";
        String update = null;
        String cancel = "deployment.ssv.cancel";
        URL updateURL = null;
        String root = "deployment.ssv." + (expired ? "expired." : "") + (SandboxSecurity.isLocalApp(ai) ? "localapp." : "");
        String mainText = root + (looseResource ? "res" : "main");
        if (expired) {
            prompt = "deployment.ssv.update.prompt";
            update = "deployment.ssv.update";
            try {
                updateURL = new URL("http://java.com/download");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (looseResource) {
            prompt = (String)prompt + ".res";
        }
        if ((lap = ResourceProvider.get().getLocalApplicationProperties(ai.getLapURL(), null, true)) != null) {
            lap.storeMainPublisherAndTitle(null, null);
        }
        String always = null;
        String weakJarMessage = JarVerifier.getWeakAlgorithmMessage();
        if (weakJarMessage != null) {
            prompt = prompt == null ? "" : ResourceManager.getString((String)prompt) + "<br><br><b>";
            prompt = (String)prompt + ResourceManager.getString("deployment.ssv.warning") + "</b> " + weakJarMessage;
        }
        if ((result = (uiFactory = ToolkitStore.getUI()).showSSV3Dialog(null, ai, 2, title, masthead, mainText, location, (String)prompt, multiPrompt, multiText, run, update, cancel, always, updateURL)) == 2) {
            return true;
        }
        if (result == 0) {
            return false;
        }
        String key = TrustDecider.getLocString(ai.getLapURL(), ai) + (looseResource ? LOOSE_RESOURCE_KEY_SUFIX : "");
        sessionProps.setProperty(key, SESSION_VALUE_FALSE);
        throw new UserDeclinedException("User declined to run unsigned sandbox content");
    }

    private static String getMessage(String id) {
        return ResourceManager.getString(id);
    }

    private static int showSandboxDialog(URL location, AppInfo ai, DeploymentRuleSet drs, X509Certificate[] certificates, boolean expired, boolean selfSigned, boolean unableToCheckRevocation) {
        ArrayList<String> securityAlerts = null;
        ArrayList<String> securityInfo = new ArrayList<String>();
        securityInfo.add(securityInfoDescription);
        securityInfo.add(securityInfoCanel);
        String publisher = CertUtils.extractSubjectAliasName(certificates[0]);
        if (selfSigned) {
            securityAlerts = new ArrayList<String>();
            securityAlerts.add(securityRisk);
            String unknown = SandboxSecurity.getMessage("security.dialog.notverified.subject");
            securityInfo.add(SandboxSecurity.getMessage("security.info.publisher.unknown").replaceAll(unknown, unknown.toUpperCase()));
            securityInfo.add(SandboxSecurity.getMessage("sandbox.security.info.selfsigned.state"));
            publisher = unknown.toUpperCase();
        } else if (expired) {
            securityAlerts = new ArrayList();
            securityAlerts.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.dialog.expired.signed.label")));
            securityInfo.add(securityInfoTrusted);
            securityInfo.add(SandboxSecurity.getMessage("sandbox.security.info.expired.state"));
        } else if (unableToCheckRevocation) {
            securityAlerts = new ArrayList();
            securityAlerts.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.info.selfsigned.revocation.unknown")));
            securityInfo.add(securityInfoTrusted);
            securityInfo.add(SandboxSecurity.getMessage("sandbox.security.info.revocation.unsure.state"));
        } else {
            securityInfo.add(securityInfoTrusted);
            securityInfo.add(SandboxSecurity.getMessage("sandbox.security.info.trusted.state"));
        }
        if (securityAlerts != null) {
            securityAlerts.addAll(securityInfo);
        }
        String titleStr = securityAlerts == null ? SandboxSecurity.getMessage("security.dialog.valid.caption") : SandboxSecurity.getMessage("security.dialog.caption");
        boolean showAlwaysTrustCheckBox = false;
        boolean needWrapAppInfoToSingleHost = false;
        if (!selfSigned && !unableToCheckRevocation) {
            if (ai.isMultiHost()) {
                if (DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(location, ai)) {
                    showAlwaysTrustCheckBox = true;
                    needWrapAppInfoToSingleHost = true;
                } else if (ai.shouldDisplayMainJNLP()) {
                    showAlwaysTrustCheckBox = true;
                }
            } else {
                showAlwaysTrustCheckBox = true;
            }
        }
        DeployManifestChecker.printWarningsIfRequired(location, ai);
        return ToolkitStore.getUI().showSandboxSecurityDialog(needWrapAppInfoToSingleHost ? AppInfo.createSingleHostAppInfo(ai) : new AppInfo(ai), titleStr, masthead, publisher, location, showAlwaysTrustCheckBox, false, runKey, cancel, securityAlerts != null ? securityAlerts.toArray(new String[securityAlerts.size()]) : null, securityAlerts == null ? securityInfo.toArray(new String[securityInfo.size()]) : null, true, certificates, 0, certificates.length, selfSigned || expired || unableToCheckRevocation, selfSigned);
    }

    protected static void checkRunRuleMessage(DeploymentRuleSet drs, URL loc, AppInfo ai, X509Certificate cert) {
        String message = drs.getMessage();
        if (message != null && message.length() > 0) {
            if (DecisionTime.withinTime(loc, ai, cert, "ssv.decision.runrule.time")) {
                return;
            }
            ToolkitStore.getUI().showMessageDialog(null, ai, 1, SandboxSecurity.getMessage("runrule.message.title"), SandboxSecurity.getMessage("runrule.message.masthead"), message, null, SandboxSecurity.getMessage("common.ok_btn"), null, null, null);
            DecisionTime.setTime(loc, ai, cert, "ssv.decision.runrule.time");
        }
    }

    private static String combineMessage(String m1, String m2) {
        StringBuilder sb = new StringBuilder();
        sb.append(m1);
        sb.append("\n\n");
        sb.append(m2);
        return sb.toString();
    }

    static {
        SessionState.register(sessionProps);
        verifiedHttpsConnection = new HashSet<String>();
        lock = new Object();
        masthead = SandboxSecurity.getMessage("deployment.ssv.masthead");
        runKey = "deployment.ssv.run";
        cancel = SandboxSecurity.getMessage("deployment.ssv.cancel");
        securityInfoDescription = SandboxSecurity.getMessage("sandbox.security.info.description");
        securityInfoCanel = SandboxSecurity.getMessage("sandbox.security.info.cancel");
        securityInfoTrusted = SandboxSecurity.getMessage("sandbox.security.info.trusted");
        securityRisk = SandboxSecurity.getMessage("sandbox.security.info.risk");
    }
}

