/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.MSCryptoDSAPrivateKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public abstract class MSCryptoDSASignature
extends SignatureSpi {
    private MSCryptoDSAPrivateKey privateKey = null;

    protected abstract void update(byte[] var1, int var2, int var3);

    protected abstract byte[] getDigest() throws SignatureException;

    protected abstract void resetDigest();

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        throw new InvalidKeyException("Key not supported");
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof MSCryptoDSAPrivateKey)) {
            throw new InvalidKeyException("Key not supported");
        }
        this.privateKey = (MSCryptoDSAPrivateKey)key;
        int keySize = this.privateKey.bitLength() + 7 >> 3;
        if (keySize < 64) {
            throw new InvalidKeyException("DSA keys should be at least 512 bits long");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        byte[] buf = new byte[]{b};
        this.update(buf, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] hash = this.getDigest();
            byte[] dssSignature = MSCryptoDSASignature.nativeSignHash(hash, hash.length, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
            byte[] rByteArray = new byte[20];
            byte[] sByteArray = new byte[20];
            System.arraycopy(dssSignature, 0, rByteArray, 0, 20);
            System.arraycopy(dssSignature, 20, sByteArray, 0, 20);
            BigInteger r = new BigInteger(this.convertEndianArray(rByteArray));
            BigInteger s = new BigInteger(this.convertEndianArray(sByteArray));
            DerOutputStream outseq = new DerOutputStream(100);
            outseq.putInteger(r);
            outseq.putInteger(s);
            DerValue result = new DerValue(48, outseq.toByteArray());
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Throwable e) {
            SignatureException se = new SignatureException("Error generating signature.");
            se.initCause(e);
            throw se;
        }
        finally {
            this.resetDigest();
        }
    }

    static native byte[] nativeSignHash(byte[] var0, int var1, int var2, int var3) throws SignatureException;

    private byte[] convertEndianArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return byteArray;
        }
        byte[] retval = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            retval[i] = byteArray[byteArray.length - i - 1];
        }
        return retval;
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new SignatureException("Signature verification not supported");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    static {
        Platform.get().loadDeployNativeLib();
    }

    public static final class NONEwithDSA
    extends MSCryptoDSASignature {
        private static final int SHA1_LEN = 20;
        private final byte[] digestBuffer = new byte[20];
        private int offset;

        @Override
        protected void update(byte[] data, int off, int len) {
            if (len == 0 || data == null) {
                return;
            }
            if (this.offset + len > 20) {
                this.offset = 21;
                return;
            }
            System.arraycopy(data, off, this.digestBuffer, this.offset, len);
            this.offset += len;
        }

        @Override
        protected byte[] getDigest() throws SignatureException {
            if (this.offset != 20) {
                throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
            }
            this.offset = 0;
            return this.digestBuffer;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }
    }

    public static class SHA1withDSA
    extends MSCryptoDSASignature {
        private final MessageDigest dataSHA = MessageDigest.getInstance("SHA-1");

        public SHA1withDSA() throws NoSuchAlgorithmException {
            this.dataSHA.reset();
        }

        @Override
        protected void update(byte[] data, int off, int len) {
            if (len == 0 || data == null) {
                return;
            }
            this.dataSHA.update(data, off, len);
        }

        @Override
        protected byte[] getDigest() {
            return this.dataSHA.digest();
        }

        @Override
        protected void resetDigest() {
            this.dataSHA.reset();
        }
    }
}

