/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.config.Config;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.DeployURLClassPath;
import com.sun.deploy.security.Resource;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.file.FileURLConnection;

public abstract class DeployURLClassLoader
extends SecureClassLoader
implements Closeable {
    private DeployURLClassPath ucp;
    private final AccessControlContext acc;
    private WeakHashMap<Closeable, Void> closeables = new WeakHashMap();

    public DeployURLClassLoader(URL[] urls, ClassLoader parent) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new DeployURLClassPath(urls);
        this.acc = AccessController.getContext();
    }

    DeployURLClassLoader(URL[] urls, ClassLoader parent, AccessControlContext acc) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new DeployURLClassPath(urls);
        this.acc = acc;
    }

    public DeployURLClassLoader(URL[] urls) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new DeployURLClassPath(urls);
        this.acc = AccessController.getContext();
    }

    DeployURLClassLoader(URL[] urls, AccessControlContext acc) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new DeployURLClassPath(urls);
        this.acc = acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("closeClassLoader"));
        }
        List<IOException> errors = this.ucp.closeLoaders();
        WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
        synchronized (weakHashMap) {
            Set<Closeable> keys = this.closeables.keySet();
            for (Closeable c : keys) {
                try {
                    c.close();
                }
                catch (IOException ioex) {
                    errors.add(ioex);
                }
            }
            this.closeables.clear();
        }
        if (errors.isEmpty()) {
            return;
        }
        IOException firstex = errors.remove(0);
        for (IOException error : errors) {
            firstex.addSuppressed(error);
        }
        throw firstex;
    }

    public void addURL(URL url) {
        this.ucp.addURL(url);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        Class result;
        try {
            result = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    Resource res = DeployURLClassLoader.this.ucp.getResource(path, false);
                    if (res != null) {
                        try {
                            return DeployURLClassLoader.this.defineClass(name, res);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    return null;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private Package getAndVerifyPackage(String pkgname, Manifest man, URL url) {
        Package pkg;
        Package package_ = pkg = Config.isJavaVersionAtLeast9() ? this.getDefinedPackage(pkgname) : this.getPackage(pkgname);
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(url)) {
                    throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                }
            } else if (man != null && this.isSealed(pkgname, man)) {
                throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
            }
        }
        return pkg;
    }

    private void definePackageInternal(String pkgname, Manifest man, URL url) {
        block5: {
            if (this.getAndVerifyPackage(pkgname, man, url) == null) {
                try {
                    if (man != null) {
                        this.definePackage(pkgname, man, url);
                    } else {
                        this.definePackage(pkgname, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (this.getAndVerifyPackage(pkgname, man, url) != null) break block5;
                    throw new AssertionError((Object)("Cannot find package " + pkgname));
                }
            }
        }
    }

    protected final Class<?> defineClass(String name, Resource res) throws IOException {
        ByteBuffer bb;
        long t0 = System.nanoTime();
        int i = name.lastIndexOf(46);
        URL url = res.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Manifest man = res.getManifest();
            this.definePackageInternal(pkgname, man, url);
        }
        if ((bb = res.getByteBuffer()) != null) {
            CodeSigner[] signers = res.getCodeSigners();
            CodeSource cs = new CodeSource(url, signers);
            return this.defineClass(name, bb, cs);
        }
        byte[] b = res.getBytes();
        CodeSigner[] signers = res.getCodeSigners();
        CodeSource cs = new CodeSource(url, signers);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Override
    public URL findResource(final String name) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return DeployURLClassLoader.this.ucp.findResource(name, true);
            }
        }, this.acc);
        return url != null ? this.ucp.checkURL(url) : null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        final Enumeration<URL> e = this.ucp.findResources(name, true);
        return new Enumeration<URL>(){
            private URL url = null;

            private boolean next() {
                URL u;
                if (this.url != null) {
                    return true;
                }
                while ((u = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        if (!e.hasMoreElements()) {
                            return null;
                        }
                        return (URL)e.nextElement();
                    }
                }, DeployURLClassLoader.this.acc)) != null) {
                    this.url = DeployURLClassLoader.this.ucp.checkURL(u);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        Object path;
        Permission p;
        URLConnection urlConnection;
        PermissionCollection perms = super.getPermissions(codesource);
        URL url = codesource.getLocation();
        try {
            urlConnection = url.openConnection();
            p = urlConnection.getPermission();
        }
        catch (IOException ioe) {
            p = null;
            urlConnection = null;
        }
        if (p instanceof FilePermission) {
            path = p.getName();
            if (((String)path).endsWith(File.separator)) {
                path = (String)path + "-";
                p = new FilePermission((String)path, "read");
            }
        } else if (p == null && url.getProtocol().equals("file")) {
            path = url.getFile().replace('/', File.separatorChar);
            if (((String)(path = ParseUtil.decode((String)path))).endsWith(File.separator)) {
                path = (String)path + "-";
            }
            p = new FilePermission((String)path, "read");
        } else {
            String host;
            URL locUrl = url;
            if (urlConnection instanceof JarURLConnection) {
                locUrl = ((JarURLConnection)urlConnection).getJarFileURL();
            }
            if ((host = locUrl.getHost()) != null && host.length() > 0) {
                p = new SocketPermission(host, "connect,accept");
            }
        }
        if (p != null) {
            final SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                final Permission fp = p;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() throws SecurityException {
                        sm.checkPermission(fp);
                        return null;
                    }
                }, this.acc);
            }
            perms.add(p);
        }
        return perms;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        Object is = null;
        try {
            CodeSource cs;
            String protocol;
            Resource r = this.getResourceAsResource(name);
            if (r == null) {
                return this.getResourceAsStreamBase(name);
            }
            boolean loose = true;
            URL url = r.getURL();
            String string = protocol = url != null ? url.getProtocol() : null;
            if ("jar".equalsIgnoreCase(protocol)) {
                loose = false;
                url = URLUtil.getInnerURL(url);
            }
            if (this.getResourcePermission(cs = new CodeSource(url, r.getCodeSigners()), this.wantsAllPerms(cs), this.getAppInfo(url), this.getDeploymentRuleSet(url), this.getPreloader(), loose)) {
                return r.getInputStream();
            }
        }
        catch (Throwable ex) {
            return this.getResourceAsStreamBase(name);
        }
        return null;
    }

    protected void checkPackageAccess(String name) {
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(name.substring(0, i));
        }
    }

    public DeployURLClassPath getDeployURLClassPath() {
        return this.ucp;
    }

    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    protected void setDeployURLClassPath(DeployURLClassPath ucp) {
        this.ucp = ucp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getResourceAsStreamBase(String name) {
        URL url = this.getResource(name);
        try {
            if (url == null) {
                return null;
            }
            URLConnection urlc = url.openConnection();
            InputStream is = urlc.getInputStream();
            if (urlc instanceof JarURLConnection) {
                JarURLConnection juc = (JarURLConnection)urlc;
                JarFile jar = juc.getJarFile();
                WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
                synchronized (weakHashMap) {
                    if (!this.closeables.containsKey(jar)) {
                        this.closeables.put(jar, null);
                    }
                }
            }
            if (urlc instanceof FileURLConnection) {
                WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
                synchronized (weakHashMap) {
                    this.closeables.put(is, null);
                }
            }
            return is;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected boolean getResourcePermission(CodeSource cs, boolean wantsAll, AppInfo ai, DeploymentRuleSet drs, Preloader loader, boolean loose) {
        if (wantsAll && cs.getCertificates() != null) {
            try {
                long until = TrustDecider.isAllPermissionGranted(cs, ai, drs, loader);
                if (until != 0L) {
                    return true;
                }
                Trace.println("User declined to load signed content from: " + cs.getLocation(), TraceLevel.SECURITY);
                return false;
            }
            catch (Exception ce) {
                BadCertificateDialog.showDialog(cs, ai, ce);
                return false;
            }
        }
        try {
            SandboxSecurity.isPermissionGranted(cs, ai, drs, loader, loose, null);
            return true;
        }
        catch (Exception e) {
            Trace.println("User declined to load unsigned content from: " + cs.getLocation(), TraceLevel.SECURITY);
            return false;
        }
    }

    public abstract boolean wantsAllPerms(CodeSource var1);

    public abstract AppInfo getAppInfo(URL var1);

    public abstract Preloader getPreloader();

    public abstract DeploymentRuleSet getDeploymentRuleSet(URL var1);

    public abstract Resource getResourceAsResource(String var1) throws MalformedURLException, FileNotFoundException;
}

