/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import java.security.Principal;
import java.security.cert.X509Certificate;

class CertificateInfo {
    X509Certificate cert;

    CertificateInfo(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    private String extractAliasName(X509Certificate cert) {
        String subjectName = CertificateInfo.getString("security.dialog.unknown.subject");
        String issuerName = CertificateInfo.getString("security.dialog.unknown.issuer");
        try {
            Principal principal = cert.getSubjectDN();
            Principal principalIssuer = cert.getIssuerDN();
            String subjectDNName = principal.getName();
            String issuerDNName = principalIssuer.getName();
            subjectName = this.extractFromQuote(subjectDNName, "CN=");
            if (subjectName == null) {
                subjectName = this.extractFromQuote(subjectDNName, "O=");
            }
            if (subjectName == null) {
                subjectName = CertificateInfo.getString("security.dialog.unknown.subject");
            }
            if ((issuerName = this.extractFromQuote(issuerDNName, "CN=")) == null) {
                issuerName = this.extractFromQuote(issuerDNName, "O=");
            }
            if (issuerName == null) {
                issuerName = CertificateInfo.getString("security.dialog.unknown.issuer");
            }
        }
        catch (Exception e) {
            Trace.printException(e);
        }
        return ResourceManager.getString("security.dialog.certShowName", subjectName, issuerName);
    }

    private String extractFromQuote(String s, String prefix) {
        if (s == null) {
            return null;
        }
        int x = s.indexOf(prefix);
        int y = 0;
        if (x >= 0) {
            if ((y = s.charAt(x += prefix.length()) == '\"' ? s.indexOf(34, ++x) : s.indexOf(44, x)) < 0) {
                return s.substring(x);
            }
            return s.substring(x, y);
        }
        return null;
    }

    private static String getString(String key) {
        return ResourceManager.getString(key);
    }

    public String toString() {
        return this.extractAliasName(this.cert);
    }
}

