/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.AuthKey;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.net.www.protocol.http.AuthCacheValue;
import sun.net.www.protocol.http.AuthenticationInfo;

public class AuthCacheBridge {
    private AuthCacheBridge() {
    }

    public static AuthKey create(AuthCacheValue value) {
        try {
            return new DelegateAuthCacheBridge(value);
        }
        catch (IllegalAccessError x) {
            return new ReflectiveAuthCacheBridge(value);
        }
    }

    private static class ReflectiveAuthCacheBridge
    implements AuthKey {
        private static Method getAuthTypeMethod;
        private static Method getProtocolSchemeMethod;
        private static Method getPortMethod;
        private static Method getHostMethod;
        private static Method getPathMethod;
        private static Method getPromptMethod;
        private final AuthCacheValue cacheValue;

        ReflectiveAuthCacheBridge(AuthCacheValue value) {
            this.cacheValue = value;
        }

        private Object invoke(Method m) {
            try {
                return m.invoke((Object)this.cacheValue, new Object[]{null});
            }
            catch (IllegalAccessException x) {
                Trace.ignored(x);
            }
            catch (InvocationTargetException x) {
                Trace.ignored(x);
            }
            return null;
        }

        @Override
        public boolean isProxy() {
            return (AuthCacheValue.Type)((Object)this.invoke(getAuthTypeMethod)) == AuthCacheValue.Type.Proxy;
        }

        @Override
        public String getProtocolScheme() {
            return (String)this.invoke(getProtocolSchemeMethod);
        }

        @Override
        public int getPort() {
            Integer ret = (Integer)this.invoke(getPortMethod);
            return ret == null ? 0 : ret;
        }

        @Override
        public String getHost() {
            return (String)this.invoke(getHostMethod);
        }

        @Override
        public String getPath() {
            return (String)this.invoke(getPathMethod);
        }

        @Override
        public String getScheme() {
            return (String)this.invoke(getProtocolSchemeMethod);
        }

        @Override
        public String getPrompt() {
            return (String)this.invoke(getPromptMethod);
        }

        static {
            try {
                Class<?> cl = Class.forName("sun.net.www.protocol.http.AuthenticationInfo");
                getAuthTypeMethod = cl.getDeclaredMethod("getAuthType", new Class[0]);
                getProtocolSchemeMethod = cl.getDeclaredMethod("getProtocolScheme", new Class[0]);
                getPortMethod = cl.getDeclaredMethod("getPort", new Class[0]);
                getHostMethod = cl.getDeclaredMethod("getHost", new Class[0]);
                getPathMethod = cl.getDeclaredMethod("getPath", new Class[0]);
                getPromptMethod = cl.getDeclaredMethod("getPrompt", new Class[0]);
            }
            catch (ClassNotFoundException x) {
                Trace.ignored(x);
            }
            catch (NoSuchMethodException x) {
                Trace.ignored(x);
            }
        }
    }

    private static class DelegateAuthCacheBridge
    implements AuthKey {
        private final AuthenticationInfo cacheValue;

        DelegateAuthCacheBridge(AuthCacheValue value) {
            this.cacheValue = (AuthenticationInfo)value;
        }

        @Override
        public boolean isProxy() {
            return this.cacheValue.getAuthType() == AuthCacheValue.Type.Proxy;
        }

        @Override
        public String getProtocolScheme() {
            return this.cacheValue.getProtocolScheme();
        }

        @Override
        public int getPort() {
            return this.cacheValue.getPort();
        }

        @Override
        public String getHost() {
            return this.cacheValue.getHost();
        }

        @Override
        public String getPath() {
            return this.cacheValue.getPath();
        }

        @Override
        public String getScheme() {
            return this.cacheValue.getProtocolScheme();
        }

        @Override
        public String getPrompt() {
            return this.cacheValue.getRealm();
        }
    }
}

