/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ref;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;

public class AppModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Type type;
    private SecurityMode securityMode;
    private String title;
    private String vendor;
    private String description;
    private String mainClass;
    private URL location;
    private URL codebase;
    private final ArrayList<JarResource> jarResources = new ArrayList();
    private final ArrayList<ExtensionResource> extensionResources = new ArrayList();

    public void setType(Type type) {
        this.type = type;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        this.securityMode = securityMode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocation(URL location) {
        this.location = location;
    }

    public void setCodebase(URL codebase) {
        this.codebase = codebase;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void addJarResource(URL location, String version) {
        this.jarResources.add(new JarResource(location, version));
    }

    public void addExtensionResource(URL location, String version) {
        this.extensionResources.add(new ExtensionResource(location, version));
    }

    public Type getType() {
        return this.type;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getLocation() {
        return this.location;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Iterable<JarResource> getJarResources() {
        return this.jarResources;
    }

    public Iterable<ExtensionResource> getExtensionResources() {
        return this.extensionResources;
    }

    public static class ExtensionResource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URL location;
        private final String name;

        public ExtensionResource(URL location, String name) {
            this.location = location;
            this.name = name;
        }

        public URL getLocation() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class JarResource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URL location;
        private final String version;

        public JarResource(URL location, String version) {
            this.location = location;
            this.version = version;
        }

        public URL getLocation() {
            return this.location;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static enum SecurityMode {
        SANDBOX,
        ALL_PERMISSIONS,
        J2EE_APPLICATION_CLIENT_PERMISSIONS;

    }

    public static enum Type {
        APPLET,
        APPLICATION;

    }
}

