/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.AbstractAutoProxyHandler;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.net.proxy.pac.PACFunctions;
import com.sun.deploy.net.proxy.pac.PACFunctionsImpl;
import com.sun.deploy.security.SelectableSecurityManager;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class SunAutoProxyHandler
extends AbstractAutoProxyHandler {
    private SelectableSecurityManager ssm = SelectableSecurityManager.getInstance();
    private ScriptEngineManager manager = null;
    private ScriptEngine engine = null;
    private static final AccessControlContext scriptEngineACC;
    private PACFunctions functionsImpl = null;
    private static final String pacFuncsImpl = "    function dnsResolve(host){\n                                     return String(obj.dnsResolve(host));\n                   }\n                                                          function isResolvable(host){\n                                   return obj.isResolvable(host);\n                         }\n                                                          function localHostOrDomainIs(host, domain){\n                    return obj.localHostOrDomainIs(host, domain);\n          }\n                                                          function isPlainHostName(host){\n                                return obj.isPlainHostName(host);\n                      }\n                                                          function myIpAddress(){\n                                        return String(obj.myIpAddress());\n                      }\n                                                          function shExpMatch(str, shexp){\n                               return obj.shExpMatch(str, shexp);\n                     }\n                                                          function dnsDomainIs(host, domain){\n                            return obj.dnsDomainIs(host, domain);\n                  }\n                                                          function dnsDomainLevels(host){\n                                return obj.dnsDomainLevels(host);\n                      }";

    public SunAutoProxyHandler() {
        this.functionsImpl = new PACFunctionsImpl();
    }

    public SunAutoProxyHandler(PACFunctions functionsImpl) {
        this.functionsImpl = functionsImpl;
    }

    @Override
    public final void init(BrowserProxyInfo info) throws ProxyConfigException {
        super.init(info);
        this.initEngine(scriptEngineACC);
    }

    private void initEngine(AccessControlContext acc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SunAutoProxyHandler.this.initEngine();
                return null;
            }
        }, acc);
    }

    private void initEngine() {
        this.manager = new ScriptEngineManager(null);
        this.engine = this.manager.getEngineByName("js");
    }

    @Override
    public ProxyInfo[] getProxyInfo(URL url) throws ProxyUnavailableException {
        ProxyInfo[] result = null;
        try {
            this.ssm.enable();
            result = this.jsGetProxyInfo(url, scriptEngineACC);
        }
        finally {
            this.ssm.disable();
        }
        if (result == null) {
            result = this.fallbackGetProxyInfo(url);
        }
        return result;
    }

    private ProxyInfo[] jsGetProxyInfo(final URL url, AccessControlContext acc) {
        return AccessController.doPrivileged(new PrivilegedAction<ProxyInfo[]>(){

            @Override
            public ProxyInfo[] run() {
                return SunAutoProxyHandler.this.jsGetProxyInfo(url);
            }
        }, acc);
    }

    private ProxyInfo[] jsGetProxyInfo(URL url) {
        ProxyInfo[] result = null;
        if (this.engine != null) {
            try {
                if (Config.isJavaVersionAtLeast18()) {
                    this.bindPACFunctions_18(this.engine);
                } else {
                    this.bindPACFunctions(this.engine);
                }
                this.engine.eval(this.autoProxyScript.toString());
                if (this.engine instanceof Invocable) {
                    Invocable invocable = (Invocable)((Object)this.engine);
                    Object res = invocable.invokeFunction("FindProxyForURL", url.toString(), url.getHost());
                    result = this.extractAutoProxySetting((String)res);
                } else {
                    Trace.netPrintln("JavaScript engine cannot invoke methods");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private void bindPACFunctions_18(ScriptEngine engine) {
        engine.put("dnsDomainIs", new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String host, String domain) {
                return SunAutoProxyHandler.this.functionsImpl.dnsDomainIs(host, domain);
            }
        });
        engine.put("shExpMatch", new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String str, String shexp) {
                return SunAutoProxyHandler.this.functionsImpl.shExpMatch(str, shexp);
            }
        });
        engine.put("myIpAddress", new Supplier<String>(){

            @Override
            public String get() {
                return SunAutoProxyHandler.this.functionsImpl.myIpAddress();
            }
        });
        engine.put("dnsResolve", new Function<String, String>(){

            @Override
            public String apply(String host) {
                return SunAutoProxyHandler.this.functionsImpl.dnsResolve(host);
            }
        });
        engine.put("isPlainHostName", new Function<String, Boolean>(){

            @Override
            public Boolean apply(String host) {
                return SunAutoProxyHandler.this.functionsImpl.isPlainHostName(host);
            }
        });
        engine.put("localHostOrDomainIs", new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String host, String domain) {
                return SunAutoProxyHandler.this.functionsImpl.localHostOrDomainIs(host, domain);
            }
        });
        engine.put("isResolvable", new Function<String, Boolean>(){

            @Override
            public Boolean apply(String host) {
                return SunAutoProxyHandler.this.functionsImpl.isResolvable(host);
            }
        });
        engine.put("dnsDomainLevels", new Function<String, Integer>(){

            @Override
            public Integer apply(String host) {
                return SunAutoProxyHandler.this.functionsImpl.dnsDomainLevels(host);
            }
        });
    }

    private void bindPACFunctions(ScriptEngine engine) {
        engine.put("obj", this.functionsImpl);
    }

    @Override
    protected String getBrowserSpecificAutoProxy() {
        if (Config.isJavaVersionAtLeast18()) {
            return "";
        }
        return pacFuncsImpl;
    }

    ProxyInfo[] fallbackGetProxyInfo(URL url) {
        try {
            String result = null;
            if (this.jsPacScript != null) {
                StringTokenizer st = new StringTokenizer(this.jsPacScript, ";", false);
                while (st.hasMoreTokens()) {
                    String pattern = st.nextToken();
                    int x = pattern.indexOf("DIRECT");
                    int y = pattern.indexOf("PROXY");
                    int z = pattern.indexOf("SOCKS");
                    int i = this.positiveMin(x, this.positiveMin(y, z));
                    int j = pattern.lastIndexOf("\"");
                    if (i == -1) continue;
                    result = j <= i ? pattern.substring(i) : pattern.substring(i, j);
                    break;
                }
            }
            return this.extractAutoProxySetting(result);
        }
        catch (Throwable e) {
            Trace.msgNetPrintln("net.proxy.auto.result.error");
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    private int positiveMin(int x, int y) {
        if (x < 0) {
            return y;
        }
        if (y < 0) {
            return x;
        }
        if (x > y) {
            return y;
        }
        return x;
    }

    static {
        if (Config.isJavaVersionAtLeast18()) {
            scriptEngineACC = Config.getNoPermissionACC();
        } else {
            Permissions perms = new Permissions();
            ((PermissionCollection)perms).add(new RuntimePermission("accessClassInPackage.com.sun.deploy.net.proxy.pac"));
            scriptEngineACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    }
}

