/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.RfcDateParser;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

class HttpCookie
implements Comparable<HttpCookie> {
    private static final int SIZE_LIMIT = 4096;
    private Date expirationDate = null;
    private String nameAndValue = null;
    private String path = null;
    private String domain = null;
    private boolean isSecure = false;

    private HttpCookie() {
    }

    private HttpCookie(Date expirationDate, String nameAndValue, String path, String domain, boolean isSecure) {
        this.expirationDate = expirationDate;
        this.nameAndValue = nameAndValue;
        this.path = path;
        this.domain = HttpCookie.stripPort(domain);
        this.isSecure = isSecure;
    }

    private static String stripPort(String domainName) {
        int index = domainName.indexOf(58);
        if (index == -1) {
            return domainName;
        }
        return domainName.substring(0, index);
    }

    static HttpCookie create(Date expirationDate, String nameAndValue, String path, String domain, boolean isSecure) {
        if (nameAndValue == null || path == null || domain == null) {
            return null;
        }
        if (path.equals("")) {
            path = "/";
        }
        if (nameAndValue.length() > 4096) {
            nameAndValue = nameAndValue.substring(0, 4096);
        }
        return new HttpCookie(expirationDate, nameAndValue, path, domain, isSecure);
    }

    static HttpCookie create(URL url, String cookieString) {
        StringTokenizer tokens = new StringTokenizer(cookieString, ";");
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        HttpCookie httpCookie = new HttpCookie();
        httpCookie.nameAndValue = tokens.nextToken().trim();
        if (httpCookie.nameAndValue.length() > 4096) {
            httpCookie.nameAndValue = httpCookie.nameAndValue.substring(0, 4096);
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equalsIgnoreCase("secure")) {
                httpCookie.isSecure = true;
                continue;
            }
            int equIndex = token.indexOf("=");
            if (equIndex < 0) continue;
            String attr = token.substring(0, equIndex);
            String val = token.substring(equIndex + 1);
            if (attr.equalsIgnoreCase("path")) {
                httpCookie.path = val;
                continue;
            }
            if (attr.equalsIgnoreCase("domain")) {
                if (val.indexOf(".") == 0) {
                    httpCookie.domain = HttpCookie.stripPort(val.substring(1));
                    continue;
                }
                httpCookie.domain = HttpCookie.stripPort(val);
                continue;
            }
            if (!attr.equalsIgnoreCase("expires")) continue;
            httpCookie.expirationDate = HttpCookie.parseExpireDate(val);
        }
        if (httpCookie.domain == null) {
            httpCookie.domain = url.getHost();
        }
        if (httpCookie.path == null) {
            httpCookie.path = url.getFile();
            int last = httpCookie.path.lastIndexOf("/");
            if (last > -1) {
                httpCookie.path = httpCookie.path.substring(0, last);
            }
        }
        return httpCookie;
    }

    public String getNameValue() {
        return this.nameAndValue;
    }

    public String getName() {
        int index = this.nameAndValue.indexOf("=");
        return this.nameAndValue.substring(0, index);
    }

    public String getValue() {
        int index = this.nameAndValue.indexOf("=");
        return this.nameAndValue.substring(index + 1);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    boolean hasExpired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    boolean isSaveable() {
        return this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private static Date parseExpireDate(String dateString) {
        RfcDateParser parser = new RfcDateParser(dateString);
        Date theDate = parser.getDate();
        return theDate;
    }

    public String toString() {
        Object result = this.nameAndValue;
        if (this.expirationDate != null) {
            result = (String)result + "; expires=" + this.expirationDate;
        }
        if (this.path != null) {
            result = (String)result + "; path=" + this.path;
        }
        if (this.domain != null) {
            result = (String)result + "; domain=" + this.domain;
        }
        if (this.isSecure) {
            result = (String)result + "; secure";
        }
        return result;
    }

    @Override
    public int compareTo(HttpCookie o) {
        HttpCookie other = o;
        if (other == this) {
            return 0;
        }
        int c = this.getDomain().compareTo(other.getDomain());
        if (c != 0) {
            return c;
        }
        c = this.getPath().compareTo(other.getPath());
        if (c != 0) {
            return c;
        }
        return this.getNameValue().compareTo(other.getNameValue());
    }
}

