/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache6Upgrader;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CacheUpgrader;
import com.sun.deploy.cache.CleanupThreadHolder;
import com.sun.deploy.cache.CompositeLocalApplicationProperties;
import com.sun.deploy.cache.DefaultLocalApplicationProperties;
import com.sun.deploy.cache.InMemoryLocalApplicationProperties;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import jdk.internal.misc.SharedSecrets;

public class Cache {
    static final boolean DEBUG = Config.getDebug();
    public static final int VERSION_INT = 606;
    static final int VERSION_605 = 605;
    static final int VERSION_604 = 604;
    static final int VERSION_603 = 603;
    static final int VERSION_602 = 602;
    public static final String VERSION6_STRING = "6.0";
    public static final String VERSION_STRING = "6.0";
    private static boolean doIPLookup = true;
    private static final String IP_ADDR_CANNOT_RESOLVE = "0.0.0.0";
    private static final String DASH = "-";
    static final String INDEX_FILE_EXT = ".idx";
    static final String MUFFIN_FILE_EXT = ".muf";
    static final String HOST_FILE_EXT = ".hst";
    static final String LAP_FILE_EXT = ".lap";
    static final String MUFFIN_DIRNAME = "muffin";
    static final String SPLASH_DIRNAME = "splash";
    static final String HOST_DIRNAME = "host";
    public static final int NUM_OF_CACHE_SUBDIR = 64;
    static final char APPLICATION_TYPE = 'A';
    static final char EXTENSION_TYPE = 'E';
    private static final SecureRandom random = new SecureRandom();
    private static String cachePath;
    private static File cacheDir;
    private static File roamingLapCacheDir;
    private static File sysCacheDir;
    private static File muffinDir;
    private static File hostDir;
    private static final int BUF_SIZE = 32768;
    private static final Map<String, LocalApplicationProperties> loadedProperties;
    private static final CleanupThreadHolder ct;
    private static final Object syncObject;
    private static boolean cleanupEnabled;
    public static final long TIME_WAIT_BEFORE_JAR_PERVERIFY = 30000L;
    private static final AccessControlContext ACC_FILE_INSTANCE;
    private static final AccessControlContext ACC_FILE_AND_PROPERTY_INSTANCE;
    private static final AccessControlContext ACC_GET_IP_INSTANCE;
    static final String LAST_ACCESS_FILE = "lastAccessed";
    static final String REMOVED_APPS = "removed.apps";

    public static void setCleanupEnabled(boolean enabled) {
        cleanupEnabled = enabled;
    }

    public static void init() {
    }

    public static void setDoIPLookup(boolean b) {
        doIPLookup = b;
    }

    private static void createCacheBucketDirectories(String cacheDirPath) {
        for (int i = 0; i < 64; ++i) {
            File cacheSubDir = new File(cacheDirPath + File.separator + i);
            cacheSubDir.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = syncObject;
        synchronized (object) {
            MemoryCache.reset();
            Map<String, LocalApplicationProperties> map = loadedProperties;
            synchronized (map) {
                loadedProperties.clear();
            }
            cachePath = Config.getCacheDirectory() + File.separator + "6.0";
            String muffinPath = cachePath + File.separator + MUFFIN_DIRNAME;
            String hostPath = cachePath + File.separator + HOST_DIRNAME;
            cacheDir = new File(cachePath);
            muffinDir = new File(muffinPath);
            hostDir = new File(hostPath);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
                Cache6Upgrader.initializeUpgraderKeys();
            }
            hostDir.mkdirs();
            Cache.createCacheBucketDirectories(cachePath);
            muffinDir.mkdirs();
            Cache.resetLapCache();
            Cache.resetSystemCache();
            long cacheMax = Config.getCacheSizeMax();
            if (cacheMax > 0L && cacheMax < 0x500000L) {
                long l = 0x500000L;
            }
        }
    }

    public static void resetSystemCache() {
        if (Config.getSystemCacheDirectory() != null && Config.getSystemCacheDirectory().length() != 0) {
            String sysCachePath = Config.getSystemCacheDirectory() + File.separator + "6.0";
            sysCacheDir = new File(sysCachePath);
            if (Environment.isSystemCacheMode()) {
                sysCacheDir.mkdirs();
                Cache.createCacheBucketDirectories(sysCachePath);
            }
        } else {
            sysCacheDir = null;
        }
    }

    public static void resetLapCache() {
        if (Config.get().useRoamingProfile()) {
            String lapCachePath = Config.getDefaultRoamingCacheDirectory() + File.separator + "6.0";
            roamingLapCacheDir = new File(lapCachePath);
            roamingLapCacheDir.mkdirs();
            Cache.createCacheBucketDirectories(lapCachePath);
        } else {
            roamingLapCacheDir = null;
        }
    }

    static void addToCleanupThreadLoadedResourceList(String url) {
        if (ct != null && cleanupEnabled) {
            ct.addToLoadedResourceList(url);
        }
    }

    static void cleanup() {
        if (ct != null && cleanupEnabled) {
            ct.startCleanup();
        }
    }

    public static boolean hasIncompatibleCompressEncoding(CacheEntry ce) {
        return ce != null && DownloadEngine.isInternalUse() && ce.hasCompressEncoding();
    }

    private Cache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void markResourceIncomplete(CacheEntry ce) {
        if (ce != null) {
            CacheEntry cacheEntry = ce;
            synchronized (cacheEntry) {
                ce.setIncomplete(1);
                try {
                    ce.updateIndexHeaderOnDisk();
                }
                catch (IOException ioe) {
                    Trace.ignoredException(ioe);
                }
            }
        }
    }

    static boolean isSystemCacheEntry(CacheEntry ce) {
        File idx;
        if (ce != null && sysCacheDir != null && (idx = ce.getIndexFile()) != null && idx.getParentFile() != null) {
            return sysCacheDir.equals(idx.getParentFile().getParentFile());
        }
        return false;
    }

    static CacheEntry getSystemCacheEntry(URL url, String version) {
        if (url == null) {
            return null;
        }
        CacheEntry ce = (CacheEntry)MemoryCache.getLoadedResource(url.toString());
        if (Cache.isSystemCacheEntry(ce)) {
            String currentVersion = ce.getVersion();
            if (version == null && currentVersion == null || version != null && currentVersion != null && currentVersion.compareTo(version) >= 0) {
                return ce;
            }
        }
        if ((ce = Cache.getCacheEntry(url, version, sysCacheDir)) == null) {
            ce = CacheUpgrader.getSystemInstance().upgradeItem(url, version, 1);
        }
        if (ce != null) {
            MemoryCache.addLoadedResource(url.toString(), ce);
        }
        return ce;
    }

    public static boolean isSupportedProtocol(URL url) {
        String protocol = url.getProtocol();
        return protocol != null && (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("file"));
    }

    public static boolean isCacheEnabled() {
        return Config.getBooleanProperty("deployment.cache.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoadedProperties(String key) {
        Map<String, LocalApplicationProperties> map = loadedProperties;
        synchronized (map) {
            loadedProperties.remove(key);
        }
    }

    public static LocalApplicationProperties getLocalApplicationProperties(CacheEntry ce) {
        URL jnlpURL = null;
        try {
            jnlpURL = new URL(ce.getURL());
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException(mue);
        }
        return Cache.getLocalApplicationProperties(jnlpURL, ce.getVersion(), true);
    }

    public static LocalApplicationProperties getLocalApplicationProperties(String path) {
        if (!Cache.isCacheEnabled()) {
            return null;
        }
        final File file = new File(path + INDEX_FILE_EXT);
        final CacheEntry ce = AccessController.doPrivileged(new PrivilegedAction<CacheEntry>(){

            @Override
            public CacheEntry run() {
                return Cache.getCacheEntryFromFile(file);
            }
        }, ACC_FILE_INSTANCE);
        if (ce == null) {
            return null;
        }
        URL u = null;
        try {
            u = new URL(ce.getURL());
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException(mue);
            return null;
        }
        final URL url = u;
        return AccessController.doPrivileged(new PrivilegedAction<LocalApplicationProperties>(){

            @Override
            public LocalApplicationProperties run() {
                return Cache.getLocalApplicationProperties(url, ce.getVersion(), true);
            }
        }, ACC_FILE_INSTANCE);
    }

    public static LocalApplicationProperties getLocalApplicationProperties(URL jnlpUrl) {
        return Cache.getLocalApplicationProperties(jnlpUrl, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalApplicationProperties getLocalApplicationProperties(URL jnlpUrl, String version, boolean isApplicationDesc) {
        LocalApplicationProperties props = null;
        if (jnlpUrl != null) {
            String key = jnlpUrl.toString() + "?" + version;
            Map<String, LocalApplicationProperties> map = loadedProperties;
            synchronized (map) {
                props = loadedProperties.get(key);
                if (props == null) {
                    props = Cache.isCacheEnabled() ? (Config.get().useRoamingProfile() && !Environment.isSystemCacheMode() ? new CompositeLocalApplicationProperties(jnlpUrl, version, isApplicationDesc) : new DefaultLocalApplicationProperties(jnlpUrl, version, isApplicationDesc)) : new InMemoryLocalApplicationProperties(jnlpUrl, version, isApplicationDesc);
                    loadedProperties.put(key, props);
                } else {
                    props.refreshIfNecessary();
                }
            }
        }
        return props;
    }

    public static String getLapFileName(URL url, String version, boolean addSecureKey) {
        String key = Cache.getKey(url) + (addSecureKey ? Cache.getSecureKey(url) : "");
        return Cache.getBucket(Cache.getKey(url)) + File.separator + key + "6.0" + Cache.getVersionTag(version) + LAP_FILE_EXT;
    }

    public static void putLapData(char type, URL url, String version, final byte[] data, LocalApplicationProperties.Kind kind) throws IOException {
        File dir = Cache.getLapCacheDir(kind);
        String lapName = Cache.getLapFileName(url, version, true);
        final File lapFile = new File(dir, lapName);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Cache.putLapData(lapFile, data);
                    Cache.recordLastAccessed();
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void putLapData(File lapFile, byte[] data) throws IOException {
        Platform.get().getNativeSandboxBroker().writeFile(lapFile, data);
    }

    private static boolean checkCacheEntryUrl(String idxName, File cacheDir, URL url) {
        File filename = new File(cacheDir.getPath() + File.separator + Cache.getBucket(Cache.getKey(url)) + File.separator + idxName + INDEX_FILE_EXT);
        CacheEntry ce = new CacheEntry(filename);
        return ce.getURL().equals(url.toString());
    }

    private static File migrateOldLapFile(File oldLapFile, File cacheDir, URL url, String version) throws IOException {
        Properties props = new Properties();
        byte[] data = Cache.getLapBytes(oldLapFile);
        if (data == null) {
            return null;
        }
        props.load(new ByteArrayInputStream(data));
        Trace.println("Cache: migrating old .lap file", TraceLevel.SECURITY);
        String shortcutPath = props.getProperty("installed.desktop");
        if (shortcutPath == null) {
            shortcutPath = props.getProperty("installed.menu");
        }
        if (shortcutPath != null) {
            Trace.println("Cache: using shortcut for .lap file migration", TraceLevel.SECURITY);
            String jnlpName = Platform.get().getShortcutJnlpName(shortcutPath);
            if (jnlpName != null && Cache.checkCacheEntryUrl(jnlpName, cacheDir, url)) {
                String newLapFileName = Cache.getLapFileName(url, version, true);
                File lapFile = new File(cacheDir, newLapFileName);
                if (oldLapFile.renameTo(lapFile)) {
                    return lapFile;
                }
            } else {
                Trace.println("Cache: cannot find jnlp file for specified shortcut or url[" + url + "] does not match with shortcut target", TraceLevel.SECURITY);
                oldLapFile.delete();
            }
        } else {
            Trace.println("Cache: cannot migrate old .lap file", TraceLevel.SECURITY);
            oldLapFile.delete();
        }
        return null;
    }

    private static File getLapCacheDir(LocalApplicationProperties.Kind kind) {
        switch (kind) {
            case ROAMING: {
                return roamingLapCacheDir;
            }
            case SYSTEM: {
                return sysCacheDir;
            }
        }
        return cacheDir;
    }

    public static byte[] getLapData(char type, final URL url, final String version, LocalApplicationProperties.Kind kind) throws IOException {
        final File dir = Cache.getLapCacheDir(kind);
        if (dir == null) {
            return null;
        }
        String newLapName = Cache.getLapFileName(url, version, true);
        final File[] lapFiles = new File[]{new File(dir, newLapName)};
        Boolean result = Boolean.TRUE;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    if (!lapFiles[0].exists()) {
                        String oldLapFileName = Cache.getLapFileName(url, version, false);
                        File oldLapFile = new File(dir, oldLapFileName);
                        if (oldLapFile.exists()) {
                            lapFiles[0] = Cache.migrateOldLapFile(oldLapFile, dir, url, version);
                        } else {
                            return Boolean.FALSE;
                        }
                    }
                    return Boolean.TRUE;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (!result.booleanValue()) {
            return null;
        }
        return lapFiles[0] != null ? Cache.getLapBytes(lapFiles[0]) : null;
    }

    static byte[] getLapBytes(final File lapFile) throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            bos = AccessController.doPrivileged(new PrivilegedExceptionAction<ByteArrayOutputStream>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ByteArrayOutputStream run() throws IOException {
                    long size = lapFile.length();
                    if (size > 0L && size < 0x100000L) {
                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(lapFile));
                        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)size);
                        byte[] buffer = new byte[32768];
                        try {
                            int n = is.read(buffer);
                            while (n >= 0) {
                                baos.write(buffer, 0, n);
                                n = is.read(buffer);
                            }
                        }
                        finally {
                            baos.close();
                            is.close();
                        }
                        return baos;
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (bos != null) {
            return bos.toByteArray();
        }
        return null;
    }

    public static String getExtensionInstallDir() {
        return cacheDir.getAbsolutePath() + File.separator + "ext";
    }

    public static String getNewExtensionInstallDirectory() throws IOException {
        String dir = Cache.getExtensionInstallDir();
        String tempname = null;
        int count = 0;
        do {
            File cacheDir;
            if (!(cacheDir = new File(tempname = dir + File.separator + "E" + new Date().getTime() + File.separator)).mkdirs()) {
                tempname = null;
            }
            Thread.yield();
        } while (tempname == null && ++count < 50);
        if (tempname == null) {
            throw new IOException("Unable to create temp. dir for extension");
        }
        return tempname;
    }

    public static String getCacheEntryVersion(URL url) {
        String currentVersion = null;
        CacheEntry ce = Cache.getLatestCacheEntry(url);
        if (ce != null) {
            currentVersion = ce.getVersion();
        }
        return currentVersion;
    }

    private static void writeBytes(File file, byte[] bytes) throws IOException {
        FilterOutputStream bos = null;
        boolean deleteFile = false;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (IOException ioe) {
            deleteFile = true;
            throw ioe;
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (deleteFile) {
                file.delete();
            }
        }
    }

    private static CacheEntry createNewCacheEntry(URL url, String version) throws IOException {
        String cacheFileName = Cache.generateCacheFileName(url, version);
        File dir = Cache.getActiveCacheDir();
        File indexFile = new File(dir, cacheFileName + Cache.getIndexFileExtension());
        CacheEntry ce = new CacheEntry(indexFile);
        ce.writeFileToDisk();
        return ce;
    }

    static CacheEntry downloadResourceToCache(final URL href, final String downloadVersion, final URLConnection conn, final URL requestURL, final boolean applyJarDiff, final int contentType, final InputStream is, final boolean decompress) throws IOException, CanceledDownloadException {
        CacheEntry ce;
        block3: {
            ce = null;
            try {
                ce = AccessController.doPrivileged(new PrivilegedExceptionAction<CacheEntry>(){

                    @Override
                    public CacheEntry run() throws IOException, CanceledDownloadException {
                        String encoding = conn.getContentEncoding();
                        if (DownloadEngine.isPackContentType(contentType)) {
                            encoding = "pack200-gzip";
                        }
                        CacheEntry ce = Cache.createNewCacheEntry(href, downloadVersion);
                        MessageHeader adjustment = DownloadEngine.getHttpDownloadImpl().download(conn.getContentLength(), conn.getURL(), is, encoding, ce.getTempDataFile(), null, contentType, decompress);
                        if (ce.processTempDataFile(applyJarDiff, null, href, requestURL, downloadVersion)) {
                            ce.setBusy(0);
                            ce.setIncomplete(0);
                            ce.setURL(downloadVersion == null ? requestURL.toString() : href.toString());
                            if (applyJarDiff) {
                                ce.setContentLength((int)new File(ce.getResourceFilename()).length());
                            } else {
                                ce.setContentLength(conn.getContentLength());
                            }
                            ce.setLastModified(conn.getLastModified());
                            if (downloadVersion != null) {
                                ce.setVersion(downloadVersion);
                            }
                            MessageHeader headerFields = BasicHttpRequest.initializeHeaderFields(conn);
                            headerFields = MessageHeader.merge(headerFields, adjustment);
                            if (conn instanceof HttpURLConnection) {
                                ((HttpURLConnection)conn).disconnect();
                                String requestContentType = conn.getRequestProperty("content-type");
                                if (requestContentType != null && headerFields != null) {
                                    headerFields.add("deploy-request-content-type", requestContentType);
                                }
                            }
                            ce.setHeaders(headerFields);
                            String expiresField = conn.getHeaderField("expires");
                            long expiration = 0L;
                            if (expiresField != null) {
                                SimpleDateFormat df = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.US);
                                try {
                                    Date d = df.parse(expiresField);
                                    expiration = d.getTime();
                                }
                                catch (ParseException pex1) {
                                    expiration = conn.getExpiration();
                                }
                            }
                            ce.setExpirationDate(HttpUtils.getEffectiveExpiration(expiration, headerFields));
                            Cache.setCeIsProxied(ce, href.getHost());
                            ce.writeFileToDisk(contentType, null);
                            Cache.recordLastAccessed();
                            return ce;
                        }
                        return null;
                    }
                }, ACC_FILE_AND_PROPERTY_INSTANCE);
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof IOException) {
                    throw (IOException)pae.getException();
                }
                if (!(pae.getException() instanceof CanceledDownloadException)) break block3;
                throw (CanceledDownloadException)pae.getException();
            }
        }
        return ce;
    }

    private static void setCeIsProxied(CacheEntry ce, String host) {
        try {
            boolean value = sun.net.www.URLConnection.isProxiedHost(host);
            int CEvalue = value ? 1 : 0;
            ce.setIsProxied(CEvalue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void setIsProxiedHost(String host) {
        try {
            sun.net.www.URLConnection.setProxiedHost(host);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static CacheEntry downloadResourceToCache(URL href, String downloadVersion, HttpResponse response, HttpDownloadListener hdl, DownloadDelegate dd, URL requestURL, boolean applyJarDiff, int contentType) throws IOException, CanceledDownloadException {
        boolean removeCurrentCE;
        URL finalURL = HttpUtils.getFinalRedirectedURL(response);
        boolean redirected = false;
        if (finalURL != null && DownloadEngine.getRedirectURL(requestURL) != null) {
            redirected = true;
        }
        if (DownloadEngine.isPackContentType(contentType)) {
            redirected = true;
        }
        URL finalHref = redirected ? finalURL : href;
        URL finalRequestURL = redirected ? finalURL : requestURL;
        CacheEntry currentCE = Cache.getCacheEntry(href, downloadVersion, contentType);
        CacheEntry tempCE = Cache.downloadResourceToTempFile(finalHref, downloadVersion, response, hdl, dd, finalRequestURL, applyJarDiff, contentType);
        boolean bl = removeCurrentCE = downloadVersion == null;
        if (tempCE != null) {
            CacheEntry ret = Cache.processNewCacheEntry(href, removeCurrentCE, tempCE, currentCE);
            if (redirected) {
                Cache.createRedirectEntry(href, finalURL, ret);
            }
            return ret;
        }
        return null;
    }

    public static CacheEntry downloadResourceToTempFile(URL href, String downloadVersion, HttpResponse response, HttpDownloadListener hdl, DownloadDelegate dd, URL requestURL, boolean applyJarDiff, int contentType) throws IOException, CanceledDownloadException {
        CacheEntry ce = Cache.createNewCacheEntry(href, downloadVersion);
        String encoding = response.getContentEncoding();
        if (DownloadEngine.isPackContentType(contentType)) {
            encoding = "pack200-gzip";
        }
        MessageHeader adjustment = null;
        boolean uncompress = DownloadEngine.isInternalUse();
        try {
            BufferedInputStream in = response.getInputStream();
            adjustment = DownloadEngine.getHttpDownloadImpl().download(response.getContentLength(), response.getRequest(), in, encoding, ce.getTempDataFile(), hdl, contentType, uncompress);
        }
        catch (IOException e) {
            Cache.removeCacheEntry(ce);
            throw e;
        }
        catch (CanceledDownloadException cde) {
            Cache.removeCacheEntry(ce);
            throw cde;
        }
        finally {
            response.disconnect();
        }
        if (ce.processTempDataFile(applyJarDiff, dd, href, requestURL, downloadVersion)) {
            ce.setURL(downloadVersion == null && !Environment.isImportMode() ? requestURL.toString() : href.toString());
            MessageHeader headerFields = response.getHeaders();
            if (headerFields != null) {
                if (DownloadEngine.isJarContentType(contentType)) {
                    headerFields.add("deploy-request-content-type", "application/x-java-archive");
                }
                headerFields = MessageHeader.merge(headerFields, adjustment);
            }
            ce.setHeaders(headerFields);
            ce.setContentLength(response.getContentLength());
            ce.setLastModified(response.getLastModified());
            ce.setExpirationDate(HttpUtils.getEffectiveExpiration(response));
            if (downloadVersion != null) {
                ce.setVersion(downloadVersion);
            }
            Cache.setCeIsProxied(ce, href.getHost());
            ce.writeFileToDisk(contentType, dd);
            return ce;
        }
        return null;
    }

    public static boolean isBackgroundVerificationEnabled() {
        if (!Cache.isCacheEnabled()) {
            return false;
        }
        String s = System.getProperty("jnlp.disableBackgroundVerification");
        if (s != null && s.equalsIgnoreCase("true")) {
            Trace.println("Cached JAR background verification disabled", TraceLevel.CACHE);
            return false;
        }
        return true;
    }

    public static CacheEntry processNewCacheEntry(URL href, boolean removeCurrentCE, CacheEntry ce, CacheEntry currentCE) throws IOException {
        Trace.println("Cache: Enable a new CacheEntry: " + href.toString(), TraceLevel.NETWORK);
        ce.setBusy(0);
        ce.setIncomplete(0);
        ce.updateIndexHeaderOnDisk();
        if (currentCE != null) {
            if (DownloadEngine.isBackgroundUpdateRequest() && MemoryCache.isCacheEntryLoaded(href.toString(), currentCE.getVersion())) {
                removeCurrentCE = false;
                currentCE.markIncompleteOnHold();
            }
            if (removeCurrentCE) {
                Cache.removeCacheEntry(currentCE, false);
            }
        }
        Cache.recordLastAccessed();
        return ce;
    }

    public static int getCacheVersion() {
        return 606;
    }

    public static String getCacheVersionString() {
        return "6.0";
    }

    public static long getCacheSize(boolean system) {
        long size = 0L;
        File[] idxFiles = Cache.getCacheEntries(system);
        for (int i = 0; i < idxFiles.length; ++i) {
            size += idxFiles[i].length();
            CacheEntry ce = Cache.getCacheEntryFromFile(idxFiles[i]);
            if (ce == null) continue;
            size += new File(ce.getResourceFilename()).length();
            size += Cache.getTotalSize(new File(ce.getNativeLibPath()));
        }
        return size;
    }

    private static long getTotalSize(File f) {
        long size = 0L;
        if (f != null && f.exists()) {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    size += Cache.getTotalSize(files[i]);
                }
            } else {
                size += f.length();
            }
        }
        return size;
    }

    public static boolean exists() {
        if (Environment.isSystemCacheMode()) {
            return sysCacheDir != null && sysCacheDir.exists();
        }
        return cacheDir.exists();
    }

    public static boolean canWrite() {
        if (Environment.isSystemCacheMode()) {
            return sysCacheDir != null && sysCacheDir.canWrite();
        }
        return cacheDir.canWrite();
    }

    public static CacheEntry createOrUpdateCacheEntry(URL href, byte[] bytes) throws IOException {
        CacheEntry currentCE = Cache.getCacheEntry(href, null, Cache.getActiveCacheDir());
        CacheEntry ce = Cache.createNewCacheEntry(href, null);
        Cache.writeBytes(ce.getTempDataFile(), bytes);
        if (ce.processTempDataFile(false, null, href, href, null)) {
            ce.setBusy(0);
            ce.setIncomplete(0);
            ce.setURL(href.toString());
            Cache.setCeIsProxied(ce, href.getHost());
            ce.writeFileToDisk();
            if (currentCE != null) {
                Cache.removeCacheEntry(currentCE, false);
            }
            Cache.recordLastAccessed();
            Cache.addLoadedResource(ce);
        } else {
            Cache.removeCacheEntry(ce, false);
        }
        return ce;
    }

    public static CacheEntry createRedirectEntry(URL sourceURL, URL finalURL, CacheEntry target) throws IOException {
        if (target == null && (target = Cache.getCacheEntry(finalURL, null)) == null) {
            return null;
        }
        CacheEntry ce = Cache.createNewCacheEntry(sourceURL, target.getVersion());
        ce.processRedirectData(sourceURL, target);
        Cache.recordLastAccessed();
        Cache.addLoadedResource(target);
        Cache.addLoadedResource(sourceURL.toString(), target);
        DownloadEngine.addKnownRedirectHost(sourceURL.getHost(), finalURL.getHost());
        return ce;
    }

    private static void addLoadedResource(CacheEntry entry) {
        Cache.addLoadedResource(entry.getURL().toString(), entry);
    }

    public static void addLoadedResource(String key, CacheEntry entry) {
        CacheEntry old = (CacheEntry)MemoryCache.getLoadedResource(key);
        if ((old == null || old != entry && !old.getIndexFile().equals(entry.getIndexFile())) && (old = (CacheEntry)MemoryCache.addLoadedResource(key, entry)) != entry && old != null && old.getVersion() == null && entry.getVersion() == null) {
            Cache.markResourceIncomplete(old);
        }
    }

    public static String getIndexFileExtension() {
        return INDEX_FILE_EXT;
    }

    static String getVersionTag(String version) {
        return version == null ? "" : DASH + version + DASH;
    }

    static File getCacheDir() {
        return cacheDir;
    }

    static File getSystemCacheDir() {
        return sysCacheDir;
    }

    public static boolean isFileWithinCache(File file) {
        String path = file.getAbsolutePath();
        return path.startsWith(cacheDir.getAbsolutePath()) || sysCacheDir != null && path.startsWith(sysCacheDir.getAbsolutePath());
    }

    public static void setSystemCacheDir(String path) {
        if (path == null || path.length() == 0) {
            sysCacheDir = null;
        } else {
            String sysCachePath = path + File.separator + "6.0";
            sysCacheDir = new File(sysCachePath);
        }
    }

    public static File getActiveCacheDir() {
        return Environment.isSystemCacheMode() ? sysCacheDir : cacheDir;
    }

    public static File getActiveLapCacheDir() {
        return Environment.isSystemCacheMode() ? sysCacheDir : (Config.get().useRoamingProfile() ? roamingLapCacheDir : cacheDir);
    }

    public static File[] getActiveLapCacheDirs() {
        if (Environment.isSystemCacheMode()) {
            return new File[]{sysCacheDir};
        }
        if (Config.get().useRoamingProfile()) {
            return new File[]{roamingLapCacheDir, cacheDir};
        }
        return new File[]{cacheDir};
    }

    public static File[] getCacheEntries(boolean system) {
        File currentCacheDir;
        File file = currentCacheDir = system || Environment.isSystemCacheMode() ? sysCacheDir : cacheDir;
        if (currentCacheDir == null) {
            return new File[0];
        }
        return Cache.getIndexFiles(currentCacheDir);
    }

    public static File[] getIndexFiles(File cacheDir) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < 64; ++i) {
            File cacheSubDir = new File(cacheDir, String.valueOf(i));
            if (!cacheSubDir.isDirectory()) continue;
            File[] files = cacheSubDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String filename = pathname.getName();
                    boolean ret = filename.endsWith(Cache.INDEX_FILE_EXT);
                    return ret;
                }
            });
            fileList.addAll(Arrays.asList(files));
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static ArrayList<File> getJnlpCacheEntries(boolean system) {
        ArrayList<File> al = new ArrayList<File>();
        File[] files = Cache.getCacheEntries(system);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                CacheEntry ce = Cache.getCacheEntryFromFile(files[i]);
                if (ce == null || !ce.isJNLPFile()) continue;
                String idxpath = files[i].getPath();
                String jnlppath = idxpath.substring(0, idxpath.length() - 4);
                al.add(new File(jnlppath));
            }
        }
        return al;
    }

    public static CacheEntry findMatchingJNLPEntry(String originalURL) {
        File[] files = Cache.getCacheEntries(false);
        if (files != null) {
            for (File file : files) {
                String original;
                LocalApplicationProperties lap;
                CacheEntry ce = Cache.getCacheEntryFromFile(file);
                if (ce == null || !ce.isJNLPFile() || (lap = Cache.getLocalApplicationProperties(ce)) == null || !originalURL.equals(original = lap.getOriginalURL())) continue;
                return ce;
            }
        }
        return null;
    }

    public static void removeRemovedApp(String urlString, String title) {
        Properties p = Cache.getRemovedApps();
        String app = p.getProperty(urlString);
        if (app != null && app.equals(title)) {
            p.remove(urlString);
            Cache.setRemovedApps(p);
        }
    }

    public static void saveRemovedApp(URL href, String title) {
        if (Environment.isSystemCacheMode() ? Cache.getCacheEntry(href, null, cacheDir) != null : Cache.getCacheEntry(href, null, sysCacheDir) != null) {
            return;
        }
        Properties p = Cache.getRemovedApps();
        p.setProperty(href.toString(), title);
        Cache.setRemovedApps(p);
    }

    static void setRemovedApps(Properties props) {
        try {
            FileOutputStream fos = new FileOutputStream(Cache.getRemovePath());
            props.store(fos, "Removed JNLP Applications");
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Properties getRemovedApps() {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(Cache.getRemovePath());
            props.load(is);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    public static long getLastAccessed(boolean system) {
        final File f = new File(system ? sysCacheDir : cacheDir, LAST_ACCESS_FILE);
        Long ret = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return f.lastModified();
            }
        }, ACC_FILE_INSTANCE);
        return ret;
    }

    static void recordLastAccessed() {
        File f = new File(Cache.getActiveCacheDir(), LAST_ACCESS_FILE);
        try {
            FileOutputStream os = new FileOutputStream(f);
            ((OutputStream)os).write(46);
            ((OutputStream)os).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getRemovePath() {
        return cachePath + File.separator + REMOVED_APPS;
    }

    static boolean removeCacheEntry(URL resourceURL, String version) {
        CacheEntry ce = Cache.getCacheEntry(resourceURL, version, Cache.getActiveCacheDir());
        return Cache.removeCacheEntry(ce);
    }

    static void touch(final File file) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    file.setLastModified(System.currentTimeMillis());
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException pae) {
            Trace.ignoredException(pae);
        }
    }

    public static void removeAllCacheEntries(CacheEntry ce) {
        if (ce == null) {
            return;
        }
        URL u = null;
        try {
            u = new URL(ce.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String version = ce.getVersion();
        Cache.removeCacheEntry(ce);
        if (u == null) {
            return;
        }
        File[] idxFiles = Cache.getMatchingIndexFiles(Cache.getActiveCacheDir(), u);
        for (int i = 0; i < idxFiles.length; ++i) {
            CacheEntry c = new CacheEntry(idxFiles[i]);
            String cVers = c.getVersion();
            if ((version != null || cVers != null) && (version == null || !version.equals(cVers))) continue;
            Cache.removeCacheEntry(c);
        }
    }

    public static int removeDuplicateEntries(boolean ignoreIP) {
        int totalSize = 0;
        totalSize += Cache.removeDuplicateEntriesFromDir(Cache.getCacheEntries(true), ignoreIP, true);
        ArrayList<File> allEntries = new ArrayList<File>(Arrays.asList(Cache.getCacheEntries(false)));
        allEntries.addAll(Arrays.asList(Cache.getCacheEntries(true)));
        File[] allFiles = allEntries.toArray(new File[allEntries.size()]);
        if ((totalSize += Cache.removeDuplicateEntriesFromDir(allFiles, ignoreIP, false)) > 0) {
            Trace.println("Remove All Duplicates: " + totalSize + " bytes", TraceLevel.NETWORK);
        }
        return totalSize;
    }

    private static int removeDuplicateEntriesFromDir(File[] files, boolean ignoreIP, boolean fromSystemCache) {
        int size = 0;
        for (int i = 0; i < files.length; ++i) {
            CacheEntry ce = Cache.getCacheEntryFromFile(files[i]);
            size += Cache.removeDuplicateEntries(ce, ignoreIP, fromSystemCache);
        }
        return size;
    }

    public static int removeDuplicateEntries(CacheEntry ce, boolean ignoreIP, boolean fromSystemCache) {
        String urlString;
        int totalSize = 0;
        String string = urlString = null != ce ? ce.getURL() : null;
        if (ce == null || urlString == null || ce.isIncomplete() || MemoryCache.contains(urlString)) {
            return totalSize;
        }
        URL u = null;
        try {
            u = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (u == null) {
            return totalSize;
        }
        File from = fromSystemCache ? sysCacheDir : cacheDir;
        File[] idxFiles = Cache.getMatchingIndexFiles(from, u);
        CacheEntry lc = ce;
        for (int i = 0; i < idxFiles.length; ++i) {
            String cip;
            CacheEntry c = new CacheEntry(idxFiles[i]);
            String version = lc.getVersion();
            String cVers = c.getVersion();
            if ((version != null || cVers != null) && (version == null || !version.equals(cVers))) continue;
            String ip = ignoreIP ? null : lc.getCodebaseIP();
            String string2 = cip = ignoreIP ? null : c.getCodebaseIP();
            if (ip != cip && (ip == null || !ip.equals(cip)) || !lc.removeBefore(c)) continue;
            lc = c;
        }
        String version = lc.getVersion();
        int num = 0;
        for (int i = 0; i < idxFiles.length; ++i) {
            String cip;
            CacheEntry c = new CacheEntry(idxFiles[i]);
            String cVers = c.getVersion();
            if ((version != null || cVers != null) && (version == null || !version.equals(cVers))) continue;
            String ip = ignoreIP ? null : lc.getCodebaseIP();
            String string3 = cip = ignoreIP ? null : c.getCodebaseIP();
            if (ip != cip && (ip == null || !ip.equals(cip)) || c.getIndexFile().equals(lc.getIndexFile()) || !Cache.removeCacheEntry(c, false)) continue;
            totalSize += c.getContentLength();
            ++num;
        }
        if (totalSize > 0) {
            Trace.println("Remove " + num + " Duplicates of: [" + lc.getURL() + ", ", TraceLevel.NETWORK);
            Trace.println("\tidx: " + lc.getIndexFile() + "], " + totalSize + " bytes", TraceLevel.NETWORK);
        }
        return totalSize;
    }

    static boolean removeCacheEntry(final CacheEntry ce, final boolean removeLAP) {
        Boolean ret = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean ret = Cache.removeCacheEntryImpl(ce, removeLAP);
                return Boolean.valueOf(String.valueOf(ret));
            }
        }, ACC_FILE_INSTANCE);
        boolean removed = ret;
        if (!removed && !ce.isIncomplete()) {
            Cache.markResourceIncomplete(ce);
        }
        return removed;
    }

    private static boolean removeCacheEntryImpl(CacheEntry ce, boolean removeLAP) {
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("cache.removeCacheEntry", ce == null ? "" : ce.getURL()), TraceLevel.NETWORK);
        }
        if (!ce.getIndexFile().getParentFile().getParentFile().equals(Cache.getActiveCacheDir())) {
            return true;
        }
        File dataFile = new File(ce.getResourceFilename());
        File indexFile = ce.getIndexFile();
        String urlString = ce.getURL();
        String version = ce.getVersion();
        boolean ret = false;
        boolean ret2 = false;
        if (!MemoryCache.contains(urlString)) {
            ret = Platform.get().getNativeSandboxBroker().deleteFile(dataFile);
            if (!ret) {
                Trace.println("Failed to delete: " + dataFile, TraceLevel.CACHE);
                Platform.get().getNativeSandboxBroker().deleteOnExitFile(dataFile);
            }
            if (!(ret2 = Platform.get().getNativeSandboxBroker().deleteFile(indexFile))) {
                Trace.println("Failed to delete: " + indexFile, TraceLevel.CACHE);
                Platform.get().getNativeSandboxBroker().deleteOnExitFile(indexFile);
            }
        } else {
            Platform.get().getNativeSandboxBroker().deleteOnExitFile(dataFile);
            Platform.get().getNativeSandboxBroker().deleteOnExitFile(indexFile);
        }
        Cache.clobber(new File(ce.getNativeLibPath()));
        try {
            if (removeLAP) {
                for (File dir : Cache.getActiveLapCacheDirs()) {
                    String name = Cache.getLapFileName(new URL(urlString), version, false);
                    File lapFile = new File(dir, name);
                    Platform.get().getNativeSandboxBroker().deleteFile(lapFile);
                    name = Cache.getLapFileName(new URL(urlString), version, true);
                    if (name == null) continue;
                    lapFile = new File(dir, name);
                    Platform.get().getNativeSandboxBroker().deleteFile(lapFile);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        File icoFile = new File(ce.getResourceFilename() + ".ico");
        Cache.ensureFileDeleted(icoFile);
        Cache.recordLastAccessed();
        MemoryCache.removeLoadedResource(ce.getURL());
        return ret && ret2;
    }

    private static void clobber(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    Cache.clobber(files[i]);
                }
                Cache.ensureFileDeleted(f);
            } else {
                Cache.ensureFileDeleted(f);
            }
        }
    }

    public static void ensureFileDeleted(File f) {
        if (f != null && f.exists() && !Platform.get().getNativeSandboxBroker().deleteFile(f)) {
            Platform.get().getNativeSandboxBroker().deleteOnExitFile(f);
        }
    }

    public static boolean removeCacheEntry(CacheEntry ce) {
        return Cache.removeCacheEntry(ce, true);
    }

    static File[] getMatchingIndexFiles(File cacheDirectory, URL url) {
        final String key = Cache.getKey(url);
        final File directory = new File(cacheDirectory.getPath() + File.separator + Cache.getBucket(key));
        File[] idxFiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                File[] files = directory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String filename = pathname.getName();
                        return filename.startsWith(key) && filename.endsWith(Cache.INDEX_FILE_EXT);
                    }
                });
                return files;
            }
        }, ACC_FILE_INSTANCE);
        return idxFiles;
    }

    static CacheEntry getCacheEntryFromFileIncludeTempJNLP(File idxFile) {
        boolean recovery = false;
        if (!Cache.isCacheEnabled()) {
            recovery = true;
        }
        CacheEntry ce = Cache.getCacheEntryFromFile(idxFile, recovery);
        if (recovery) {
            if (ce.isJNLPFile()) {
                if (ce.getIncomplete() == 2) {
                    ce.setIncomplete(1);
                }
            } else {
                ce = null;
            }
        }
        return ce;
    }

    public static CacheEntry getCacheEntryFromFile(File idxFile) {
        return Cache.getCacheEntryFromFile(idxFile, false);
    }

    public static CacheEntry getCacheEntryFromFile(File idxFile, boolean recovery) {
        CacheEntry ce = new CacheEntry(idxFile, recovery);
        if (ce != null && !ce.isIncomplete() && (recovery || Cache.isCacheEntryIPValid(ce))) {
            return ce;
        }
        return null;
    }

    public static String getVersionFromFilename(String filename) {
        int firstHyphen = filename.indexOf(DASH);
        int secondHyphen = filename.indexOf(DASH, firstHyphen + 1);
        int lastHyphen = filename.lastIndexOf(DASH);
        if (secondHyphen >= 0 && lastHyphen > secondHyphen + 1) {
            return filename.substring(secondHyphen + 1, lastHyphen);
        }
        return null;
    }

    public static CacheEntry getLatestCacheEntry(URL url) {
        File latestCacheFile = null;
        String latestVersion = null;
        File[] idxFiles = Cache.getMatchingIndexFiles(cacheDir, url);
        for (int i = 0; i < idxFiles.length; ++i) {
            if (latestCacheFile == null) {
                latestCacheFile = idxFiles[i];
                continue;
            }
            String curVer = Cache.getVersionFromFilename(idxFiles[i].getName());
            String latestVer = Cache.getVersionFromFilename(latestCacheFile.getName());
            if (curVer == null || latestVer != null && curVer.compareTo(latestVer) <= 0) continue;
            latestCacheFile = idxFiles[i];
        }
        if (latestCacheFile != null) {
            return Cache.getCacheEntryFromFile(latestCacheFile);
        }
        return CacheUpgrader.getInstance().upgradeItem(url, latestVersion, 1);
    }

    private static CacheEntry getCacheEntryFromIdxFiles(File[] idxFiles, URL url, String version, int contentType) {
        File nativeDir;
        CacheEntry ce = null;
        CacheEntry found = null;
        if (idxFiles != null) {
            for (int i = 0; i < idxFiles.length; ++i) {
                ce = new CacheEntry(idxFiles[i]);
                if (ce.getIncomplete() == 0) {
                    if (ce.getURL().equals(url.toString())) {
                        if (!Cache.isCacheEntryIPValid(ce)) continue;
                        if (version == null && ce.getVersion() == null) {
                            found = ce;
                            break;
                        }
                        if (version == null || !new VersionString(version).contains(ce.getVersion())) continue;
                        if (found == null) {
                            found = ce;
                            continue;
                        }
                        if (ce.getVersion() == null || ce.getVersion().compareTo(found.getVersion()) <= 0) continue;
                        found = ce;
                        continue;
                    }
                    if (ce.getURL().indexOf(63) == -1) continue;
                    Cache.removeCacheEntry(ce, false);
                    continue;
                }
                Cache.cleanup();
            }
        }
        if (found != null && DownloadEngine.isNativeContentType(contentType) && !found.isRedirectEntry() && !(nativeDir = new File(found.getNativeLibPath())).isDirectory()) {
            Cache.removeCacheEntry(found);
            found = null;
        }
        return found;
    }

    public static void updateHostIPFile(String host) {
        String cachedIP = Cache.getCachedHostIP(host);
        if (cachedIP == null) {
            Cache.createHostEntry(host);
        } else {
            String currentIP = Cache.getCurrentIP(host, cachedIP);
            if (currentIP != null && !currentIP.equals(cachedIP)) {
                Cache.updateHostEntry(host);
            }
        }
    }

    private static URL getHostURL(String host) {
        URL u = null;
        try {
            u = new URL("http://" + host);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u;
    }

    private static void updateHostEntry(String host) {
        URL u = Cache.getHostURL(host);
        final File[] hostFiles = Cache.getMatchingHostFiles(hostDir, u);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (int i = 0; i < hostFiles.length; ++i) {
                    hostFiles[i].delete();
                }
                return null;
            }
        }, ACC_FILE_INSTANCE);
        Cache.createHostEntry(host);
    }

    private static String getCurrentIP(final String host, String cachedIP) {
        if (host == null || cachedIP == null) {
            return null;
        }
        if (!doIPLookup) {
            return null;
        }
        String hostIP = null;
        InetAddress cacheIna = null;
        try {
            cacheIna = InetAddress.getByName(cachedIP);
        }
        catch (UnknownHostException uhe) {
            Trace.ignoredException(uhe);
        }
        if (Config.isJavaVersionAtLeast9()) {
            final InetAddress hostAddress = cacheIna;
            InetAddress inetAddress = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

                @Override
                public InetAddress run() {
                    try {
                        return SharedSecrets.getJavaNetInetAddressAccess().getByName(host, hostAddress);
                    }
                    catch (UnknownHostException uhe) {
                        return null;
                    }
                }
            });
            if (inetAddress != null) {
                hostIP = inetAddress.getHostAddress();
            }
        } else {
            final Class[] type = new Class[]{String.class, InetAddress.class};
            final Object[] arguments = new Object[]{host, cacheIna};
            InetAddress inetAddress = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

                @Override
                public InetAddress run() {
                    Method lookupMethod;
                    try {
                        lookupMethod = InetAddress.class.getDeclaredMethod("getByName", type);
                    }
                    catch (NoSuchMethodException nsme) {
                        return null;
                    }
                    lookupMethod.setAccessible(true);
                    if (!Modifier.isStatic(lookupMethod.getModifiers())) {
                        return null;
                    }
                    InetAddress ina = null;
                    try {
                        ina = (InetAddress)lookupMethod.invoke(null, arguments);
                    }
                    catch (IllegalAccessException iae) {
                        Trace.ignoredException(iae);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    return ina;
                }
            }, ACC_GET_IP_INSTANCE);
            if (inetAddress != null) {
                hostIP = inetAddress.getHostAddress();
            }
        }
        return hostIP;
    }

    private static boolean isCacheEntryIPValid(CacheEntry ce) {
        boolean result = true;
        String cacheEntryCodebaseIP = ce.getCodebaseIP();
        if (cacheEntryCodebaseIP == null) {
            return result;
        }
        URL u = null;
        try {
            u = new URL(ce.getURL());
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException(mue);
            return false;
        }
        if ("https".equalsIgnoreCase(u.getProtocol())) {
            return true;
        }
        String host = u.getHost();
        String currentHostIP = Cache.getCurrentIP(host, cacheEntryCodebaseIP);
        if (currentHostIP == null) {
            return true;
        }
        if (!currentHostIP.equals(cacheEntryCodebaseIP)) {
            Trace.println("CacheEntry IP mismatch: " + currentHostIP + " != " + cacheEntryCodebaseIP, TraceLevel.CACHE);
            result = false;
        }
        return result;
    }

    public static CacheEntry getCacheEntry(URL url, String version) {
        return Cache.getCacheEntry(url, version, 1);
    }

    public static CacheEntry getCacheEntry(URL url, String version, int contentType) {
        CacheEntry sysFound;
        if (url == null || !Cache.isCacheEnabled()) {
            return null;
        }
        Object o = MemoryCache.getLoadedResource(url.toString());
        if (o != null && !(o instanceof CacheEntry)) {
            return null;
        }
        CacheEntry ce = (CacheEntry)o;
        if (ce != null && ce.matchesVersionString(version, true)) {
            if (ce.getIsProxied() != 0) {
                Cache.setIsProxiedHost(url.getHost());
            }
            return ce;
        }
        CacheEntry found = Cache.getCacheEntry(url, version, cacheDir, contentType);
        if (found == null) {
            found = CacheUpgrader.getInstance().upgradeItem(url, version, contentType);
        }
        if ((sysFound = Cache.getCacheEntry(url, version, sysCacheDir, contentType)) == null) {
            sysFound = CacheUpgrader.getSystemInstance().upgradeItem(url, version, contentType);
        }
        if (Environment.isSystemCacheMode()) {
            if (sysFound != null) {
                MemoryCache.addLoadedResource(url.toString(), sysFound);
                Trace.println("System Cache: " + ResourceManager.getString("cache.getCacheEntry.return.found", url == null ? "" : url.toString(), version), TraceLevel.NETWORK);
                if (sysFound.getIsProxied() != 0) {
                    Cache.setIsProxiedHost(url.getHost());
                }
            }
            return sysFound;
        }
        if (sysFound != null) {
            if (found != null) {
                if (found.getLastModified() <= sysFound.getLastModified()) {
                    found = sysFound;
                }
            } else {
                found = sysFound;
            }
        }
        if (Cache.hasIncompatibleCompressEncoding(found)) {
            Cache.markResourceIncomplete(found);
            found = null;
        }
        if (found == null) {
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("cache.getCacheEntry.return.notfound", url == null ? "" : url.toString(), version), TraceLevel.NETWORK);
            }
        } else {
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("cache.getCacheEntry.return.found", url == null ? "" : url.toString(), version), TraceLevel.NETWORK);
            }
            MemoryCache.addLoadedResource(url.toString(), found);
        }
        if (found != null && found.getIsProxied() != 0) {
            Cache.setIsProxiedHost(url.getHost());
        }
        return found;
    }

    private static CacheEntry getCacheEntry(URL url, String version, File dir) {
        return Cache.getCacheEntry(url, version, dir, 1);
    }

    private static CacheEntry getCacheEntry(URL url, String version, File dir, int contentType) {
        if (dir == null) {
            return null;
        }
        File[] idxFiles = Cache.getMatchingIndexFiles(dir, url);
        CacheEntry ce = Cache.getCacheEntryFromIdxFiles(idxFiles, url, version, contentType);
        if ((ce = Cache.followsRedirect(url, ce, dir, contentType)) != null && ce.getIsProxied() != 0) {
            Cache.setIsProxiedHost(url.getHost());
        }
        return ce;
    }

    private static CacheEntry followsRedirect(URL sourceURL, CacheEntry ce, File dir, int contentType) {
        URL targetURL;
        URL uRL = targetURL = ce == null ? null : ce.getRedirectFinalURL();
        if (targetURL != null) {
            CacheEntry target = Cache.getCacheEntry(targetURL, ce.getVersion(), dir, contentType);
            if (target != null) {
                Cache.addLoadedResource(target);
                DownloadEngine.addKnownRedirectHost(sourceURL.getHost(), targetURL.getHost());
            }
            return target;
        }
        return ce;
    }

    private static File[] getMatchingMuffinFiles(File directory, URL url) {
        final String key = Cache.getKey(url);
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filename = pathname.getName();
                return filename.startsWith(key) && !filename.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        return files;
    }

    private static File[] getMatchingMuffinAttributeFiles(File directory, URL url) {
        final String key = Cache.getKey(url);
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filename = pathname.getName();
                return filename.startsWith(key) && filename.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        return files;
    }

    public static File getMuffinFile(URL url) {
        File[] files = Cache.getMatchingMuffinFiles(muffinDir, url);
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    public static File getMuffinAttributeFile(URL url) {
        File[] files = Cache.getMatchingMuffinAttributeFiles(muffinDir, url);
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getMuffinAttributes(URL url) throws IOException {
        BufferedReader br = null;
        long tag = -1L;
        long maxsize = -1L;
        try {
            File muffinFile = Cache.getMuffinAttributeFile(url);
            if (muffinFile == null) {
                throw new FileNotFoundException("Muffin not found for " + url);
            }
            FileInputStream is = new FileInputStream(muffinFile);
            br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            try {
                tag = Integer.parseInt(line);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe.getMessage());
            }
            line = br.readLine();
            try {
                maxsize = Long.parseLong(line);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe.getMessage());
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return new long[]{tag, maxsize};
    }

    public static void removeMuffinEntry(URL url) throws IOException {
        File muffinFile = Cache.getMuffinFile(url);
        if (muffinFile != null) {
            if (!muffinFile.delete()) {
                throw new IOException("delete failed for muffin: " + url);
            }
            File maFile = new File(muffinFile.getPath() + MUFFIN_FILE_EXT);
            if (!maFile.delete()) {
                throw new IOException("delete failed for muffin: " + url);
            }
        } else {
            throw new FileNotFoundException("Muffin for " + url + " does not exists");
        }
    }

    private static String getCachedHostIP(String host) {
        if (host == null) {
            return null;
        }
        URL u = Cache.getHostURL(host);
        String cachedIP = null;
        final File cachedHostFile = Cache.getHostFile(u);
        if (cachedHostFile != null) {
            cachedIP = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String ip = null;
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(cachedHostFile));
                        ip = br.readLine();
                        br.close();
                    }
                    catch (IOException ioe) {
                        Trace.ignoredException(ioe);
                    }
                    return ip;
                }
            }, ACC_FILE_INSTANCE);
        }
        return cachedIP;
    }

    private static File getHostFile(URL url) {
        File[] files = Cache.getMatchingHostFiles(hostDir, url);
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    private static File[] getMatchingHostFiles(final File directory, URL url) {
        final String key = Cache.getKey(url);
        File[] hostFiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                File[] files = directory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String filename = pathname.getName();
                        return filename.startsWith(key) && filename.endsWith(Cache.HOST_FILE_EXT);
                    }
                });
                return files;
            }
        }, ACC_FILE_INSTANCE);
        return hostFiles;
    }

    static InetAddress getHostIP(String host) {
        InetAddress ina = null;
        try {
            ina = InetAddress.getByName(host);
        }
        catch (UnknownHostException uhe) {
            try {
                ina = InetAddress.getByName(IP_ADDR_CANNOT_RESOLVE);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return ina;
    }

    private static void createHostEntry(String host) {
        URL u = Cache.getHostURL(host);
        String key = Cache.getKey(u);
        String filename = key + Integer.toString(Cache.getRandom(), 16);
        final File hostFile = new File(hostDir, filename + HOST_FILE_EXT);
        InetAddress ina = Cache.getHostIP(host);
        if (ina != null) {
            final String hostAddr = ina.getHostAddress();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        BufferedWriter bw = new BufferedWriter(new FileWriter(hostFile));
                        bw.write(hostAddr);
                        bw.close();
                    }
                    catch (IOException ioe) {
                        Trace.ignoredException(ioe);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
    }

    public static void createMuffinEntry(URL url, int tag, long maxSize) throws IOException {
        String key = Cache.getKey(url);
        File[] files = Cache.getMatchingMuffinAttributeFiles(muffinDir, url);
        if (files.length != 0) {
            throw new IOException("insert failed in cache: target already exixts");
        }
        String filename = key + Integer.toString(Cache.getRandom(), 16);
        File muffinAttributeFile = new File(muffinDir, filename + MUFFIN_FILE_EXT);
        File muffinFile = new File(muffinDir, filename);
        Cache.putMuffinAttributes(muffinAttributeFile, url, tag, maxSize);
        muffinFile.createNewFile();
    }

    public static String[] getMuffinNames(URL url) {
        ArrayList<String> entries = new ArrayList<String>();
        File[] files = muffinDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filename = pathname.getName();
                return filename.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        URL u = null;
        for (int i = 0; i < files.length; ++i) {
            try {
                u = Cache.getCachedMuffinURL(files[i]);
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
            if (u == null) continue;
            URL urlNoQuery = HttpUtils.removeQueryStringFromURL(u);
            String entryName = urlNoQuery.getFile().substring(1 + urlNoQuery.getFile().lastIndexOf(47));
            if (!u.toString().equals(url.toString() + entryName)) continue;
            entries.add(entryName);
        }
        return entries.toArray(new String[entries.size()]);
    }

    public static URL[] getAccessibleMuffins(URL url) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        File[] files = muffinDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filename = pathname.getName();
                return filename.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            URL u = Cache.getCachedMuffinURL(files[i]);
            if (!u.getHost().equals(url.getHost())) continue;
            list.add(u);
        }
        return list.toArray(new URL[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL getCachedMuffinURL(File muffinAttributeFile) throws IOException {
        String line = null;
        try (BufferedReader br = null;){
            FileInputStream is = new FileInputStream(muffinAttributeFile);
            br = new BufferedReader(new InputStreamReader(is));
            line = br.readLine();
            line = br.readLine();
            line = br.readLine();
        }
        URL url = null;
        try {
            url = new URL(line);
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException(mue);
        }
        return url;
    }

    public static long getMuffinSize(URL url) throws IOException {
        long size = 0L;
        File muffinFile = Cache.getMuffinFile(url);
        if (muffinFile != null && muffinFile.exists()) {
            size += muffinFile.length();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putMuffinAttributes(File muffinAttributeFile, URL url, int tag, long maxsize) throws IOException {
        try (PrintStream ps = new PrintStream(new FileOutputStream(muffinAttributeFile));){
            ps.println(tag);
            ps.println(maxsize);
            ps.println(url.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putMuffinAttributes(URL url, int tag, long maxsize) throws IOException {
        File muffinAttributeFile = Cache.getMuffinAttributeFile(url);
        try (PrintStream ps = new PrintStream(new FileOutputStream(muffinAttributeFile));){
            ps.println(tag);
            ps.println(maxsize);
            ps.println(url.toString());
        }
    }

    static String generateCacheFileName(final URL url, final String version) throws IOException {
        String filename;
        block2: {
            filename = null;
            try {
                filename = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws IOException {
                        File dataFile;
                        String filename;
                        File indexFile;
                        String key = Cache.getKey(url);
                        do {
                            filename = Cache.getBucket(key) + File.separator + key + Integer.toString(Cache.getRandom(), 16) + Cache.getVersionTag(version);
                            dataFile = new File(cacheDir, filename);
                        } while ((indexFile = new File(cacheDir, filename + Cache.INDEX_FILE_EXT)).exists() || dataFile.exists());
                        indexFile = null;
                        dataFile = null;
                        return filename;
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (PrivilegedActionException pae) {
                if (!(pae.getException() instanceof IOException)) break block2;
                throw (IOException)pae.getException();
            }
        }
        return filename;
    }

    public static int getBucket(String key) {
        return Integer.valueOf(key.substring(0, key.length() - 1), 16) & 0x3F;
    }

    public static String getKey(URL url) {
        int hashCode = Cache.hashCode(HttpUtils.removeQueryStringFromURL(url));
        if (hashCode < 0) {
            hashCode -= Integer.MIN_VALUE;
        }
        String key = Integer.toString(hashCode, 16);
        return key + DASH;
    }

    public static String getSecureKey(URL url) {
        URL urlNoQuery = HttpUtils.removeQueryStringFromURL(url);
        Object key = CertUtils.getSecureHashForString(urlNoQuery.toString());
        key = (String)key + DASH;
        return ((String)key).toLowerCase();
    }

    protected static int hashCode(URL x) {
        int h = x.toString().hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    protected static String getFileExtension(String name) {
        String ext = "";
        int extIndex = name.lastIndexOf(46);
        if (extIndex != -1) {
            ext = name.substring(extIndex);
        }
        return ext;
    }

    protected static int getRandom() {
        return 0x10000000 + random.nextInt(0x6FFFFFFF);
    }

    public static void insertFile(File dataFile, int contentType, URL url, String version, long ts, long expiration) throws IOException {
        CacheEntry ce = Cache.createNewCacheEntry(url, version);
        try {
            Cache.copyFile(dataFile, new File(ce.getResourceFilename()));
        }
        catch (IOException e) {
            Cache.removeCacheEntry(ce);
            throw e;
        }
        ce.setBusy(0);
        ce.setIncomplete(0);
        ce.setURL(url.toString());
        ce.setContentLength((int)dataFile.length());
        ce.setLastModified(ts);
        ce.setExpirationDate(expiration);
        if (version != null) {
            ce.setVersion(version);
        }
        if (DownloadEngine.isJarContentType(contentType)) {
            MessageHeader headerFields = new MessageHeader();
            headerFields.add("deploy-request-content-type", "application/x-java-archive");
            ce.setHeaders(headerFields);
        }
        Cache.setCeIsProxied(ce, url.getHost());
        ce.writeFileToDisk(contentType, null);
        Cache.recordLastAccessed();
    }

    public static void insertMuffin(URL url, File muffin, int tag, long maxSize) throws IOException {
        File[] files = Cache.getMatchingMuffinAttributeFiles(muffinDir, url);
        if (files.length != 0) {
            throw new IOException("insert failed in cache: target already exixts");
        }
        String key = Cache.getKey(url);
        String filename = key + Integer.toString(Cache.getRandom(), 16);
        File muffinAttributeFile = new File(muffinDir, filename + MUFFIN_FILE_EXT);
        Cache.putMuffinAttributes(muffinAttributeFile, url, tag, maxSize);
        Cache.copyFile(muffin, new File(muffinDir, filename));
    }

    public static void copyFile(File src, File dst) throws IOException {
        Cache.copyStream(new FileInputStream(src), new FileOutputStream(dst));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] b = new byte[10240];
        try {
            int n = bis.read(b);
            while (n >= 0) {
                bos.write(b, 0, n);
                n = bis.read(b);
            }
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void removeAllMuffins() {
        File[] children = muffinDir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            children[i].delete();
        }
    }

    public static void removeAllLapFiles() {
        for (File f : Cache.getActiveLapCacheDirs()) {
            Cache.removeAllLapFiles(f);
        }
    }

    private static void removeAllLapFiles(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                File[] child = f.listFiles();
                for (int i = 0; i < child.length; ++i) {
                    Cache.removeAllLapFiles(child[i]);
                }
            } else if (f.getName().endsWith(LAP_FILE_EXT)) {
                Cache.ensureFileDeleted(f);
            }
        }
    }

    public static boolean removeRemeberedDecisions() {
        boolean result = Cache.removeRemeberedDecisions(Cache.getActiveLapCacheDir());
        Cache.reset();
        try {
            File f = new File(Config.getSplashIndex());
            f.delete();
            f.createNewFile();
            f = new File(Config.getUserAuthFile());
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean removeRemeberedDecisions(File f) {
        boolean result = true;
        if (f != null) {
            if (f.isDirectory()) {
                File[] child = f.listFiles();
                for (int i = 0; i < child.length; ++i) {
                    result = result && Cache.removeRemeberedDecisions(child[i]);
                }
            } else if (f.getName().endsWith(LAP_FILE_EXT)) {
                result = Cache.removeRemeberedDecision(f);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeRemeberedDecision(File f) {
        boolean result = true;
        Properties props = new Properties();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            props.load(new ByteArrayInputStream(Cache.getLapBytes(f)));
            for (String name : props.stringPropertyNames()) {
                if (!name.startsWith("ssv.") && !name.startsWith("jnlp.api.always.") && !name.equals("sun.plugin.security.printDialog") && !name.equals("js.allowed.codebases")) continue;
                props.remove(name);
            }
            props.store(bos, "LAP");
            Cache.putLapData(f, bos.toByteArray());
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
            result = false;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                Trace.ignored(e);
            }
        }
        return result;
    }

    static String getCachedResourceFilePath(URL resourceURL, String versionString) throws IOException {
        CacheEntry ce;
        if (Cache.isCacheEnabled() && (ce = Cache.getCacheEntry(resourceURL, versionString)) != null) {
            return ce.getResourceFilename();
        }
        Object o = MemoryCache.getLoadedResource(resourceURL.toString());
        if (o instanceof Resource) {
            return ((Resource)o).getResourceFilename();
        }
        throw new IOException("Cannot find cached resource for URL: " + resourceURL.toString());
    }

    static {
        loadedProperties = new HashMap<String, LocalApplicationProperties>();
        syncObject = new Object();
        cleanupEnabled = true;
        Cache.reset();
        if (Cache.isCacheEnabled() && Config.getCacheSizeMax() != -1L) {
            ct = new CleanupThreadHolder("CacheCleanUpThread", syncObject);
            ct.getThread().start();
        } else {
            ct = null;
        }
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        perms = new Permissions();
        perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(perm);
        PropertyPermission propPerm = new PropertyPermission("*", "read,write");
        ((PermissionCollection)perms).add(propPerm);
        ACC_FILE_AND_PROPERTY_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        perms = new Permissions();
        SocketPermission perm1 = new SocketPermission("*", "resolve");
        ((PermissionCollection)perms).add(perm1);
        RuntimePermission perm2 = new RuntimePermission("accessDeclaredMembers");
        ((PermissionCollection)perms).add(perm2);
        ReflectPermission perm3 = new ReflectPermission("suppressAccessChecks");
        ((PermissionCollection)perms).add(perm3);
        ACC_GET_IP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

