/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.util;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.lang.reflect.Method;

public class JfxHelper {
    private static final VersionID JRE_MINIMUM_VER = new VersionID("1.7.0_06");
    private static final String[] SUPPORTTED_OS = new String[]{"Windows", "Linux", "Mac OS X"};
    private static VersionID currentVersion = null;
    private static boolean detectionCompleted = false;

    public static boolean isCompatibleRuntime(JREInfo running, JREInfo selected) {
        if (running.getFXVersion() == null && selected.getFXVersion() == null) {
            return true;
        }
        return !running.getProductVersion().isGreaterThan(selected.getProductVersion()) && !running.getFXVersion().isGreaterThan(selected.getFXVersion());
    }

    public static boolean isJfxSupportSatisfied(ClassLoader cl, LaunchDesc ld) {
        if (ld.needFX()) {
            return JfxHelper.isJfxSupportSatisfied(cl, ld.getFXRequest());
        }
        return true;
    }

    public static boolean isJfxSupportSatisfied(ClassLoader cl, String needVersion) {
        if (null == needVersion || needVersion.length() == 0) {
            needVersion = "2.2+";
        }
        VersionString asked = new VersionString(needVersion);
        VersionID runningVersion = JfxHelper.getCurrentJfxVersion(cl);
        return null == runningVersion ? false : asked.contains(runningVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VersionID getCurrentJfxVersion(ClassLoader cl) {
        if (detectionCompleted) return currentVersion;
        Class<JfxHelper> clazz = JfxHelper.class;
        synchronized (JfxHelper.class) {
            String fx_ver;
            if (detectionCompleted) return currentVersion;
            try {
                if (null == cl) {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                Class<?> cls = cl.loadClass("com.sun.javafx.runtime.VersionInfo");
                Method m = cls.getMethod("getVersion", new Class[0]);
                String v = (String)m.invoke(null, (Object[])null);
                currentVersion = new VersionID(v);
            }
            catch (Exception e) {
                currentVersion = null;
            }
            if (null == currentVersion && (fx_ver = System.getProperty("jnlp.fx")) != null) {
                fx_ver = fx_ver.trim();
                currentVersion = new VersionID(fx_ver);
            }
            detectionCompleted = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return currentVersion;
        }
    }

    static void reset() {
        detectionCompleted = false;
    }

    public static boolean isSupportedJreVersion(VersionID ver) {
        return !JRE_MINIMUM_VER.isGreaterThan(ver);
    }

    public static boolean isSupportedOS(String os_name) {
        for (String SUPPORTTED_OS1 : SUPPORTTED_OS) {
            if (!SUPPORTTED_OS1.contains(os_name)) continue;
            return true;
        }
        return false;
    }

    public static void validateJfxRequest(LaunchDesc ld, JREInfo jre) throws LaunchDescException {
        if (!JfxHelper.isSupportedOS(jre.getOSName())) {
            String msg = ResourceManager.getString((String)"launch.error.jfx.os", (Object[])new Object[]{jre.getOSName()});
            throw new LaunchDescException(ld, msg, null);
        }
        VersionID ver = jre.getProductVersion();
        if (!JfxHelper.isSupportedJreVersion(ver)) {
            String msg = ResourceManager.getString((String)"launch.error.jfx.jre", (Object[])new Object[]{JRE_MINIMUM_VER.toString(), ver.toString()});
            throw new LaunchDescException(ld, msg, null);
        }
    }

    public static void validateJfxRequest(LaunchDesc ld, JREDesc jd) throws LaunchDescException {
        VersionID ver = new VersionID(jd.getVersion());
        if (!JfxHelper.isSupportedJreVersion(ver) && !ver.match(JRE_MINIMUM_VER)) {
            String msg = ResourceManager.getString((String)"launch.error.jfx.jre", (Object[])new Object[]{JRE_MINIMUM_VER.toString(), ver.toString()});
            throw new LaunchDescException(ld, msg, null);
        }
    }
}

