/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.JARUpdater;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;

public class JARDesc
implements ResourceType {
    private URL _location;
    private String _locationString;
    private String _version;
    private int _size;
    private boolean _isNativeLib;
    private boolean _isLazyDownload;
    private boolean _isProgressDownload;
    private boolean _isMainFile;
    private String _part;
    private ResourcesDesc _parent;
    private JARUpdater _updater = null;
    private boolean _pack200Enabled = false;
    private boolean _versionEnabled = false;

    public JARDesc(URL location, String version, boolean isLazy, boolean isMainFile, boolean isNativeLib, String part, int size, ResourcesDesc parent) {
        this(location, version, isLazy, isMainFile, isNativeLib, part, size, parent, false);
    }

    public JARDesc(URL location, String version, boolean isLazy, boolean isMainFile, boolean isNativeLib, String part, int size, ResourcesDesc parent, boolean isProgress) {
        this._location = location;
        this._locationString = URLUtil.toNormalizedString((URL)location);
        this._version = version;
        this._isMainFile = isMainFile;
        this._isLazyDownload = isLazy && !this._isMainFile;
        this._isNativeLib = isNativeLib;
        this._part = part;
        this._size = size;
        this._parent = parent;
        this._isProgressDownload = isProgress;
    }

    public void setPack200Enabled() {
        this._pack200Enabled = true;
    }

    public void setVersionEnabled() {
        this._versionEnabled = true;
    }

    public boolean isPack200Enabled() {
        return this._pack200Enabled;
    }

    public boolean isVersionEnabled() {
        return this._versionEnabled;
    }

    public boolean isNativeLib() {
        return this._isNativeLib;
    }

    public boolean isJavaFile() {
        return !this._isNativeLib;
    }

    public boolean isProgressJar() {
        return this._isProgressDownload;
    }

    public URL getLocation() {
        return this._location;
    }

    public String getLocationString() {
        return this._locationString;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isLazyDownload() {
        return this._isLazyDownload;
    }

    public void setLazyDownload(boolean isLazy) {
        this._isLazyDownload = isLazy;
    }

    public boolean isMainJarFile() {
        return this._isMainFile;
    }

    public String getPartName() {
        return this._part;
    }

    public int getSize() {
        return this._size;
    }

    public ResourcesDesc getParent() {
        return this._parent;
    }

    @Override
    public void visit(ResourceVisitor rv) {
        rv.visitJARDesc(this);
    }

    public synchronized JARUpdater getUpdater() {
        if (this._updater == null) {
            this._updater = new JARUpdater(this);
        }
        return this._updater;
    }

    public CodeRef getCodeRef() {
        return new CodeRef(this.getLocation(), this.getVersion(), false, this.isPack200Enabled());
    }

    public XMLNode asXML() {
        XMLNode ret = null;
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        ab.add("href", this._location);
        ab.add("version", this._version);
        ab.add("part", this._part);
        ab.add("download", this.isProgressJar() ? "progress" : (this.isLazyDownload() ? "lazy" : "eager"));
        ab.add("main", this.isMainJarFile() ? "true" : "false");
        String type = this._isNativeLib ? "nativelib" : "jar";
        ret = new XMLNode(type, ab.getAttributeList());
        return ret;
    }

    public String toString() {
        return "JARDesc[" + this._locationString + ":" + this._version + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JARDesc)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JARDesc jd = (JARDesc)obj;
        if (this.getVersion() != null) {
            return this.getVersion().equals(jd.getVersion()) && this._locationString.equals(jd._locationString);
        }
        return jd.getVersion() == null && this._locationString.equals(jd._locationString);
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.getVersion() != null) {
            hashcode = this.getVersion().hashCode();
        }
        if (this._locationString != null) {
            hashcode ^= this._locationString.hashCode();
        }
        return hashcode;
    }
}

