/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OperaPreferences {
    private static final String OPERA_ENCODING = "UTF-8";
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final char SEPARATOR = '=';
    private static final int DEFAULT_SIZE = 16384;
    private static final int DEFAULT_SECTION_COUNT = 20;
    private ArrayList<PreferenceSection> sections = new ArrayList(20);

    public void load(InputStream istream) throws IOException {
        InputStreamReader ireader = new InputStreamReader(istream, OPERA_ENCODING);
        BufferedReader in = new BufferedReader(ireader, 16384);
        String section = "";
        String line = in.readLine();
        while (line != null) {
            if (line.length() > 0) {
                if (line.charAt(0) == '[') {
                    section = line.substring(1, line.indexOf(93));
                } else {
                    String key = null;
                    String value = null;
                    int index = line.indexOf(61);
                    if (index >= 0) {
                        key = line.substring(0, index);
                        value = line.substring(index + 1);
                    } else {
                        key = line;
                    }
                    this.put(section, key, value);
                }
            }
            line = in.readLine();
        }
    }

    public void store(OutputStream ostream) throws IOException {
        OutputStreamWriter owriter = new OutputStreamWriter(ostream, OPERA_ENCODING);
        PrintWriter out = new PrintWriter((Writer)owriter, true);
        out.println(this.toString());
    }

    public boolean containsSection(String section) {
        return this.indexOf(section) >= 0;
    }

    public boolean containsKey(String section, String key) {
        int i = this.indexOf(section);
        return i < 0 ? false : this.sections.get(i).contains(key);
    }

    public String get(String section, String key) {
        int i = this.indexOf(section);
        PreferenceSection.PreferenceEntry entry = i < 0 ? null : this.sections.get(i).get(key);
        return entry == null ? null : entry.getValue();
    }

    public String put(String section, String key, String value) {
        int i = this.indexOf(section);
        PreferenceSection ps = null;
        if (i < 0) {
            ps = new PreferenceSection(section);
            this.sections.add(ps);
        } else {
            ps = this.sections.get(i);
        }
        return ps.put(key, value);
    }

    public PreferenceSection remove(String section) {
        int i = this.indexOf(section);
        return i < 0 ? null : this.sections.remove(i);
    }

    public String remove(String section, String key) {
        int i = this.indexOf(section);
        return i < 0 ? null : this.sections.get(i).remove(key);
    }

    public Iterator<?> iterator(String section) {
        int i = this.indexOf(section);
        return i < 0 ? new PreferenceSection(section).iterator() : this.sections.get(i).iterator();
    }

    public Iterator<?> iterator() {
        return new OperaPreferencesIterator();
    }

    public boolean equals(Object o) {
        boolean result;
        block2: {
            result = false;
            if (!(o instanceof OperaPreferences)) break block2;
            OperaPreferences rhs = (OperaPreferences)o;
            ListIterator<PreferenceSection> i = this.sections.listIterator();
            ListIterator<PreferenceSection> j = rhs.sections.listIterator();
            while (i.hasNext() && j.hasNext()) {
                PreferenceSection s2;
                PreferenceSection s1 = (PreferenceSection)i.next();
                if (s1.equals(s2 = (PreferenceSection)j.next())) continue;
                break block2;
            }
            if (!i.hasNext() && !j.hasNext()) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.sections.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        ListIterator<PreferenceSection> i = this.sections.listIterator();
        while (i.hasNext()) {
            PreferenceSection ps = (PreferenceSection)i.next();
            buffer.append(ps);
        }
        return buffer.toString();
    }

    private int indexOf(String section) {
        int count = 0;
        int result = -1;
        ListIterator<PreferenceSection> i = this.sections.listIterator();
        while (i.hasNext()) {
            PreferenceSection ps = (PreferenceSection)i.next();
            if (ps != null && ps.getName().equalsIgnoreCase(section)) {
                result = count;
                break;
            }
            ++count;
        }
        return result;
    }

    private class OperaPreferencesIterator
    implements Iterator<Object> {
        private Iterator<?> i;

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Object next() {
            return ((PreferenceSection)this.i.next()).getName();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        public OperaPreferencesIterator() {
            this.i = OperaPreferences.this.sections.listIterator();
        }
    }

    private class PreferenceSection {
        private String name;
        private HashMap<String, PreferenceEntry> entries;
        private volatile int modified;
        private PreferenceEntry start;
        private PreferenceEntry end;

        public String getName() {
            return this.name;
        }

        public boolean contains(String key) {
            return this.entries.containsKey(key);
        }

        public String put(String key, String value) {
            PreferenceEntry entry = this.entries.get(key);
            String result = null;
            if (entry == null) {
                entry = new PreferenceEntry(key, value);
                if (this.end == null) {
                    this.start = entry;
                    this.end = entry;
                } else {
                    this.end.add(entry);
                    this.end = entry;
                }
                this.entries.put(entry.getKey(), entry);
                ++this.modified;
            } else {
                result = entry.getValue();
                entry.setValue(value);
            }
            return result;
        }

        public PreferenceEntry get(String key) {
            return this.entries.get(key);
        }

        public String remove(String key) {
            PreferenceEntry entry = this.entries.get(key);
            String result = null;
            if (entry != null) {
                result = entry.getValue();
                this.removeEntry(entry);
            }
            return result;
        }

        public Iterator<?> iterator() {
            return new PreferenceEntryIterator(this.start);
        }

        public boolean equals(Object o) {
            boolean result;
            block3: {
                result = false;
                if (!(o instanceof PreferenceSection)) break block3;
                PreferenceSection rhs = (PreferenceSection)o;
                if (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) {
                    Iterator<?> i = this.iterator();
                    Iterator<?> j = rhs.iterator();
                    while (i.hasNext() && j.hasNext()) {
                        PreferenceEntry e2;
                        PreferenceEntry e1 = (PreferenceEntry)i.next();
                        if (e1.equals(e2 = (PreferenceEntry)j.next())) continue;
                        break block3;
                    }
                    if (!i.hasNext() && !j.hasNext()) {
                        result = true;
                    }
                }
            }
            return result;
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.entries.size() * 80);
            if (this.name != null && this.name.length() > 0) {
                buffer.append('[').append(this.name).append(']').append(System.getProperty("line.separator"));
            }
            Iterator<?> i = this.iterator();
            while (i.hasNext()) {
                PreferenceEntry entry = (PreferenceEntry)i.next();
                buffer.append(entry).append(System.getProperty("line.separator"));
            }
            buffer.append(System.getProperty("line.separator"));
            return buffer.toString();
        }

        public PreferenceSection(String name) {
            this.name = name;
            this.entries = new HashMap();
            this.modified = 0;
            this.start = null;
            this.end = null;
        }

        private void removeEntry(PreferenceEntry entry) {
            if (entry == this.start) {
                this.start = entry.getNext();
            }
            if (entry == this.end) {
                this.end = entry.getPrevious();
            }
            entry.remove();
            this.entries.remove(entry.getKey());
            ++this.modified;
        }

        private class PreferenceEntryIterator
        implements Iterator<Object> {
            private PreferenceEntry next;
            private PreferenceEntry current;
            private int expectedModified;

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Object next() {
                if (PreferenceSection.this.modified != this.expectedModified) {
                    throw new ConcurrentModificationException();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = this.next.getNext();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                if (PreferenceSection.this.modified != this.expectedModified) {
                    throw new ConcurrentModificationException();
                }
                PreferenceSection.this.removeEntry(this.current);
                this.current = null;
                this.expectedModified = PreferenceSection.this.modified;
            }

            public PreferenceEntryIterator(PreferenceEntry start) {
                this.next = start;
                this.current = null;
                this.expectedModified = PreferenceSection.this.modified;
            }
        }

        private class PreferenceEntry {
            private final String key;
            private String value;
            private PreferenceEntry previous;
            private PreferenceEntry next;

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public void add(PreferenceEntry entry) {
                if (this.next != null) {
                    this.next.add(entry);
                } else {
                    this.next = entry;
                    entry.previous = this;
                }
            }

            public void remove() {
                if (this.previous != null) {
                    this.previous.next = this.next;
                }
                if (this.next != null) {
                    this.next.previous = this.previous;
                }
                this.previous = null;
                this.next = null;
            }

            public PreferenceEntry getPrevious() {
                return this.previous;
            }

            public PreferenceEntry getNext() {
                return this.next;
            }

            public boolean equals(Object o) {
                boolean result = false;
                if (o instanceof PreferenceEntry) {
                    String v2;
                    String v1;
                    String k2;
                    PreferenceEntry rhs = (PreferenceEntry)o;
                    String k1 = this.getKey();
                    if ((k1 == (k2 = rhs.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = rhs.getValue()) || v1 != null && v1.equals(v2))) {
                        result = true;
                    }
                }
                return result;
            }

            public int hashCode() {
                return this.key == null ? 0 : this.key.hashCode();
            }

            public String toString() {
                StringBuilder buffer = new StringBuilder((this.key == null ? 0 : this.key.length()) + (this.value == null ? 0 : this.value.length()) + 1);
                if (this.key != null && this.value != null) {
                    buffer.append(this.key).append('=').append(this.value);
                } else if (this.key != null) {
                    buffer.append(this.key);
                } else if (this.value != null) {
                    buffer.append(this.value);
                }
                return buffer.toString();
            }

            public PreferenceEntry(String key, String value) {
                this.key = key;
                this.value = value;
                this.previous = null;
                this.next = null;
            }
        }
    }
}

