/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.IconEncoder;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class IconUtil {
    public static String getIconPath(LaunchDesc ld, boolean isDesktop) {
        return IconUtil.getIconPath(ld);
    }

    public static String getIconPath(LaunchDesc ld) {
        int value;
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        int[] defaultSizes = Platform.get().getIconSizes();
        Integer desktopSize = Platform.get().getSystemShortcutIconSize(true);
        Integer menuSize = Platform.get().getSystemShortcutIconSize(false);
        for (int i = 0; i < defaultSizes.length; ++i) {
            Integer size = defaultSizes[i];
            if (sizes.contains(size)) continue;
            sizes.add(size);
        }
        if (!sizes.contains(desktopSize)) {
            sizes.add(desktopSize);
        }
        if (!sizes.contains(menuSize)) {
            sizes.add(menuSize);
        }
        int minSize = value = ((Integer)sizes.get(0)).intValue();
        int maxSize = value;
        for (Integer size : sizes) {
            value = size;
            if (value > maxSize) {
                maxSize = value;
            }
            if (value >= minSize) continue;
            minSize = value;
        }
        Iterator it = sizes.iterator();
        IconDesc[] iconIDs = new IconDesc[sizes.size()];
        int[] iconSizes = new int[sizes.size()];
        int iconCount = 0;
        while (it.hasNext()) {
            int h;
            IconDesc id;
            int sz = (Integer)it.next();
            if (sz < minSize) {
                sz = minSize;
            }
            if (sz > maxSize) {
                sz = maxSize;
            }
            if ((id = ld.getInformation().getIconLocation(sz, 5)) == null) {
                id = ld.getInformation().getIconLocation(sz, 0);
            }
            if (id == null) continue;
            boolean found = false;
            for (int i = 0; i < iconCount && !found; ++i) {
                if (!id.equals(iconIDs[i])) continue;
                found = true;
            }
            if (found) continue;
            iconIDs[iconCount] = id;
            int w = id.getWidth();
            iconSizes[iconCount] = w == (h = id.getHeight()) && w >= minSize && w <= maxSize ? w : sz;
            ++iconCount;
        }
        Object finalIcoFilename = null;
        File[] cachedFiles = new File[sizes.size()];
        for (int i = 0; i < iconCount; ++i) {
            Object filename = null;
            File file = null;
            try {
                File cachedFile;
                Resource r = ResourceProvider.get().getResource(iconIDs[i].getLocation(), iconIDs[i].getVersion());
                File file2 = cachedFile = r != null ? r.getDataFile() : null;
                if (cachedFile == null) continue;
                if (Platform.get().isPlatformIconType(iconIDs[i].getLocation().toString())) {
                    filename = cachedFile.toString();
                    file = cachedFile;
                } else {
                    String ext = Platform.get().getPlatformIconType();
                    filename = cachedFile.getPath() + "." + ext;
                    file = new File((String)filename);
                }
                if (file.exists()) {
                    finalIcoFilename = filename;
                    return finalIcoFilename;
                }
                if (finalIcoFilename == null) {
                    finalIcoFilename = filename;
                }
                cachedFiles[i] = cachedFile;
                continue;
            }
            catch (IOException ioe) {
                Trace.ignored((Throwable)ioe);
            }
        }
        if (finalIcoFilename != null && iconCount > 0) {
            IconEncoder iconEncoder = Platform.get().getIconEncoder();
            iconEncoder.convert(cachedFiles, iconSizes, iconCount, finalIcoFilename);
        }
        if (finalIcoFilename != null && new File((String)finalIcoFilename).exists()) {
            return finalIcoFilename;
        }
        return null;
    }

    public static String getIconPath(URL loc, String version) {
        Object filename = null;
        File cachedFile = null;
        try {
            Resource r = ResourceProvider.get().getResource(loc, version);
            if (r != null) {
                cachedFile = r.getDataFile();
            }
            if (cachedFile != null) {
                File file;
                if (Platform.get().isPlatformIconType(loc.toString())) {
                    filename = cachedFile.toString();
                    file = cachedFile;
                } else {
                    String ext = Platform.get().getPlatformIconType();
                    filename = cachedFile.getPath() + "." + ext;
                    file = new File((String)filename);
                }
                if (file.exists()) {
                    return filename;
                }
            }
        }
        catch (IOException ioe) {
            Trace.ignored((Throwable)ioe);
        }
        if (filename != null) {
            File[] cachedFiles = new File[]{cachedFile};
            int[] iconSizes = new int[]{32};
            int iconCount = 1;
            IconEncoder iconEncoder = Platform.get().getIconEncoder();
            iconEncoder.convert(cachedFiles, iconSizes, iconCount, (String)filename);
        }
        if (filename != null && new File((String)filename).exists()) {
            return filename;
        }
        return null;
    }
}

