/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

public class SyncAccess {
    public static final int READ_OP = 2;
    public static final int WRITE_OP = 4;
    public static final int SHARED_READ_MODE = 8;
    private int lockedOP = 0;
    private Object syncObj = new Object();
    private int mode;

    public SyncAccess(int mode) {
        this.mode = mode;
    }

    public Lock lock(int op) {
        int wait_mask = 0;
        wait_mask = op == 2 && (this.mode & 8) != 0 ? 4 : 6;
        return new Lock(wait_mask, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(int wait_mask, int op) {
        Object object = this.syncObj;
        synchronized (object) {
            while ((this.lockedOP & wait_mask) != 0) {
                try {
                    this.syncObj.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lockedOP |= op;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(int op) {
        Object object = this.syncObj;
        synchronized (object) {
            this.lockedOP &= ~op;
            this.syncObj.notifyAll();
        }
    }

    public class Lock {
        private int op;

        private Lock(int wait_mask, int op) {
            this.op = op;
            SyncAccess.this.acquireLock(wait_mask, op);
        }

        public void release() {
            SyncAccess.this.releaseLock(this.op);
        }
    }
}

