/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeploySysAction;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class DeploySysRun {
    private static volatile DeploySysRun delegate;

    public static void setOverride(DeploySysRun delegate) {
        DeploySysRun.delegate = delegate;
    }

    public static Object execute(DeploySysAction action) throws Exception {
        DeploySysRun override = delegate;
        Object ret = override != null ? override.delegate(action) : action.execute();
        return ret;
    }

    public static Object execute(DeploySysAction action, Object defaultValue) {
        try {
            return DeploySysRun.execute(action);
        }
        catch (Exception e) {
            Trace.ignoredException(e);
            return defaultValue;
        }
    }

    public static Object executePrivileged(final DeploySysAction action, final Object defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return DeploySysRun.execute(action);
                }
                catch (Exception e) {
                    Trace.ignoredException(e);
                    return defaultValue;
                }
            }
        });
    }

    public static Object executePrivileged(final DeploySysAction action, final Object defaultValue, AccessControlContext acc) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return DeploySysRun.execute(action);
                }
                catch (Exception e) {
                    Trace.ignoredException(e);
                    return defaultValue;
                }
            }
        }, acc);
    }

    protected abstract Object delegate(DeploySysAction var1) throws Exception;
}

