/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.UIToolkit;
import com.sun.deploy.uitoolkit.WindowFactory;
import com.sun.deploy.uitoolkit.impl.awt.UIToolkitImpl;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.FXLoader;

public class ToolkitStore {
    public static final String JNLP_TK = "jnlp.tk";
    public static final String JNLP_FX = "jnlp.fx";
    public static final String JNLP_TK_AWT = "awt";
    public static final String JNLP_TK_FX = "jfx";
    private static volatile UIToolkit toolkitImpl = null;
    private static final DefaultToolkitFactory defaultToolkitFactory = new DefaultToolkitFactory();
    private static ToolkitFactory toolkitFactory = defaultToolkitFactory;
    private static ToolkitType toolkitType = ToolkitType.AWT_TOOLKIT;
    private static boolean forceToolkitMatchForTests = false;

    private static boolean isInitialized() {
        return null != toolkitImpl;
    }

    private static void ensureJfxAvailability() throws ClassNotFoundException {
        FXLoader.loadFX();
    }

    private static void ensureAWTAvailability() throws Exception {
        try {
            Class.forName("sun.awt.SunToolkit", false, ToolkitStore.class.getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new Exception("AWT is not available !!");
        }
    }

    private static synchronized UIToolkit init() throws Exception {
        String tk = System.getProperty(JNLP_TK);
        if (tk != null) {
            if ((tk = tk.trim()).equalsIgnoreCase(JNLP_TK_FX)) {
                ToolkitStore.setToolkitType(ToolkitType.FX_TOOLKIT);
                try {
                    ToolkitStore.ensureJfxAvailability();
                    ToolkitStore.setToolkitType(ToolkitType.FX_TOOLKIT);
                }
                catch (ClassNotFoundException e) {
                    Trace.ignored(e);
                    ToolkitStore.setToolkitType(ToolkitType.AWT_TOOLKIT);
                }
            } else {
                ToolkitStore.setToolkitType(ToolkitType.AWT_TOOLKIT);
            }
        } else {
            String fx_version = System.getProperty(JNLP_FX);
            if (fx_version != null) {
                try {
                    ToolkitStore.ensureJfxAvailability();
                    ToolkitStore.setToolkitType(ToolkitType.FX_TOOLKIT);
                }
                catch (ClassNotFoundException e) {
                    Trace.ignored(e);
                    ToolkitStore.setToolkitType(ToolkitType.AWT_TOOLKIT);
                }
            }
        }
        if (toolkitType == ToolkitType.AWT_TOOLKIT) {
            ToolkitStore.ensureAWTAvailability();
        }
        toolkitFactory.setToolkitType(toolkitType);
        toolkitImpl = toolkitFactory.create();
        if (toolkitImpl != null) {
            toolkitType = toolkitFactory.getToolkitType();
            toolkitImpl.init();
        }
        return toolkitImpl;
    }

    public static void setToolkitFactory(ToolkitFactory f) {
        if (!toolkitFactory.equals(f)) {
            boolean recreate = false;
            if (ToolkitStore.isInitialized()) {
                Trace.println("Attempt to set toolkit factory after already initialized.", TraceLevel.UI);
                try {
                    ToolkitStore.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                recreate = true;
            }
            toolkitFactory = f == null ? defaultToolkitFactory : f;
            toolkitFactory.setToolkitType(toolkitType);
            if (recreate) {
                ToolkitStore.get();
            }
        }
    }

    public static void setToolkitType(ToolkitType type) {
        if (toolkitType == type) {
            return;
        }
        if (ToolkitStore.isInitialized()) {
            Trace.println("Warning: ToolkitStore.setToolkitType() called after initialized, may not be effective", TraceLevel.UI);
        }
        toolkitFactory.setToolkitType(type);
        toolkitType = toolkitFactory.getToolkitType();
    }

    public static boolean isAWTToolkitRunning() {
        return toolkitType == ToolkitType.AWT_TOOLKIT;
    }

    public static synchronized void dispose() throws Exception {
        forceToolkitMatchForTests = false;
        if (!ToolkitStore.isInitialized()) {
            return;
        }
        toolkitImpl.dispose();
        toolkitImpl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIToolkit get() {
        if (ToolkitStore.isInitialized()) return toolkitImpl;
        Class<ToolkitStore> clazz = ToolkitStore.class;
        synchronized (ToolkitStore.class) {
            if (ToolkitStore.isInitialized()) return toolkitImpl;
            try {
                ToolkitStore.init();
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            return toolkitImpl;
        }
    }

    public static UIFactory getUI() {
        return ToolkitStore.get().getUIFactory();
    }

    public static WindowFactory getWindowFactory() {
        return ToolkitStore.get().getWindowFactory();
    }

    public static boolean isToolkitType(ToolkitType type) {
        return toolkitType == type;
    }

    public static synchronized boolean setPreferredToolkit(ToolkitType type) {
        if (forceToolkitMatchForTests) {
            return true;
        }
        if (!ToolkitStore.isInitialized()) {
            ToolkitStore.setToolkitType(type);
            ToolkitStore.get();
        }
        return ToolkitStore.isToolkitType(type);
    }

    private static class DefaultToolkitFactory
    extends ToolkitFactory {
        private UIToolkit toolkit = null;

        private DefaultToolkitFactory() {
        }

        @Override
        public void setToolkitType(ToolkitType type) {
            if (type != this.selectedType && this.toolkit != null) {
                Trace.println("WARNING: Changing toolkit type after initialization is not supported!", TraceLevel.UI);
            } else {
                super.setToolkitType(type);
            }
        }

        @Override
        public synchronized UIToolkit create() {
            if (this.toolkit == null) {
                switch (this.selectedType) {
                    case AWT_TOOLKIT: {
                        this.toolkit = new UIToolkitImpl();
                        break;
                    }
                    case FX_TOOLKIT: {
                        Trace.println("Error: cannot create FX toolkit outside of jdk.plugin", TraceLevel.UI);
                    }
                }
            }
            return this.toolkit;
        }
    }

    public static abstract class ToolkitFactory {
        protected ToolkitType selectedType;

        public void setToolkitType(ToolkitType type) {
            this.selectedType = type;
        }

        public ToolkitType getToolkitType() {
            return this.selectedType;
        }

        public abstract UIToolkit create();
    }

    public static enum ToolkitType {
        AWT_TOOLKIT,
        FX_TOOLKIT;

    }
}

