/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlacklistedCerts;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.LazyRootStore;
import com.sun.deploy.security.RevocationCheckHelper;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.SecurityBaseline;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

class X509TrustManagerDelegate {
    private static final String[] SUPPORTED_ALGS = new String[]{"HTTPS"};
    private CertStore sslRootStore;
    private CertStore permanentStore;
    private CertStore sessionStore;
    private CertStore deniedStore;
    private CertStore browserSSLRootStore;
    private CertStore browserUntrustedStore;
    private Collection<X509Certificate> acceptedIssuers = new LinkedList<X509Certificate>();
    private RevocationCheckHelper revocationCheckHelper;
    private boolean alwaysShow;
    private boolean mismatchShow;
    private boolean browserSSLRootStoreLoaded = false;
    private boolean browserUntrustedStoreLoaded = false;
    private volatile boolean isInitialized = false;
    private static volatile boolean resetRequested = true;

    X509TrustManagerDelegate() {
    }

    static void reset() {
        resetRequested = true;
    }

    private void initCertStores() {
        this.sslRootStore = SSLRootCertStore.getCertStore();
        this.permanentStore = DeploySSLCertStore.getCertStore();
        this.sessionStore = new SessionCertStore("x509");
        this.deniedStore = new DeniedCertStore();
        this.alwaysShow = Config.getBooleanProperty("deployment.security.https.warning.show");
        this.mismatchShow = Config.getBooleanProperty("deployment.security.jsse.hostmismatch.warning");
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            this.browserSSLRootStore = service.getBrowserSSLRootCertStore();
            this.browserUntrustedStore = service.getBrowserSSLUntrustedCertStore();
        } else {
            this.browserSSLRootStore = null;
            this.browserUntrustedStore = null;
        }
        this.browserSSLRootStoreLoaded = false;
        this.browserUntrustedStoreLoaded = false;
        this.revocationCheckHelper = new RevocationCheckHelper();
    }

    private X509TrustManager createTrustManager(List<X509Certificate> rootCertificates) throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : rootCertificates) {
            if (!(cert instanceof X509Certificate)) continue;
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, null);
        pkixParams.setRevocationEnabled(false);
        CertPathTrustManagerParameters params = new CertPathTrustManagerParameters(pkixParams);
        tmf.init(params);
        TrustManager[] tmArray = tmf.getTrustManagers();
        return (X509TrustManager)tmArray[0];
    }

    private void reloadCertStores() throws Exception {
        if (resetRequested || !this.isInitialized) {
            this.initCertStores();
            resetRequested = false;
            this.isInitialized = true;
        }
        this.acceptedIssuers.clear();
        if (this.sslRootStore != null) {
            this.sslRootStore.load();
            this.acceptedIssuers.addAll(this.sslRootStore.getCertificates());
        }
        if (this.permanentStore != null) {
            this.permanentStore.load();
        }
        if (this.sessionStore != null) {
            this.sessionStore.load();
        }
        if (this.deniedStore != null) {
            this.deniedStore.load();
        }
        if (this.browserSSLRootStore != null && !this.browserSSLRootStoreLoaded) {
            this.browserSSLRootStore.load();
            this.browserSSLRootStoreLoaded = true;
            this.acceptedIssuers.addAll(this.browserSSLRootStore.getCertificates());
        }
        if (this.browserUntrustedStore != null && !this.browserUntrustedStoreLoaded) {
            this.browserUntrustedStore.load();
            this.browserUntrustedStoreLoaded = true;
        }
    }

    public final synchronized void checkTrusted(X509Certificate[] certChain, String authType, String hostname, int port, String algorithm, BasicTrustManagerDelegate basicTrustManagerDelegate, boolean serverCheck) throws CertificateException {
        if (algorithm != null && !this.isSupportedAlgorithm(algorithm)) {
            throw new CertificateException("Not supported algorithm:" + algorithm);
        }
        boolean rootCANotValid = false;
        int certValidity = 0;
        int result = -1;
        try {
            Certificate[] chainForRevocationCheck;
            String location;
            List<X509Certificate> matchedCAList;
            this.reloadCertStores();
            Certificate[] chain = X509TrustManagerDelegate.ensureChainOrdering(certChain);
            if (this.deniedStore.contains(chain[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            this.untrustedCertsCheck(this.browserUntrustedStore, (X509Certificate[])chain);
            if (this.sessionStore.contains(chain[0])) {
                return;
            }
            if (this.permanentStore.contains(chain[0])) {
                return;
            }
            LazyRootStore lazyRootStore = new LazyRootStore(this.browserSSLRootStore, this.sslRootStore);
            LazyRootStore.TrustedRootResult trustRoots = lazyRootStore.getTrustAnchors(chain[chain.length - 1]);
            List<X509Certificate> list = matchedCAList = trustRoots == null ? null : trustRoots.getMatchedCAList();
            if (matchedCAList == null) {
                rootCANotValid = true;
                matchedCAList = new LinkedList<X509Certificate>();
                matchedCAList.add(chain[chain.length - 1]);
            }
            X509Certificate[] newChain = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                newChain[i] = new X509CertificateWrapper(chain[i], hostname);
            }
            X509TrustManager tm = this.createTrustManager(matchedCAList);
            basicTrustManagerDelegate.checkTrusted(tm, newChain);
            boolean[] expired = new boolean[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                try {
                    expired[i] = true;
                    chain[i].checkValidity();
                    expired[i] = false;
                    continue;
                }
                catch (CertificateExpiredException e1) {
                    certValidity = -1;
                    continue;
                }
                catch (CertificateNotYetValidException e2) {
                    certValidity = 1;
                }
            }
            String string = location = port == -1 ? "https://" + hostname : "https://" + hostname + ":" + port;
            if (trustRoots != null && trustRoots.isAlreadyTrusted()) {
                chainForRevocationCheck = new X509Certificate[chain.length - 1];
                System.arraycopy(chain, 0, chainForRevocationCheck, 0, chain.length - 1);
            } else {
                chainForRevocationCheck = chain;
            }
            boolean isRevStatusUnknown = false;
            if (!rootCANotValid && chainForRevocationCheck.length > 0) {
                isRevStatusUnknown = this.revocationCheckHelper.checkRevocationStatus((X509Certificate[])chainForRevocationCheck, matchedCAList.get(0), location, matchedCAList, lazyRootStore, expired);
            }
            if (!Trace.isAutomationEnabled()) {
                boolean show;
                boolean isNotValid = isRevStatusUnknown || rootCANotValid || certValidity != 0 || this.mismatchShow && hostname != null && !CertUtils.checkWildcardDomainList(hostname, CertUtils.getServername(chain[0]));
                boolean bl = show = this.alwaysShow || isNotValid;
                if (isNotValid && SecurityBaseline.isUpdateThread()) {
                    Trace.msgSecurityPrintln("x509trustmgr.check.invalidcert");
                    result = 1;
                } else if (show) {
                    Trace.msgSecurityPrintln("x509trustmgr.check.invalidcert");
                    URL url = null;
                    if (hostname != null) {
                        try {
                            url = new URL("https", hostname, port, "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result = TrustDeciderDialog.showDialog(chain, url, 0, chain.length, rootCANotValid, certValidity, null, new AppInfo(), true, hostname, isRevStatusUnknown);
                } else {
                    result = 0;
                }
            } else {
                Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                result = 0;
            }
            if (result == 0) {
                this.sessionStore.add(chain[0]);
                this.sessionStore.save();
            } else if (result == 2) {
                CertStore userPermanentStore = DeploySSLCertStore.getUserCertStore();
                userPermanentStore.load(true);
                if (userPermanentStore.add(chain[0])) {
                    userPermanentStore.save();
                }
            } else {
                this.deniedStore.add(chain[0]);
                this.deniedStore.save();
            }
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (result != 0 && result != 2) {
            throw new CertificateException(serverCheck ? "Java couldn't trust Server " : "Java couldn't trust Client");
        }
    }

    public synchronized X509Certificate[] getAcceptedIssuers() {
        try {
            this.reloadCertStores();
        }
        catch (Exception e) {
            Trace.printException(e);
        }
        return this.acceptedIssuers.toArray(new X509Certificate[this.acceptedIssuers.size()]);
    }

    private boolean isSupportedAlgorithm(String algorithm) {
        for (int i = 0; i < SUPPORTED_ALGS.length; ++i) {
            if (!algorithm.equalsIgnoreCase(SUPPORTED_ALGS[i])) continue;
            return true;
        }
        return false;
    }

    private void untrustedCertsCheck(CertStore untrustedCertStore, X509Certificate[] chain) throws CertificateException {
        boolean checkFails = false;
        KeyStoreException ex = null;
        for (int i = 0; i < chain.length; ++i) {
            BlacklistedCerts.check(chain[i]);
            if (untrustedCertStore == null) continue;
            try {
                if (!untrustedCertStore.contains(chain[i])) continue;
                checkFails = true;
            }
            catch (KeyStoreException e) {
                checkFails = true;
                ex = e;
            }
            break;
        }
        if (checkFails) {
            String msg = ResourceManager.getString("untrusted.certificate");
            Trace.println(msg, TraceLevel.SECURITY);
            throw new CertificateException(msg, ex);
        }
    }

    private static X509Certificate[] ensureChainOrdering(X509Certificate[] chain) {
        boolean match;
        X509Certificate serverCert = chain[0];
        if (serverCert.getSubjectX500Principal().equals(serverCert.getIssuerX500Principal())) {
            return new X509Certificate[]{serverCert};
        }
        X509Certificate[] issuerChain = new X509Certificate[chain.length - 1];
        System.arraycopy(chain, 1, issuerChain, 0, chain.length - 1);
        ArrayList<X509Certificate> orderedChain = new ArrayList<X509Certificate>();
        orderedChain.add(serverCert);
        X500Principal issuer = serverCert.getIssuerX500Principal();
        int start = 0;
        block0: do {
            match = false;
            for (int i = start; i < issuerChain.length; ++i) {
                if (!issuer.equals(issuerChain[i].getSubjectX500Principal())) continue;
                orderedChain.add(issuerChain[i]);
                if (issuerChain[i].getSubjectX500Principal().equals(issuerChain[i].getIssuerX500Principal())) {
                    start = issuerChain.length;
                } else {
                    issuer = issuerChain[i].getIssuerX500Principal();
                    X509Certificate tmpCert = issuerChain[start];
                    issuerChain[start] = issuerChain[i];
                    issuerChain[i] = tmpCert;
                    ++start;
                }
                match = true;
                continue block0;
            }
        } while (match);
        return orderedChain.toArray(new X509Certificate[orderedChain.size()]);
    }

    static interface BasicTrustManagerDelegate {
        public void checkTrusted(X509TrustManager var1, X509Certificate[] var2) throws CertificateException;
    }
}

