/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.Environment;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.security.ManifestException;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.net.URL;
import java.security.CodeSource;

public class BlockedDialog {
    private static Object blockLock = new Object();
    private static String blockKey = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(AppInfo ai, String reasonString, String reasonKey, Exception exception, CodeSource cs, DeploymentRuleSet drs) {
        String weakJarMessage;
        Object reason = null;
        String masthead = ResourceManager.getString("deployment.blocked.masthead");
        if (reasonString != null) {
            reason = reasonString;
            if (drs == null || !(drs instanceof BlockRule) || !((BlockRule)drs).isFromExceptionList()) {
                masthead = ResourceManager.getString("deployment.blocked.ruleset.masthead");
            }
        } else if (reasonKey != null) {
            reason = ResourceManager.getString(reasonKey);
        } else if (exception instanceof ManifestException) {
            ManifestException me = (ManifestException)exception;
            reason = ResourceManager.getString("deployment.blocked.manifest." + me.getType());
        } else {
            reason = ResourceManager.getString("deployment.blocked.text");
        }
        String mainText = null;
        if (drs != null && drs.getMessage() != null && !drs.isRuleRun() && !drs.isRuleBlock()) {
            mainText = drs.getMessage();
        }
        if ((weakJarMessage = JarVerifier.getWeakAlgorithmMessage()) != null) {
            reason = (String)reason + "\n" + weakJarMessage;
        }
        Trace.println((String)reason, TraceLevel.BASIC);
        BlockedException be = new BlockedException(masthead, mainText, (String)reason, exception, cs, ai);
        Object object = blockLock;
        synchronized (object) {
            String key;
            URL u = ai.getLapURL();
            String string = key = u == null ? null : u.toString();
            if (key == null || !key.equals(blockKey)) {
                if (!Environment.isJavaPlugin()) {
                    be.showDialog();
                } else {
                    Trace.println("postpone showing Blocked Dialog in plugin", TraceLevel.SECURITY);
                }
            }
            blockKey = key;
        }
        throw be;
    }
}

