/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class BlacklistedCerts {
    private static Properties props = null;
    private static String algorithm = null;
    private static final String ALGORITHM_KEY = "Algorithm";
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());
    private static final AccessControlContext ACC_FILE_INSTANCE;

    public static void check(X509Certificate cert) throws CertificateException {
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            if (props == null) {
                BlacklistedCerts.load();
            }
            if (algorithm == null) {
                return;
            }
            String key = CertUtils.getCertificateFingerPrint(algorithm, cert);
            if (props.containsKey(key)) {
                String msg = ResourceManager.getString("blacklisted.certificate");
                Trace.println(msg, TraceLevel.SECURITY);
                throw new CertificateException(msg);
            }
        }
    }

    private static void load() {
        props = new Properties();
        try {
            Boolean isLoaded = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean run() throws Exception {
                    Boolean result = Boolean.FALSE;
                    if (blacklistCertsFile.exists()) {
                        FileInputStream is = null;
                        try {
                            is = new FileInputStream(blacklistCertsFile);
                            props.load(is);
                            result = Boolean.TRUE;
                        }
                        catch (Exception e) {
                            Trace.ignored(e);
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception ee) {
                                    Trace.ignored(ee);
                                }
                            }
                        }
                    }
                    return result;
                }
            }, ACC_FILE_INSTANCE);
            if (Boolean.TRUE.equals(isLoaded)) {
                Trace.println("Loaded blacklisted.certs file: " + blacklistCertsFile, TraceLevel.SECURITY);
            } else {
                Trace.println("Could not load blacklisted.certs file", TraceLevel.SECURITY);
            }
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
        algorithm = props.getProperty(ALGORITHM_KEY);
        if (algorithm == null) {
            Trace.println("blacklisted.certs file contains no Algorithm property.", TraceLevel.SECURITY);
        }
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

