/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.net.BasicHttpResponse;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HttpUtils {
    private static final String CONNECTION_HEADER = "Connection";
    public static final String LOCATION_HEADER = "Location";
    private static final String CONNECTION_KEEP_ALIVE = "Keep-Alive";
    private static final String PROTOCOL_VERSION_1_1 = "HTTP/1.1";
    private static final HashSet<String> isNotCacheable = new HashSet();

    public static HttpURLConnection followRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || !HttpUtils.isRedirect(stat = (http = (HttpURLConnection)c).getResponseCode())) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField(LOCATION_HEADER);
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            if (base != null && !URLUtil.sameURLs(base, target)) {
                DownloadEngine.createRedirectURLEntry(base.toString(), target);
            }
            HttpUtils.cleanupConnection(http);
            if (target == null || !base.getProtocol().equals(target.getProtocol()) || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        if (!(c instanceof HttpURLConnection)) {
            throw new IOException(c.getURL() + " redirected to non-http URL");
        }
        return (HttpURLConnection)c;
    }

    public static URL removeQueryStringFromURL(URL u) {
        if (u != null) {
            Object s = u.toString();
            String original = s;
            int index = ((String)s).lastIndexOf(63);
            if (index != -1) {
                s = ((String)s).substring(0, index);
            }
            while ((index = ((String)s).indexOf(";")) > 0) {
                int end = ((String)s).indexOf("/", index);
                if (end > index) {
                    s = ((String)s).substring(0, index) + ((String)s).substring(end);
                    continue;
                }
                s = ((String)s).substring(0, index);
            }
            if (!((String)s).equals(original)) {
                try {
                    return new URL((String)s);
                }
                catch (MalformedURLException mue) {
                    Trace.ignoredException(mue);
                }
            }
        }
        return u;
    }

    public static URL removeVersionQueriesFromURL(URL url) {
        String s;
        int index;
        if (url != null && (index = (s = url.toString()).lastIndexOf(63)) > -1) {
            StringBuffer noVersions = new StringBuffer(s.substring(0, index + 1));
            String[] queries = s.substring(index + 1).split("&");
            boolean needsAmpesand = false;
            for (String query : queries) {
                String[] pair = query.split("=");
                if (pair.length > 0 && ("version-id".equals(pair[0]) || "current-version-id".equals(pair[0]))) continue;
                if (needsAmpesand) {
                    noVersions.append('&');
                } else {
                    needsAmpesand = true;
                }
                noVersions.append(query);
            }
            try {
                return new URL(noVersions.toString());
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException(mue);
            }
        }
        return url;
    }

    public static boolean sameURLsIgnoreVersionQueries(URL u1, URL u2) {
        u1 = HttpUtils.removeVersionQueriesFromURL(u1);
        u2 = HttpUtils.removeVersionQueriesFromURL(u2);
        return URLUtil.sameURLs(u1, u2);
    }

    public static void cleanupConnection(URLConnection conn) {
        if (conn == null || !(conn instanceof HttpURLConnection)) {
            return;
        }
        try {
            InputStream in;
            int respCode;
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            String respHeader = httpConn.getHeaderField(null);
            String connectionHeader = httpConn.getHeaderField(CONNECTION_HEADER);
            if ((connectionHeader != null && connectionHeader.equalsIgnoreCase(CONNECTION_KEEP_ALIVE) || respHeader != null && respHeader.startsWith(PROTOCOL_VERSION_1_1) && connectionHeader == null) && (respCode = httpConn.getResponseCode()) < 400 && (in = httpConn.getInputStream()) != null) {
                byte[] buffer = new byte[8192];
                while (in.read(buffer) > 0) {
                }
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isRedirect(int stat) {
        return stat >= 300 && stat <= 305 && stat != 304;
    }

    public static URL getFinalRedirectedURL(HttpResponse response) {
        if (response instanceof BasicHttpResponse) {
            return ((BasicHttpResponse)response).getFinalURL();
        }
        return null;
    }

    static boolean hasContentEncoding(Map<String, List<String>> headers, String encoding) {
        encoding = encoding.toLowerCase(Locale.US);
        Set<String> tokens = HttpUtils.getEncodingTokens(headers, false);
        return tokens.contains(encoding);
    }

    public static boolean matchEncoding(String interest, Map<String, List<String>> request, Map<String, List<String>> response) {
        interest = interest == null ? null : interest.toLowerCase(Locale.US);
        Set<String> requestTokens = HttpUtils.getEncodingTokens(request, true);
        Set<String> responseTokens = HttpUtils.getEncodingTokens(response, false);
        if (interest != null && !requestTokens.contains(interest)) {
            return true;
        }
        if (interest != null) {
            return responseTokens.contains(interest);
        }
        for (String token : requestTokens) {
            if (!"*".equals(token) && !responseTokens.contains(token)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getEncodingTokens(Map<String, List<String>> headers, boolean isRequest) {
        List<String> encodings = headers.get(isRequest ? "accept-encoding" : "content-encoding");
        HashSet<String> res = new HashSet<String>();
        if (encodings != null) {
            for (String encoding : encodings) {
                String[] tokens;
                for (String token : tokens = encoding.split(",")) {
                    res.add(token.trim().toLowerCase(Locale.US));
                }
            }
        }
        return res;
    }

    public static boolean hasGzipOrPack200Encoding(URLConnection conn) {
        String accept = conn.getRequestProperty("accept-encoding");
        if (accept != null) {
            accept = accept.toLowerCase(Locale.US);
        }
        return accept != null && (accept.indexOf("gzip") > -1 || accept.indexOf("pack200-gzip") > -1);
    }

    public static boolean refusesIdentityEncodings(Map<String, List<String>> requestHeaders) {
        Set<String> encodings = HttpUtils.getEncodingTokens(requestHeaders, true);
        return encodings.contains("identity;q=0") || encodings.contains("*;q=0") && !encodings.contains("identity");
    }

    public static boolean refusesIdentityEncodings(URLConnection conn) {
        String accepts = conn.getRequestProperty("accept-encoding");
        if (accepts == null) {
            return false;
        }
        return accepts.indexOf("identity;q=0") > -1 || accepts.indexOf("*;q=0") > -1 && accepts.indexOf("identity") == -1;
    }

    public static boolean hasGzipOrPack200Encoding(Map<String, List<String>> headers) {
        return HttpUtils.hasContentEncoding(headers, "gzip") || HttpUtils.hasContentEncoding(headers, "pack200-gzip");
    }

    public static boolean hasGzipEncoding(String encoding) {
        return encoding != null && encoding.toLowerCase(Locale.US).indexOf("gzip") > -1;
    }

    static String removeGzipEncoding(String encoding) {
        if (encoding == null) {
            return null;
        }
        String[] bits = encoding.split(",");
        StringBuffer buf = new StringBuffer();
        boolean needsComma = false;
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i].trim().toLowerCase(Locale.US).equals("gzip")) continue;
            if (needsComma) {
                buf.append(", ");
            } else {
                needsComma = true;
            }
            buf.append(bits[i].trim());
        }
        return buf.length() > 0 ? buf.toString() : null;
    }

    public static long getEffectiveExpiration(long expiration, MessageHeader mh) {
        Map<String, List<String>> headers = mh.getHeaders();
        List<String> ccList = headers.get("cache-control");
        Long maxAgeSeconds = null;
        if (ccList != null) {
            block2: for (String directivesList : ccList) {
                String[] directives;
                if (!(directivesList instanceof String)) continue;
                for (String d : directives = directivesList.split(",")) {
                    String[] pair = d.split("=");
                    if (pair == null || pair.length != 2) continue;
                    String key = pair[0].trim();
                    String value = pair[1].trim();
                    if (!"max-age".equalsIgnoreCase(key)) continue;
                    try {
                        maxAgeSeconds = Long.valueOf(value);
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (maxAgeSeconds != null) {
            return System.currentTimeMillis() + maxAgeSeconds * 1000L;
        }
        return expiration;
    }

    public static long getEffectiveExpiration(HttpResponse response) {
        return HttpUtils.getEffectiveExpiration(response.getExpiration(), response.getHeaders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isResourceCacheable(String url, MessageHeader responseHeader, boolean strict) {
        if (!Cache.isCacheEnabled()) {
            return false;
        }
        Map<String, List<String>> headers = responseHeader.getHeaders();
        if (headers.get("content-range") != null) {
            return false;
        }
        List<String> cacheControl = headers.get("cache-control");
        if (cacheControl != null) {
            for (String ccList : cacheControl) {
                String cc = ccList;
                if (cc.toLowerCase(Locale.US).indexOf("no-store") <= -1) continue;
                return false;
            }
        }
        if (strict && !HttpUtils.hasValueFor(headers, "last-modified") && !HttpUtils.hasValueFor(headers, "expires") && cacheControl == null) {
            HashSet<String> hashSet = isNotCacheable;
            synchronized (hashSet) {
                isNotCacheable.add(url);
                Trace.println(url + " is not cacheable.", TraceLevel.CACHE);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceNotCached(String url) {
        HashSet<String> hashSet = isNotCacheable;
        synchronized (hashSet) {
            return isNotCacheable.contains(url);
        }
    }

    private static boolean hasValueFor(Map<String, List<String>> headers, String key) {
        List<String> values = headers.get(key);
        return values != null && !values.isEmpty();
    }

    private static boolean hasMimeType(Map<String, List<String>> headers, String mimeType) {
        List<String> miTyList = headers.get("content-type");
        return miTyList != null && miTyList.contains(mimeType);
    }

    private static boolean hasRequestType(Map<String, List<String>> headers, String mimeType) {
        List<String> reqTyList = headers.get("deploy-request-content-type");
        return reqTyList != null && reqTyList.contains(mimeType);
    }

    public static boolean isJarFile(String url, Map<String, List<String>> headers) {
        String fname = url;
        if (HttpUtils.hasRequestType(headers, "application/x-java-archive")) {
            return true;
        }
        int coln = fname.indexOf(";");
        if (coln != -1) {
            fname = fname.substring(0, coln);
        }
        if ((coln = fname.indexOf("?")) != -1) {
            fname = fname.substring(0, coln);
        }
        return fname.toLowerCase().endsWith(".jar") || fname.toLowerCase().endsWith(".jarjar") || HttpUtils.hasMimeType(headers, "application/x-java-archive") || HttpUtils.hasMimeType(headers, "application/java-archive") || HttpUtils.hasMimeType(headers, "application/x-java-archive-diff");
    }

    public static boolean isJNLPFile(String url, MessageHeader mh) {
        Map<String, List<String>> headers = mh == null ? Collections.emptyMap() : mh.getHeaders();
        return HttpUtils.isJNLPFile(url, headers);
    }

    public static boolean isJNLPFile(String url, Map<String, List<String>> headers) {
        if (HttpUtils.hasRequestType(headers, "application/x-java-jnlp-file") || HttpUtils.hasMimeType(headers, "application/x-java-jnlp-file")) {
            return true;
        }
        String fname = url;
        int coln = fname.indexOf(";");
        if (coln != -1) {
            fname = fname.substring(0, coln);
        }
        if ((coln = fname.indexOf("?")) != -1) {
            fname = fname.substring(0, coln);
        }
        return fname.toLowerCase(Locale.US).endsWith(".jnlp") || fname.toLowerCase(Locale.US).endsWith(".jarjnlp");
    }
}

