/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.NativePlatform;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SyncAccess;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class JREInfo {
    private static ArrayList<JREInfo> _jres = new ArrayList();
    private static boolean allowCrossArch = true;
    private static JREInfo compatibleHomeJRE;
    private static SyncAccess syncAccess;
    private String _platform;
    private VersionID _platformVersion;
    private String _product;
    private VersionID _productVersion;
    private String _location;
    private String _path;
    private String _javaHomePath;
    private NativePlatform _nativePlatform;
    private String _vm_args;
    private boolean _enabled;
    private boolean _registered;
    private boolean _system;
    private boolean _fake;
    private JfxRuntime _jfxRuntime = null;

    public String getPlatform() {
        return this._platform;
    }

    public VersionID getPlatformVersion() {
        return this._platformVersion;
    }

    public String getProduct() {
        return this._product;
    }

    public NativePlatform getNativePlatform() {
        return this._nativePlatform;
    }

    public String getProductNoDash() {
        int dash = this._product.indexOf("-");
        return dash < 0 ? this._product : this._product.substring(0, dash);
    }

    public VersionID getProductVersion() {
        return this._productVersion;
    }

    public VersionID getFXVersion() {
        return this._jfxRuntime == null ? null : this._jfxRuntime.getProductVersion();
    }

    public JfxRuntime getJfxRuntime() {
        return this._jfxRuntime;
    }

    public String getJfxJarPath() {
        return this._jfxRuntime == null ? null : this._jfxRuntime.getJfxJarPath();
    }

    public String getLocation() {
        return this._location;
    }

    public String getPath() {
        return this._path;
    }

    public String getJavaHomePath() {
        return this._javaHomePath;
    }

    public String getVmArgs() {
        return this._vm_args;
    }

    public String getDebugJavaPath() {
        return Platform.get().getDebugJavaPath(this._path);
    }

    public String getOSName() {
        return this._nativePlatform.getOSName();
    }

    public String getOSArch() {
        return this._nativePlatform.getOSArch();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isRegistered() {
        return this._registered;
    }

    public boolean isSystemJRE() {
        return this._system;
    }

    public boolean isFakeJRE() {
        return this._fake;
    }

    public boolean isModularJRE() {
        return this.getPlatformVersion().isGreaterThanOrEqual(new VersionID("1.9"));
    }

    public void setPlatform(String value) {
        this._platform = value;
        this._platformVersion = new VersionID(value);
    }

    public void setProduct(String value) {
        this._product = value;
        this._productVersion = new VersionID(value);
    }

    public void setLocation(String value) {
        this._location = value;
    }

    public void setPath(String value) {
        this._path = Config.getJavaCommand(Platform.get().getLongPathName(value));
    }

    public void setVmArgs(String vmArgs) {
        this._vm_args = vmArgs;
    }

    public void setEnabled(boolean value) {
        this._enabled = value;
    }

    public void setRegistered(boolean value) {
        this._registered = value;
    }

    public void setSystemJRE(boolean value) {
        this._system = value;
    }

    public void setFakeJRE(boolean value) {
        this._fake = value;
    }

    public void setOSName(String value) {
        this._nativePlatform = new NativePlatform(value, this.getOSArch());
    }

    public void setOSArch(String value) {
        this._nativePlatform = new NativePlatform(this.getOSName(), value);
    }

    public static JREInfo getCompatibleHomeJRE() {
        return compatibleHomeJRE;
    }

    public static boolean archMatchStringList(String[] arches) {
        if (arches == null || arches.length == 0) {
            return true;
        }
        for (String arch : arches) {
            NativePlatform np = new NativePlatform(null, arch);
            if (!JREInfo.isOsInfoMatch(np)) continue;
            return true;
        }
        return false;
    }

    public File getDeploymentHome() {
        try {
            return new File(this.getPath()).getParentFile().getParentFile();
        }
        catch (Exception e) {
            Trace.ignored(e);
            return null;
        }
    }

    public JREInfo(String platform, String product, String location, String path, String args, String osname, String osarch, boolean enabled, boolean registered) {
        File home;
        File bin;
        File java;
        this.setProduct(product);
        if (null != platform) {
            this.setPlatform(platform);
        } else {
            this.setPlatform(JREInfo.getPlatformByProduct(product));
        }
        this._location = location;
        this._javaHomePath = path;
        this._path = Config.getJavaCommand(Platform.get().getLongPathName(path));
        this._vm_args = args;
        this._enabled = enabled;
        this._registered = registered;
        this._system = false;
        this._fake = false;
        this._nativePlatform = new NativePlatform(osname, osarch);
        if (this._location == null) {
            this._location = Config.getStringProperty("deployment.javaws.installURL");
        }
        if (this._path != null && (java = new File(this._path)) != null && (bin = java.getParentFile()) != null && (home = bin.getParentFile()) != null) {
            this._jfxRuntime = JfxRuntime.runtimeForJRE(home, product);
        }
    }

    public JREInfo(int index, Properties p, boolean system) {
        this(p.getProperty("deployment.javaws.jre." + index + ".platform"), p.getProperty("deployment.javaws.jre." + index + ".product"), p.getProperty("deployment.javaws.jre." + index + ".location"), p.getProperty("deployment.javaws.jre." + index + ".path"), p.getProperty("deployment.javaws.jre." + index + ".args"), p.getProperty("deployment.javaws.jre." + index + ".osname"), p.getProperty("deployment.javaws.jre." + index + ".osarch"), false, false);
        String str = p.getProperty("deployment.javaws.jre." + index + ".enabled");
        if (str != null && Boolean.valueOf(str).booleanValue()) {
            this.setEnabled(true);
        }
        if ((str = p.getProperty("deployment.javaws.jre." + index + ".registered")) != null && Boolean.valueOf(str).booleanValue()) {
            this.setRegistered(true);
        }
        this.setSystemJRE(system);
    }

    public JREInfo(JREInfo toCopy) {
        this(toCopy.getPlatform(), toCopy.getProduct(), toCopy.getLocation(), toCopy.getPath(), toCopy.getVmArgs(), toCopy.getOSName(), toCopy.getOSArch(), toCopy.isEnabled(), toCopy.isRegistered());
        this.setSystemJRE(toCopy.isSystemJRE());
    }

    public static void setEnabled(String ver, boolean enabled, boolean isPlatform) {
        for (int i = 0; i < _jres.size(); ++i) {
            JREInfo jre = _jres.get(i);
            if (ver == null) continue;
            VersionID vid = new VersionID(ver);
            if (isPlatform) {
                if (!vid.equals(jre.getPlatformVersion())) continue;
                jre.setEnabled(enabled);
                continue;
            }
            if (!vid.equals(jre.getProductVersion())) continue;
            jre.setEnabled(enabled);
        }
    }

    public static void setArgs(String ver, String args, boolean isPlatform) {
        for (int i = 0; i < _jres.size(); ++i) {
            JREInfo jre = _jres.get(i);
            if (ver == null) continue;
            VersionID vid = new VersionID(ver);
            if (isPlatform) {
                if (!vid.equals(jre.getPlatformVersion())) continue;
                jre.setVmArgs(args);
                continue;
            }
            if (!vid.equals(jre.getProductVersion())) continue;
            jre.setVmArgs(args);
        }
    }

    public boolean isArchMatch() {
        return this._nativePlatform.match(NativePlatform.getCurrentNativePlatform());
    }

    private static boolean isOsInfoMatch(NativePlatform np) {
        NativePlatform curNp = NativePlatform.getCurrentNativePlatform();
        if (allowCrossArch) {
            return np.compatible(curNp);
        }
        return np.match(curNp);
    }

    public String toString() {
        int index = JREInfo.findJREByPath_int(this, _jres);
        return (String)(index >= 0 ? "JREInfo for index " + index + ":\n" : "JREInfo (not in list):\n") + "    platform is: " + this._platform + "\n    product is: " + this._product + "\n    location is: " + this._location + "\n    path is: " + this._path + "\n    args is: " + this._vm_args + "\n    native platform is: " + this._nativePlatform.toString() + "\n    JavaFX runtime is: " + this._jfxRuntime + "\n    enabled is: " + this._enabled + "\n    registered is: " + this._registered + "\n    system is: " + this._system + "\n";
    }

    public String getJREPath() {
        return Config.getJavaHome(this.getPath());
    }

    public static JREInfo findByJREPath(String javaHome) {
        if (javaHome == null || _jres == null) {
            return null;
        }
        ListIterator<JREInfo> i = _jres.listIterator();
        while (i.hasNext()) {
            JREInfo info = (JREInfo)i.next();
            String home = Config.getJavaHome(info.getPath());
            if (!javaHome.equals(home)) continue;
            return info;
        }
        return null;
    }

    public static String getPlatformByProduct(String product) {
        if (product != null) {
            int majorDot = product.indexOf(".", 0);
            if (majorDot > 0 && majorDot < product.length() - 1) {
                try {
                    String majorString = product.substring(0, majorDot);
                    int majorInt = Integer.parseInt(majorString);
                    if (majorInt >= 9) {
                        return majorString;
                    }
                }
                catch (NumberFormatException majorString) {
                    // empty catch block
                }
                int minorDot = product.indexOf(".", majorDot + 1);
                if (minorDot > majorDot) {
                    return product.substring(0, minorDot);
                }
                minorDot = product.indexOf("*", majorDot + 1);
                if (minorDot > majorDot) {
                    return product.substring(0, minorDot);
                }
            } else {
                int hash = product.indexOf("-", 0);
                if (hash > 0) {
                    return product.substring(0, hash);
                }
            }
        }
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findJREByPath(JREInfo je, ArrayList<JREInfo> jres) {
        int i;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            i = JREInfo.findJREByPath_int(je, jres);
        }
        finally {
            lock.release();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findJREByProductVersion(JREInfo je, ArrayList<JREInfo> jres) {
        int i;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            i = JREInfo.findJREByProductVersion_int(je, jres);
        }
        finally {
            lock.release();
        }
        return i;
    }

    public static void addJRE(JREInfo je) {
        JREInfo.addJRE(je, true);
    }

    public static void addJRE(JREInfo je, boolean replace) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            JREInfo.addJRE_int(je, replace);
        }
        finally {
            lock.release();
        }
    }

    public static void removeJRE(int index) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            _jres.remove(index);
        }
        finally {
            lock.release();
        }
    }

    public static JREInfo getJREInfo(int index) {
        JREInfo jreInfo;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            jreInfo = _jres.get(index);
        }
        finally {
            lock.release();
        }
        return jreInfo;
    }

    public static void setJREInfo(int index, JREInfo je) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            _jres.set(index, je);
        }
        finally {
            lock.release();
        }
    }

    public static void clear() {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            _jres.clear();
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLatest() {
        SyncAccess.Lock lock = syncAccess.lock(4);
        VersionID latest = null;
        String version = null;
        try {
            for (int i = 0; i < _jres.size(); ++i) {
                JREInfo jre = _jres.get(i);
                VersionID vid = jre.getProductVersion();
                if (vid == null || latest != null && !vid.isGreaterThan(latest)) continue;
                latest = vid;
                version = jre.getProduct();
            }
            String string = version;
            return string;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionID getLatestVersion(boolean includeDisabled) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        VersionID latest = null;
        try {
            for (int i = 0; i < _jres.size(); ++i) {
                VersionID vid;
                JREInfo jre = _jres.get(i);
                if (!includeDisabled && !jre.isEnabled() || jre.isFakeJRE() || (vid = jre.getProductVersion()) == null || latest != null && !vid.isGreaterThan(latest)) continue;
                latest = vid;
            }
            VersionID versionID = latest;
            return versionID;
        }
        finally {
            lock.release();
        }
    }

    private boolean isValid() {
        int dashIndex;
        if (this.isFakeJRE()) {
            return true;
        }
        String platform = this.getPlatform();
        if (platform != null && (dashIndex = platform.indexOf("-")) != -1) {
            platform = platform.substring(0, dashIndex);
        }
        try {
            if (JREInfo.isOsInfoMatch(this._nativePlatform) && this.getProduct() != null && platform != null && platform.compareTo("1.6") >= 0 && platform.compareTo("9") <= 0 && new File(this.getPath()).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static JREInfo[] getValidSorted() {
        return JREInfo.getSorted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JREInfo[] getSorted(boolean includeInvalid) {
        ArrayList<JREInfo> valid = new ArrayList<JREInfo>();
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            for (JREInfo jre : _jres) {
                if (!includeInvalid && !jre.isValid()) continue;
                valid.add(jre);
            }
        }
        finally {
            lock.release();
        }
        Collections.sort(valid, new Comparator<JREInfo>(){

            @Override
            public int compare(JREInfo jre1, JREInfo jre2) {
                int ret = -jre1.getProductVersion().compareTo(jre2.getProductVersion());
                if (ret == 0) {
                    NativePlatform np = NativePlatform.getCurrentNativePlatform();
                    boolean jre1Match = jre1.getNativePlatform().match(np);
                    boolean jre2Match = jre2.getNativePlatform().match(np);
                    if (jre1Match && jre2Match) {
                        return 0;
                    }
                    if (jre1Match) {
                        return -1;
                    }
                    if (jre2Match) {
                        return 1;
                    }
                }
                return ret;
            }
        });
        return valid.toArray(new JREInfo[0]);
    }

    public static JREInfo[] getAll() {
        return JREInfo.getSorted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(Properties sysJreProps, Properties jwsJreProps) {
        allowCrossArch = true;
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            int index;
            String key;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int last = -1;
            _jres.clear();
            Enumeration<Object> en = jwsJreProps.keys();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                if (!key.startsWith("deployment.javaws.jre.") || (index = JREInfo.getJREIndex_int(key)) < 0 || index == last) continue;
                if (!indices.contains(index)) {
                    indices.add(index);
                    JREInfo.addJRE_int(new JREInfo(index, jwsJreProps, false), true);
                }
                last = index;
            }
            en = sysJreProps.keys();
            last = -1;
            indices = new ArrayList();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                if (!key.startsWith("deployment.javaws.jre.") || (index = JREInfo.getJREIndex_int(key)) < 0 || index == last) continue;
                if (!indices.contains(index)) {
                    indices.add(index);
                    JREInfo.addJRE_int(new JREInfo(index, sysJreProps, true), true);
                }
                last = index;
            }
            JREInfo.validateJREs_int();
            JREInfo.validateHomeJRE_int();
        }
        finally {
            lock.release();
        }
        boolean changed = JREInfo.updateJREs();
        allowCrossArch = false;
        compatibleHomeJRE = null;
        JREInfo home = JREInfo.getHomeJRE_int();
        if (home != null && !Environment.isJavaPlugin()) {
            for (JREInfo jre : _jres) {
                if (JREInfo.isOsInfoMatch(jre.getNativePlatform()) || !jre.isEnabled() || !jre.getProductNoDash().equals(home.getProductNoDash())) continue;
                compatibleHomeJRE = jre;
                allowCrossArch = true;
                Trace.println("found compatible alternate home at: " + jre, TraceLevel.BASIC);
                break;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean updateJREs() {
        List<JREInfo> jres = Platform.get().getInstalledJREList();
        boolean wasChanged = false;
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            for (JREInfo jre : jres) {
                String version = jre.getProduct();
                if (version.lastIndexOf(".") < 2 && version.startsWith("1")) continue;
                int idx = JREInfo.findJREByPath_int(jre, _jres);
                if (idx < 0) {
                    JREInfo.addJRE_int(jre, false);
                    wasChanged = true;
                    continue;
                }
                JREInfo found = _jres.get(idx);
                if (jre.getProductNoDash().equals(found.getProductNoDash())) {
                    found.setRegistered(true);
                    continue;
                }
                JREInfo.addJRE_int(jre, true);
                wasChanged = true;
            }
            JREInfo.validateJREs_int();
            JREInfo.validateHomeJRE_int();
        }
        finally {
            lock.release();
        }
        return wasChanged;
    }

    public static void printJREs() {
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            System.out.println("\nJREInfo: " + _jres.size() + " entries");
            for (int i = 0; i < _jres.size(); ++i) {
                System.out.println("JREInfo " + i + ":");
                System.out.println(_jres.get(i).toString());
            }
        }
        finally {
            lock.release();
        }
    }

    public static void traceJREs() {
        if (!Trace.isEnabled(TraceLevel.BASIC)) {
            return;
        }
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            Trace.println("\nJREInfo: " + _jres.size() + " entries", TraceLevel.BASIC);
            for (int i = 0; i < _jres.size(); ++i) {
                Trace.println("JREInfo " + i + ":", TraceLevel.BASIC);
                Trace.println(_jres.get(i).toString(), TraceLevel.BASIC);
            }
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getKnownPlatforms() {
        ArrayList<String> platforms = new ArrayList<String>();
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            for (JREInfo jre : _jres) {
                String platform = jre.getPlatform();
                if (platforms.contains(platform)) continue;
                platforms.add(platform);
            }
        }
        finally {
            lock.release();
        }
        StringBuffer knownPlatforms = new StringBuffer();
        for (String platform : platforms) {
            knownPlatforms.append(platform);
            knownPlatforms.append(" ");
        }
        return knownPlatforms.toString();
    }

    public static String getDefaultJavaPath() {
        String homeS;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            JREInfo home = JREInfo.getHomeJRE_int();
            homeS = home != null ? home.getPath() : _jres.get(0).getPath();
        }
        finally {
            lock.release();
        }
        return homeS;
    }

    public static JREInfo getHomeJRE() {
        JREInfo home;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            home = JREInfo.getHomeJRE_int();
        }
        finally {
            lock.release();
        }
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJREsIn(String pathPrefix) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            Iterator<JREInfo> it = _jres.iterator();
            while (it.hasNext()) {
                JREInfo jre = it.next();
                String path = jre.getPath();
                if (path == null || !path.startsWith(pathPrefix)) continue;
                it.remove();
            }
        }
        finally {
            lock.release();
        }
    }

    public static boolean isValidJREPath(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists() && !f.isDirectory();
        }
        return false;
    }

    private static int findJREByPath_int(JREInfo je, ArrayList<JREInfo> jres) {
        JREInfo ha;
        int index;
        for (index = jres.size() - 1; !(index < 0 || JREInfo.isOsInfoMatch((ha = jres.get(index)).getNativePlatform()) && je.isSystemJRE() == ha.isSystemJRE() && je.getPath() != null && Platform.get().samePaths(je.getPath(), ha.getPath())); --index) {
        }
        return index;
    }

    private static int findJREByProductVersion_int(JREInfo je, ArrayList<JREInfo> jres) {
        int index;
        String jeL = je.getLocation();
        if (jeL == null) {
            return -1;
        }
        for (index = jres.size() - 1; index >= 0; --index) {
            JREInfo ha = jres.get(index);
            String haL = ha.getLocation();
            if (je.isSystemJRE() == ha.isSystemJRE() && haL != null && jeL.equals(haL) && je.getProductVersion().equals(ha.getProductVersion())) break;
        }
        return index;
    }

    private static void addJRE_int(JREInfo je, boolean replace) {
        if (je.getPath() != null) {
            int i = JREInfo.findJREByPath_int(je, _jres);
            if (i >= 0 && !replace) {
                return;
            }
            if (i >= 0) {
                JREInfo iJre = _jres.get(i);
                if ((je.getVmArgs() == null || "".equals(je.getVmArgs())) && null != iJre.getVmArgs()) {
                    je.setVmArgs(iJre.getVmArgs());
                }
                _jres.remove(i);
            }
            _jres.add(je);
        }
    }

    private static void validateHomeJRE_int() {
        JREInfo jreHome = JREInfo.getHomeJRE_int();
        if (jreHome != null) {
            int idx = JREInfo.findJREByPath_int(jreHome, _jres);
            if (idx < 0) {
                JREInfo.addJRE_int(jreHome, true);
            }
            JREInfo sysJreHome = new JREInfo(jreHome);
            sysJreHome.setSystemJRE(true);
            idx = JREInfo.findJREByPath_int(sysJreHome, _jres);
            if (idx < 0) {
                JREInfo.addJRE_int(sysJreHome, true);
            }
            for (int i = 0; i < _jres.size(); ++i) {
                JREInfo iJre = _jres.get(i);
                if (JREInfo.compareWithHomeJre(jreHome, iJre)) continue;
                _jres.remove(i);
            }
        }
    }

    public static boolean compareWithHomeJre(JREInfo jreHome, JREInfo newJre) {
        return newJre.isSystemJRE() || !newJre.getProduct().equals(jreHome.getProduct()) || !newJre.getOSName().equals(jreHome.getOSName()) || !newJre.getOSArch().equals(jreHome.getOSArch()) || Platform.get().samePaths(newJre.getPath(), jreHome.getPath());
    }

    private static void validateJREs_int() {
        for (int i = 0; i < _jres.size(); ++i) {
            JREInfo iJre = _jres.get(i);
            if (!JREInfo.isOsInfoMatch(iJre.getNativePlatform()) || JREInfo.isValidJREPath(iJre.getPath())) continue;
            _jres.remove(i);
        }
    }

    private static int getJREIndex_int(String key) {
        int i1 = "deployment.javaws.jre.".length();
        int i2 = key.indexOf(".", i1);
        if (i2 > i1) {
            String indexString = key.substring(i1, i2);
            try {
                return Integer.parseInt(indexString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static JREInfo getHomeJRE_int() {
        String path;
        String version = Config.getJavaVersion();
        JREInfo jreHome = new JREInfo(null, version, "http://java.sun.com/products/autodl/j2se", path = Platform.get().getLongPathName(Config.getJREHome()), "", Config.getOSName(), Config.getOSArch(), true, false);
        int idx = JREInfo.findJREByPath_int(jreHome, _jres);
        if (idx >= 0) {
            JREInfo jre = _jres.get(idx);
            if (!jreHome.getProduct().equals(jre.getProduct())) {
                jre.setProduct(jreHome.getProduct());
                jre.setPlatform(JREInfo.getPlatformByProduct(jreHome.getProduct()));
                jre._jfxRuntime = jreHome._jfxRuntime;
            }
            jreHome = jre;
        }
        return jreHome;
    }

    static {
        syncAccess = new SyncAccess(8);
        JREInfo.validateHomeJRE_int();
    }
}

