/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.security.JarAsBLOBVerifier;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class SignedAsBlobJarFile
extends JarFile
implements ResourceObject {
    private final URL resourceURL;
    private final String resourceVersion;
    private final CodeSource codeSource;

    public SignedAsBlobJarFile(File file, JarAsBLOBVerifier verifier) throws IOException {
        super(file);
        this.resourceURL = verifier.getJarLocation();
        this.resourceVersion = verifier.getJarVersion();
        this.codeSource = SignedAsBlobJarFile.getCodeSource(verifier);
        if (Cache.DEBUG) {
            Trace.println("SignedAsBlobJarFile.const");
        }
    }

    private SignedAsBlobJarFile(File file, URL location, String version, CodeSource codeSource) throws IOException {
        super(file);
        this.resourceURL = location;
        this.resourceVersion = version;
        this.codeSource = codeSource;
    }

    private static CodeSource getCodeSource(JarAsBLOBVerifier verifier) {
        JarVerifier.CodeSourceCache map = verifier.getCodeSourceCache();
        if (map != null && map.getCodeSources().size() == 1) {
            CodeSource cs = map.getCodeSources().iterator().next();
            return SignedAsBlobJarFile.cloneCodeSource(cs);
        }
        return SignedAsBlobJarFile.getUnverifiedCodeSource(verifier.getJarLocation());
    }

    Enumeration<String> entryNames(CodeSource[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            if (!this.codeSource.equals(cs[i])) continue;
            final Enumeration<JarEntry> jarEntries = super.entries();
            return new Enumeration<String>(){
                private JarEntry next;

                @Override
                public boolean hasMoreElements() {
                    if (this.next == null && jarEntries.hasMoreElements()) {
                        this.next = (JarEntry)jarEntries.nextElement();
                        if (this.next != null) {
                            while (JarUtil.canSkipEntry(this.next) && jarEntries.hasMoreElements()) {
                                this.next = (JarEntry)jarEntries.nextElement();
                                if (this.next != null) continue;
                            }
                        }
                    }
                    return this.next != null;
                }

                @Override
                public String nextElement() {
                    JarEntry cur = this.next;
                    this.next = null;
                    return cur.getName();
                }
            };
        }
        return Collections.emptyEnumeration();
    }

    private static CodeSource getUnverifiedCodeSource(URL jarLocation) {
        return new CodeSource(jarLocation, (Certificate[])null);
    }

    CodeSource[] getCodeSources(URL url) {
        return new CodeSource[]{this.codeSource};
    }

    CodeSource getCodeSource(URL url, String name) {
        if (!JarUtil.isSigningRelated(name) && !name.endsWith("/")) {
            return this.getCodeSources(url)[0];
        }
        return SignedAsBlobJarFile.getUnverifiedCodeSource(url);
    }

    @Override
    public ZipEntry getEntry(String name) {
        JarEntry entry = (JarEntry)super.getEntry(name);
        if (entry == null) {
            return null;
        }
        return new BlobJarEntry(entry);
    }

    @Override
    public void doClose() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            return new SignedAsBlobJarFile(new File(this.getName()), this.resourceURL, this.resourceVersion, SignedAsBlobJarFile.cloneCodeSource(this.codeSource));
        }
        catch (IOException ex) {
            Trace.ignored(ex);
            return null;
        }
    }

    @Override
    public URL getResourceURL() {
        return this.resourceURL;
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public Enumeration<JarEntry> entries() {
        final Enumeration<JarEntry> entryList = super.entries();
        return new Enumeration<JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return entryList.hasMoreElements();
            }

            @Override
            public JarEntry nextElement() {
                try {
                    JarEntry ze = (JarEntry)entryList.nextElement();
                    return new BlobJarEntry(ze);
                }
                catch (InternalError ie) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    private static CodeSource cloneCodeSource(CodeSource cs) {
        return new CodeSource(cs.getLocation(), cs.getCertificates());
    }

    private class BlobJarEntry
    extends JarEntry {
        public BlobJarEntry(JarEntry je) {
            super(je);
        }

        @Override
        public Certificate[] getCertificates() {
            return SignedAsBlobJarFile.this.codeSource.getCertificates();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            return SignedAsBlobJarFile.this.codeSource.getCodeSigners();
        }
    }
}

