/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.config.Platform;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;

public class WinRegistryWrapper {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_ITEM_EXIST = 0;
    public static final int ERROR_ITEM_NOTEXIST = 9;
    public static final int MAX_KEY_LENGTH = 255;
    public static final int MAX_VALUE_NAME_LENGTH = 255;
    private static final int OPENED_KEY_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int KEY_WOW64_32KEY = 512;
    public static final int KEY_WOW64_64KEY = 256;

    private static native int[] RegOpenKeyEx(int var0, String var1, int var2);

    private static native int RegCloseKey(int var0);

    private static native int[] RegCreateKeyEx(int var0, String var1);

    private static native int[] RegCreateNoReflectionKey(int var0, String var1);

    private static native int RegDeleteKey(int var0, String var1);

    private static native int RegFlushKey(int var0);

    private static native String RegQueryValueEx(int var0, String var1);

    private static native int RegSetValueEx(int var0, String var1, String var2);

    private static native int RegDeleteValue(int var0, String var1);

    private static native int[] RegQueryInfoKey(int var0);

    private static native String RegEnumKeyEx(int var0, int var1, int var2);

    private static native String RegEnumValue(int var0, int var1, int var2);

    private static native String FindMimeFromData(String var0, byte[] var1);

    private static native String ExpandEnvironmentStrings(String var0);

    private WinRegistryWrapper() {
    }

    private static int WinRegCreateKeyImpl(int hKey, String subKey, boolean noReflection) {
        int[] createResult = !noReflection ? WinRegistryWrapper.RegCreateKeyEx(hKey, subKey) : WinRegistryWrapper.RegCreateNoReflectionKey(hKey, subKey);
        if (createResult == null) {
            return -1;
        }
        if (createResult[1] == 0) {
            WinRegistryWrapper.RegCloseKey(createResult[0]);
        }
        return createResult[1];
    }

    public static int WinRegCreateKeyEx(int hKey, String subKey) {
        return WinRegistryWrapper.WinRegCreateKeyImpl(hKey, subKey, false);
    }

    public static int WinRegCreateNoReflectionKey(int hKey, String subKey) {
        return WinRegistryWrapper.WinRegCreateKeyImpl(hKey, subKey, true);
    }

    public static int WinRegDeleteKey(int hKey, String subKey) {
        int result = WinRegistryWrapper.RegDeleteKey(hKey, subKey);
        if (result != 0 && WinRegistryWrapper.WinRegSubKeyExist(hKey, subKey)) {
            String[] subSubKeys = WinRegistryWrapper.WinRegGetSubKeys(hKey, subKey, 255);
            for (int keyIndex = 0; keyIndex < subSubKeys.length; ++keyIndex) {
                String subSubKey = subKey + "\\" + subSubKeys[keyIndex];
                if (subSubKey == null) continue;
                WinRegistryWrapper.WinRegDeleteKey(hKey, subSubKey);
            }
            result = WinRegistryWrapper.RegDeleteKey(hKey, subKey);
        }
        return result;
    }

    public static int WinRegFlushKey(int hKey, String subKey) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131078);
        if (openResult == null) {
            return -1;
        }
        if (openResult[1] != 0) {
            return openResult[1];
        }
        int flushResult = WinRegistryWrapper.RegFlushKey(openResult[0]);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return flushResult;
    }

    public static String WinRegQueryValueEx(int hKey, String subKey, String valueName, int samDesired) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, samDesired);
        if (openResult != null && openResult[1] == 0) {
            String ret = WinRegistryWrapper.RegQueryValueEx(openResult[0], valueName);
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return ret;
        }
        return null;
    }

    public static String WinRegQueryValueEx(int hKey, String subKey, String valueName) {
        return WinRegistryWrapper.WinRegQueryValueEx(hKey, subKey, valueName, 131097);
    }

    public static int WinRegSetValueEx(int hKey, String subKey, String valueName, String value) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 2);
        if (openResult == null) {
            return -1;
        }
        if (openResult[1] != 0) {
            return openResult[1];
        }
        int setResult = WinRegistryWrapper.RegSetValueEx(openResult[0], valueName, value);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return setResult;
    }

    public static int WinRegDeleteValue(int hKey, String subKey, String valueName) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131078);
        if (openResult == null) {
            return -1;
        }
        if (openResult[1] != 0) {
            return openResult[1];
        }
        int deleteResult = WinRegistryWrapper.RegDeleteValue(openResult[0], valueName);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return deleteResult;
    }

    public static int[] WinRegQueryInfoKey(int hKey, String subKey) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131097);
        if (openResult != null && openResult[1] == 0) {
            int[] queryResult = WinRegistryWrapper.RegQueryInfoKey(openResult[0]);
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return queryResult;
        }
        return openResult;
    }

    public static String WinRegEnumKeyEx(int hKey, String subKey, int subKeyIndex, int maxKeyLength, int samDesired) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, samDesired);
        if (openResult != null && openResult[1] == 0) {
            String r = WinRegistryWrapper.RegEnumKeyEx(openResult[0], subKeyIndex, maxKeyLength);
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return r;
        }
        return null;
    }

    public static String WinRegEnumKeyEx(int hKey, String subKey, int subKeyIndex, int maxKeyLength) {
        return WinRegistryWrapper.WinRegEnumKeyEx(hKey, subKey, subKeyIndex, maxKeyLength, 131097);
    }

    public static String WinRegEnumValue(int hKey, String subKey, int valueIndex, int maxValueNameLength) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131097);
        if (openResult != null && openResult[1] == 0) {
            String r = WinRegistryWrapper.RegEnumValue(openResult[0], valueIndex, maxValueNameLength);
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return r;
        }
        return null;
    }

    public static String[] WinRegGetSubKeys(int hKey, String subKey, int maxKeyLength) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131097);
        if (openResult != null && openResult[1] == 0) {
            int[] queryResult = WinRegistryWrapper.RegQueryInfoKey(openResult[0]);
            int subKeysNum = queryResult[0];
            if (subKeysNum == 0) {
                WinRegistryWrapper.RegCloseKey(openResult[0]);
                return null;
            }
            String[] keyStrings = new String[subKeysNum];
            for (int subKeyIndex = 0; subKeyIndex < subKeysNum; ++subKeyIndex) {
                keyStrings[subKeyIndex] = WinRegistryWrapper.RegEnumKeyEx(openResult[0], subKeyIndex, maxKeyLength);
            }
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return keyStrings;
        }
        return null;
    }

    public static String[] WinRegGetValues(int hKey, String subKey, int maxValueLength) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131097);
        if (openResult != null && openResult[1] == 0) {
            int[] queryResult = WinRegistryWrapper.RegQueryInfoKey(openResult[0]);
            int valuesNum = queryResult[2];
            if (valuesNum == 0) {
                WinRegistryWrapper.RegCloseKey(openResult[0]);
                return null;
            }
            String[] valueStrings = new String[valuesNum];
            for (int valueIndex = 0; valueIndex < valuesNum; ++valueIndex) {
                valueStrings[valueIndex] = WinRegistryWrapper.RegEnumValue(openResult[0], valueIndex, maxValueLength);
            }
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return valueStrings;
        }
        return null;
    }

    public static boolean WinRegSubKeyExist(int hKey, String subKey) {
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131097);
        if (openResult != null && openResult[1] == 0) {
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return true;
        }
        return false;
    }

    public static int WinRegValueExist(int hKey, String subKey, String valueName) {
        if (subKey.trim().equals("")) {
            return 9;
        }
        int[] openResult = WinRegistryWrapper.RegOpenKeyEx(hKey, subKey, 131097);
        if (openResult != null && openResult[1] == 0) {
            String r = WinRegistryWrapper.RegQueryValueEx(openResult[0], valueName);
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return r != null ? 0 : 9;
        }
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String WinFindMimeFromData(URL url) {
        if (url == null) {
            return null;
        }
        String urlString = url.toString();
        String result = WinRegistryWrapper.FindMimeFromData(urlString, null);
        if (result != null) {
            return result;
        }
        byte[] dataBytes = new byte[256];
        DataInputStream inStream = null;
        try {
            inStream = new DataInputStream(url.openStream());
            inStream.read(dataBytes, 0, 256);
            inStream.close();
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return WinRegistryWrapper.FindMimeFromData(null, dataBytes);
    }

    public static String WinExpandEnvironmentStrings(String envVariable) {
        return WinRegistryWrapper.ExpandEnvironmentStrings(envVariable);
    }

    static {
        Platform.get().loadDeployNativeLib();
    }
}

