/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;

public class Environment {
    public static final int ENV_PLUGIN = 0;
    public static final int ENV_JAVAWS = 1;
    private static int environmentType = 0;
    private static boolean _isWebJava = true;
    private static boolean _isJavawsAppletLifecycle = false;
    private static boolean _isOldPlugin = false;
    private static boolean _isGlobalException = false;
    public static final String JRE_EXPIRED = "JRE_EXPIRED";
    public static final String JRE_NOTEXPIRED = "JRE_NOTEXPIRED";
    public static final String JAVA_AUTOUPDATE = "JAVA_AUTOUPDATE";
    public static final String DEPLOY_DEBUG = "DEPLOY_DEBUG";
    public static final String DEPLOY_VERBOSE = "DEPLOY_VERBOSE";
    public static final String PLUGIN_DEBUG = "JPI_PLUGIN2_DEBUG";
    public static final String PLUGIN_VERBOSE = "JPI_PLUGIN2_VERBOSE";
    public static final String USERPROFILE = "USERPROFILE";
    public static final String USER_JPI_PROFILE = "USER_JPI_PROFILE";
    public static final String NO_HEARTBEAT = "JPI_PLUGIN2_NO_HEARTBEAT";
    public static final String FORCED_CLIENTVM_ARGS = "FORCED_CLIENTVM_ARGS";
    public static final String JPI_VM_OPTIONS = "_JPI_VM_OPTIONS";
    public static final String FORCED_DEPLOY_ROOT = "FORCED_DEPLOY_ROOT";
    public static final String FORCED_JRE_ROOT = "FORCED_JRE_ROOT";
    public static final String FORCED_BOOTCLASSPATH = "FORCED_BOOTCLASSPATH";
    public static final String FORCED_BROWSERLIB = "FORCED_OVERRIDE_BROWSERLIB";
    public static final String PIPE_LOGDIR = "JPI2_PIPE_LOGDIR";
    public static final String FORCE_DRAGGABLE = "JPI_PLUGIN2_FORCE_DRAGGABLE";
    public static final String JPI_INJECT = "JPI_PLUGIN2_INJECT_PLUGIN2MANAGER";
    public static final String MOZILLA_HOME = "MOZILLA_HOME";
    public static final String NO_XEMBED = "JPI_PLUGIN2_NO_XEMBED";
    public static final String XDG_DATA_HOME = "XDG_DATA_HOME";
    public static final String DISABLE_406251_WORKAROUND = "JPI_PLUGIN2_DISABLE_406251_WORKAROUND";
    private static String codebaseOverride = null;
    private static URL codebase = null;
    private static Date timestamp = null;
    private static Date expiration = null;
    private static String userAgent = null;
    private static boolean isSystemCache = false;
    private static boolean isSilentMode = false;
    private static boolean isImportMode = false;
    private static boolean isInstallMode = false;
    private static boolean _getenvSupported = true;
    private static String _javaHome;
    private static File deployment_home;
    private static String deploy_home_path;

    public static boolean isGlobalException() {
        return _isGlobalException;
    }

    public static void setGlobalException(boolean value) {
        _isGlobalException = value;
    }

    public static boolean isJavawsAppletLifecycle() {
        return _isJavawsAppletLifecycle;
    }

    public static void setJavawsAppletLifecycle(boolean value) {
        _isJavawsAppletLifecycle = value;
    }

    public static boolean isWebJava() {
        return _isWebJava;
    }

    public static void setIsWebJava(boolean value) {
        _isWebJava = value;
    }

    public static boolean isOldPlugin() {
        return _isOldPlugin;
    }

    public static void setOldPlugin(boolean value) {
        _isOldPlugin = value;
    }

    public static void setEnvironmentType(int type) {
        environmentType = type;
    }

    public static boolean isJavaWebStart() {
        return environmentType == 1;
    }

    public static boolean isJavaPlugin() {
        return environmentType == 0;
    }

    public static void setImportModeTimestamp(Date d) {
        timestamp = d != null ? new Date(d.getTime()) : null;
    }

    public static Date getImportModeTimestamp() {
        return timestamp != null ? new Date(timestamp.getTime()) : null;
    }

    public static void setImportModeExpiration(Date d) {
        expiration = d != null ? new Date(d.getTime()) : null;
    }

    public static Date getImportModeExpiration() {
        return expiration != null ? new Date(expiration.getTime()) : null;
    }

    public static void setImportModeCodebase(URL u) {
        codebase = u;
    }

    public static void setImportModeCodebaseOverride(String s) {
        if (s != null && !((String)s).endsWith("/")) {
            s = (String)s + "/";
        }
        codebaseOverride = s;
    }

    public static URL getImportModeCodebase() {
        return codebase;
    }

    public static String getImportModeCodebaseOverride() {
        return codebaseOverride;
    }

    public static void setUserAgent(String ua) {
        userAgent = ua;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static boolean isSystemCacheMode() {
        return isSystemCache;
    }

    public static void setSystemCacheMode(boolean s) {
        isSystemCache = s;
    }

    public static boolean isSilentMode() {
        return isSilentMode;
    }

    public static void setSilentMode(boolean s) {
        isSilentMode = s;
    }

    public static boolean isImportMode() {
        return isImportMode;
    }

    public static void setImportMode(boolean s) {
        isImportMode = s;
    }

    public static boolean isInstallMode() {
        return isInstallMode;
    }

    public static void setInstallMode(boolean s) {
        isInstallMode = s;
    }

    public static String getenv(final String variableName) {
        try {
            if (_getenvSupported && variableName != null) {
                return AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getenv(variableName);
                    }
                });
            }
        }
        catch (Error e) {
            _getenvSupported = false;
        }
        return null;
    }

    public static String getForcedJreRoot() {
        return Environment.getenv(FORCED_JRE_ROOT);
    }

    public static String getForcedDeployRoot() {
        String root = Environment.getenv(FORCED_DEPLOY_ROOT);
        try {
            return new File(root).getCanonicalPath();
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public static String getForcedBootClassPath() {
        return Environment.getenv(FORCED_BOOTCLASSPATH);
    }

    public static boolean isForcedJreRoot(String jrepath) {
        return Environment.getForcedJreRoot() != null && jrepath != null && jrepath.startsWith(Environment.getForcedJreRoot());
    }

    public static String getJavaHome() {
        if (_javaHome == null) {
            String ret = Environment.getForcedDeployRoot();
            if (ret != null) {
                _javaHome = ret;
            } else {
                ret = System.getProperty("jnlpx.home");
                if (ret == null) {
                    ret = System.getProperty("java.home");
                }
                _javaHome = ret;
            }
        }
        return _javaHome;
    }

    public static void setJavaHome(String javaHome) {
        _javaHome = javaHome;
    }

    public static String getJavawsCommand() {
        Object path = Environment.getDeploymentHomePath();
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        path = (String)path + "bin" + File.separator + "javaws" + Platform.get().getPlatformExtension();
        return path;
    }

    private static File constructJavawPath(File jreHome) {
        boolean isWindows = Config.getOSName().contains("Windows");
        return new File(jreHome, "bin" + File.separator + (isWindows ? "javaw" : "java") + Platform.get().getPlatformExtension());
    }

    public static String getJavawCommand() {
        File javaexe = Environment.constructJavawPath(new File(Environment.getJavaHome()));
        return javaexe.getPath();
    }

    public static File getDeploymentHome() {
        File tmp_file;
        if (null != deployment_home) {
            return deployment_home;
        }
        String tmp = Environment.getForcedDeployRoot();
        if (tmp != null && ((tmp_file = new File(tmp)).exists() || tmp_file.isDirectory())) {
            Trace.println("Use deploy home from FORCED_DEPLOY_ROOT: " + tmp, TraceLevel.BASIC);
            deployment_home = tmp_file;
            return deployment_home;
        }
        tmp = System.getProperty("sun.boot.class.path");
        if (tmp != null) {
            String[] candidates;
            try {
                candidates = tmp.split(File.pathSeparator);
            }
            catch (NoSuchMethodError nsme) {
                candidates = StringUtils.splitString(tmp, File.pathSeparator);
            }
            for (String candidate : candidates) {
                if (!candidate.endsWith("deploy.jar")) continue;
                deployment_home = new File(candidate).getParentFile().getParentFile();
                Trace.println("Derive deploy home from bootclasspath: " + candidate, TraceLevel.BASIC);
                return deployment_home;
            }
        }
        if ((tmp = System.getProperty("jdk.module.path")) != null) {
            deployment_home = new File(tmp).getParentFile();
            Trace.println("Derive deploy home from jdk.module.path: " + deployment_home, TraceLevel.BASIC);
            return deployment_home;
        }
        try {
            String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Environment.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                }
            });
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            deployment_home = new File(decodedPath).getParentFile().getParentFile();
            if (deployment_home.exists()) {
                return deployment_home;
            }
            deployment_home = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tmp = Environment.getJavaHome();
        Trace.println("Assume Java home: " + tmp, TraceLevel.BASIC);
        deployment_home = new File(tmp);
        return deployment_home;
    }

    public static String getDeploymentHomePath() {
        if (deploy_home_path == null) {
            try {
                deploy_home_path = Environment.getDeploymentHome().getCanonicalPath();
            }
            catch (Exception e) {
                deploy_home_path = Environment.getDeploymentHome().getPath();
            }
        }
        return deploy_home_path;
    }

    static {
        deployment_home = null;
        deploy_home_path = null;
    }
}

