/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.XMLFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.zip.GZIPInputStream;

public class LaunchDescFactory {
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 8192;
    private static URL derivedCodebase = null;
    private static URL docbase = null;

    public static void setDocBase(URL uRL) {
        docbase = uRL;
    }

    public static URL getDocBase() {
        return docbase;
    }

    public static URL getDerivedCodebase() {
        if (docbase != null && derivedCodebase == null) {
            try {
                derivedCodebase = new URL(docbase.toString().substring(0, docbase.toString().lastIndexOf("/") + 1));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
        }
        return derivedCodebase;
    }

    public static LaunchDesc buildDescriptor(byte[] byArray, URL uRL, URL uRL2, URL uRL3) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return XMLFormat.parse(byArray, uRL, uRL2, uRL3);
    }

    public static LaunchDesc buildDescriptor(byte[] byArray, URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(byArray, uRL, uRL2, null);
    }

    public static LaunchDesc buildDescriptor(File file, URL uRL, URL uRL2, URL uRL3) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        URL uRL4 = uRL3 != null ? uRL3 : LaunchDescFactory.getOriginalURL();
        try {
            return LaunchDescFactory.buildDescriptor(SystemUtils.readBytes((InputStream)new FileInputStream(file), (long)file.length()), uRL, uRL2, uRL4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (uRL4 == null) {
                throw fileNotFoundException;
            }
            return LaunchDescFactory.buildDescriptor(uRL4, uRL2);
        }
    }

    private static LaunchDesc buildDescriptor(File file, LocalApplicationProperties localApplicationProperties, URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        String string = localApplicationProperties.getDocumentBase();
        String string2 = localApplicationProperties.getCodebase();
        String string3 = localApplicationProperties.getOriginalURL();
        if (string2 != null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (string != null) {
            try {
                uRL2 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL uRL3 = null;
        if (string3 != null) {
            try {
                uRL3 = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return LaunchDescFactory.buildDescriptor(file, uRL, uRL2, uRL3);
    }

    public static LaunchDesc buildDescriptor(File file) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
        if (localApplicationProperties != null) {
            return LaunchDescFactory.buildDescriptor(file, localApplicationProperties, null, null);
        }
        String string = LaunchDescFactory.getOriginalFilename();
        if (string != null) {
            Object object;
            File file2 = new File(string);
            URL uRL = null;
            try {
                object = file2.getAbsoluteFile().getParent();
                if (((String)object).startsWith(File.separator)) {
                    object = ((String)object).substring(1, ((String)object).length());
                }
                uRL = new URL("file:/" + (String)object + File.separator);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
            if (uRL != null) {
                object = new URL(uRL.toString() + file2.getName());
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, uRL, null, (URL)object);
                derivedCodebase = uRL;
                return launchDesc;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LaunchDesc buildDescriptor(URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        int n = ResourceProvider.get().incrementInternalUse();
        try {
            LaunchDesc launchDesc = LaunchDescFactory._buildDescriptor(uRL, uRL2);
            return launchDesc;
        }
        finally {
            ResourceProvider.get().decrementInternalUse(n);
        }
    }

    private static LaunchDesc _buildDescriptor(URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        File file;
        Resource resource = null;
        IOException iOException = null;
        try {
            file = ResourceProvider.get().getResource(uRL, null).getDataFile();
        }
        catch (IOException iOException2) {
            if (iOException2 instanceof UnknownHostException || iOException2 instanceof FailedDownloadException || iOException2 instanceof ConnectException || iOException2 instanceof SocketException) {
                Trace.ignoredException((Exception)iOException2);
                iOException = iOException2;
                file = ResourceProvider.get().getCachedJNLPFile(uRL, null);
                if (file == null && DeployOfflineManager.isForcedOffline()) {
                    throw iOException2;
                }
            }
            throw iOException2;
        }
        URL uRL3 = URLUtil.asPathURL((URL)URLUtil.getBase((URL)uRL));
        if (file != null && file.exists()) {
            URL uRL4;
            LaunchDesc launchDesc;
            if (Environment.getImportModeCodebaseOverride() != null) {
                uRL3 = new URL(Environment.getImportModeCodebaseOverride());
            }
            if ((launchDesc = LaunchDescFactory.buildDescriptor(file, uRL3, uRL2, (uRL4 = DownloadEngine.getKnownRedirectFinalURL((URL)uRL)) != null ? uRL4 : uRL)) == null) {
                return null;
            }
            if (launchDesc.getLaunchType() == 5) {
                ResourceProvider.get().markRetired(resource, false);
            }
            if (iOException != null && !launchDesc.getInformation().supportsOfflineOperation()) {
                throw iOException;
            }
            derivedCodebase = uRL3;
            return launchDesc;
        }
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = httpRequest.doGetRequest(uRL);
        FilterInputStream filterInputStream = httpResponse.getInputStream();
        int n = httpResponse.getContentLength();
        String string = httpResponse.getContentEncoding();
        if (string != null && string.indexOf("gzip") >= 0) {
            filterInputStream = new GZIPInputStream((InputStream)filterInputStream, 8192);
        }
        URL uRL5 = HttpUtils.getFinalRedirectedURL((HttpResponse)httpResponse);
        LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(SystemUtils.readBytes((InputStream)filterInputStream, (long)n), uRL3, uRL2, uRL5 != null ? uRL5 : uRL);
        ((InputStream)filterInputStream).close();
        return launchDesc;
    }

    private static LaunchDesc buildDescriptorFromCache(URL uRL, URL uRL2) throws BadFieldException, MissingFieldException, JNLParseException {
        try {
            File file = ResourceProvider.get().getCachedJNLPFile(uRL, null);
            if (file != null) {
                URL uRL3 = URLUtil.asPathURL((URL)URLUtil.getBase((URL)uRL));
                return LaunchDescFactory.buildDescriptor(file, uRL3, uRL2, uRL);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static LaunchDesc buildDescriptorFromCache(String string, URL uRL, URL uRL2) throws BadFieldException, MissingFieldException, JNLParseException {
        URL uRL3;
        LaunchDesc launchDesc = null;
        try {
            File file = new File(string);
            if (file.isFile()) {
                launchDesc = LaunchDescFactory.buildDescriptor(file, uRL, uRL2, LaunchDescFactory.getOriginalURL());
            }
            if (launchDesc != null) {
                return launchDesc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            uRL3 = new URL(string);
            launchDesc = string.endsWith(".jarjnlp") ? LaunchDescFactory.buildNoHrefDescriptorFromCache(uRL3, uRL, uRL2) : LaunchDescFactory.buildDescriptorFromCache(uRL3, uRL2);
            if (launchDesc != null) {
                return launchDesc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL != null) {
            try {
                uRL3 = new URL(uRL, string);
                launchDesc = LaunchDescFactory.buildDescriptorFromCache(uRL3, uRL2);
                if (launchDesc != null) {
                    return launchDesc;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (uRL == null && uRL2 != null) {
            try {
                uRL3 = new URL(URLUtil.getBase((URL)uRL2), string);
                launchDesc = LaunchDescFactory.buildDescriptorFromCache(uRL3, uRL2);
                if (launchDesc != null) {
                    return launchDesc;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static LaunchDesc buildNoHrefDescriptorFromCache(URL uRL, URL uRL2, URL uRL3) throws BadFieldException, MissingFieldException, JNLParseException {
        try {
            CacheEntry cacheEntry;
            if (uRL2 == null) {
                uRL2 = URLUtil.asPathURL((URL)URLUtil.getBase((URL)uRL));
            }
            if ((cacheEntry = (CacheEntry)ResourceProvider.get().getCachedResource(uRL, null)) == null) {
                return null;
            }
            LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((CacheEntry)cacheEntry);
            if (localApplicationProperties != null) {
                return LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), localApplicationProperties, uRL2, uRL3);
            }
            return LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), uRL2, uRL3, uRL);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static LaunchDesc buildDescriptor(String string, URL uRL, URL uRL2, boolean bl) throws BadFieldException, MissingFieldException, JNLParseException {
        block32: {
            LaunchDesc launchDesc;
            URL uRL3;
            block31: {
                block30: {
                    uRL3 = null;
                    try {
                        uRL3 = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL3 != null) {
                        try {
                            LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                            if (bl) {
                                Trace.println((String)("   JNLP Ref (absolute): " + uRL3));
                            }
                            return launchDesc2;
                        }
                        catch (BadFieldException badFieldException) {
                            throw badFieldException;
                        }
                        catch (MissingFieldException missingFieldException) {
                            throw missingFieldException;
                        }
                        catch (JNLParseException jNLParseException) {
                            throw jNLParseException;
                        }
                        catch (Exception exception) {
                            if (!bl) break block30;
                            Trace.ignored((Throwable)exception);
                        }
                    }
                }
                if (uRL != null) {
                    try {
                        uRL3 = new URL(uRL, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL3 = null;
                    }
                    if (uRL3 != null) {
                        try {
                            launchDesc = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                            if (bl) {
                                Trace.println((String)(" JNLP Ref (codebase + ref): " + uRL3));
                            }
                            return launchDesc;
                        }
                        catch (BadFieldException badFieldException) {
                            throw badFieldException;
                        }
                        catch (MissingFieldException missingFieldException) {
                            throw missingFieldException;
                        }
                        catch (JNLParseException jNLParseException) {
                            throw jNLParseException;
                        }
                        catch (Exception exception) {
                            if (!bl) break block31;
                            Trace.ignored((Throwable)exception);
                        }
                    }
                }
            }
            if (uRL == null && uRL2 != null) {
                try {
                    uRL3 = new URL(URLUtil.getBase((URL)uRL2), string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL3 = null;
                }
                if (uRL3 != null) {
                    try {
                        launchDesc = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                        if (bl) {
                            Trace.println((String)("   JNLP Ref (documentbase + ref): " + uRL3));
                        }
                        return launchDesc;
                    }
                    catch (BadFieldException badFieldException) {
                        throw badFieldException;
                    }
                    catch (MissingFieldException missingFieldException) {
                        throw missingFieldException;
                    }
                    catch (JNLParseException jNLParseException) {
                        throw jNLParseException;
                    }
                    catch (Exception exception) {
                        if (!bl) break block32;
                        Trace.ignored((Throwable)exception);
                    }
                }
            }
        }
        if (bl) {
            Trace.println((String)"   JNLP Ref (...): NULL !");
        }
        return null;
    }

    public static LaunchDesc buildDescriptor(String string) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        try {
            String string2 = URLUtil.filterProtocols((String)string);
            int n = string2.indexOf(",");
            if (string2.startsWith("data:") && n > 0 && n < string2.length() - 1) {
                Trace.println((String)("Embedded data: URI:" + string), (TraceLevel)TraceLevel.BASIC);
                return LaunchDescFactory.buildDescriptor(Base64Wrapper.decodeFromString((String)string2.substring(n)), null, null);
            }
            URL uRL = new URL(string2);
            try {
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptorFromCache(uRL, null);
                if (launchDesc == null) {
                    CacheEntry cacheEntry = Cache.findMatchingJNLPEntry((String)string);
                    if (cacheEntry != null) {
                        return LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), URLUtil.getBase((URL)uRL), null, uRL);
                    }
                } else {
                    if (launchDesc.getLocation() != null) {
                        return launchDesc;
                    }
                    Resource resource = ResourceProvider.get().getCachedResource(uRL, null);
                    if (resource != null) {
                        ResourceProvider.get().markRetired(resource, true);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DeployOfflineManager.isForcedOffline()) {
                throw new IOException(ResourceManager.getString((String)"launch.error.offlinemissingresource"));
            }
            return LaunchDescFactory.buildDescriptor(uRL, null);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                long l = file.length();
                if (l > 0x100000L) {
                    throw new IOException("File too large");
                }
                if (Environment.isImportMode()) {
                    String string3 = file.getParent();
                    if (Environment.getImportModeCodebaseOverride() == null && string3 != null) {
                        try {
                            URL uRL = new URL("file", null, URLUtil.encodePath((String)string3));
                            Environment.setImportModeCodebaseOverride((String)uRL.toString());
                        }
                        catch (MalformedURLException malformedURLException2) {
                            Trace.ignoredException((Exception)malformedURLException2);
                        }
                    }
                }
                return LaunchDescFactory.buildDescriptor(SystemUtils.readBytes((InputStream)fileInputStream, (long)((int)l)), null, null, file.toURI().toURL());
            }
            catch (FileNotFoundException fileNotFoundException) {
                URL uRL = LaunchDescFactory.getOriginalURL();
                if (uRL == null) {
                    throw fileNotFoundException;
                }
                return LaunchDescFactory.buildDescriptor(uRL, null);
            }
        }
    }

    private static String getOriginalFilename() {
        String string = System.getProperty("jnlpx.origFilenameArg");
        return string != null ? string : null;
    }

    private static URL getOriginalURL() {
        String string = LaunchDescFactory.getOriginalFilename();
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static LaunchDesc buildInternalLaunchDesc(XMLNode xMLNode, String string) {
        return new LaunchDesc("0.1", null, null, null, null, 1, null, null, null, 5, null, null, null, null, null, string == null ? xMLNode.getName() : string, xMLNode, null);
    }

    public static LaunchDesc tryUpdateDescriptor(LaunchDesc launchDesc) {
        URL uRL = launchDesc.getSourceURL();
        try {
            if (uRL != null) {
                return LaunchDescFactory.buildDescriptor(uRL, null);
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
        return launchDesc;
    }
}

