/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CircularByteBuffer {
    private static final boolean DEBUG = false;
    private byte[] buf;
    private int iRead = 0;
    private int iWrite = 0;
    private int lenRead = 0;

    public CircularByteBuffer(int size) {
        this.buf = new byte[size];
    }

    private synchronized void updateAvailableReadLength(boolean writing) {
        this.lenRead = this.iWrite == this.iRead ? (writing ? this.buf.length : 0) : (this.iWrite > this.iRead ? this.iWrite - this.iRead : this.buf.length - this.iRead + this.iWrite);
    }

    private synchronized int availableToWrite() {
        return this.buf.length - this.lenRead;
    }

    private synchronized int availableToRead() {
        return this.lenRead;
    }

    private synchronized void truncateRead(int truncateLen) {
        this.iRead = this.iRead + truncateLen >= this.buf.length ? this.iRead + truncateLen - this.buf.length : (this.iRead += truncateLen);
    }

    public synchronized void write(byte[] source, int len) throws IOException {
        if (len > source.length) {
            len = source.length;
        }
        if (len == 0) {
            return;
        }
        int posWrite = this.iWrite;
        int availableToWrite = this.availableToWrite();
        int sourceOffset = 0;
        if (len >= this.buf.length) {
            sourceOffset = len - this.buf.length;
            len = this.buf.length;
            this.iWrite = this.iRead;
        } else {
            if (len > availableToWrite) {
                int truncateLen = len - availableToWrite;
                this.truncateRead(truncateLen);
            }
            this.iWrite = (this.iWrite + len) % this.buf.length;
        }
        this.updateAvailableReadLength(true);
        if (posWrite + len <= this.buf.length) {
            System.arraycopy(source, sourceOffset, this.buf, posWrite, len);
        } else {
            int straightLen = this.buf.length - posWrite;
            int wrapAroundLen = len - straightLen;
            System.arraycopy(source, sourceOffset, this.buf, posWrite, straightLen);
            System.arraycopy(source, sourceOffset + straightLen, this.buf, 0, wrapAroundLen);
        }
    }

    public synchronized byte[] chunkRead(int chunkSize) {
        int len = this.availableToRead();
        if (len > chunkSize) {
            len = chunkSize;
        }
        byte[] ret = new byte[len];
        if (this.iRead + len <= this.buf.length) {
            System.arraycopy(this.buf, this.iRead, ret, 0, len);
            this.iRead += len;
        } else {
            int straightLen = this.buf.length - this.iRead;
            int wrapAroundLen = this.iRead + len - this.buf.length;
            System.arraycopy(this.buf, this.iRead, ret, 0, straightLen);
            System.arraycopy(this.buf, 0, ret, straightLen, wrapAroundLen);
            this.iRead = wrapAroundLen;
        }
        this.updateAvailableReadLength(false);
        return ret;
    }

    public static class Streamer
    implements Runnable {
        private static final int BUFSIZE = 4096;
        private final InputStream in;
        private final CircularByteBuffer buf;
        private final int readSize;
        private boolean done = false;
        private boolean running = false;
        private boolean pauseForConsumer = false;

        public Streamer(InputStream in) {
            this(in, in instanceof ByteArrayInputStream);
        }

        public Streamer(InputStream in, boolean pauseForConsumer) {
            this(in, 8192, 4096, pauseForConsumer);
        }

        public Streamer(InputStream in, int bufSize, int readChunkSize, boolean pauseForConsumer) {
            this.in = in;
            this.buf = new CircularByteBuffer(bufSize);
            this.readSize = readChunkSize;
            this.pauseForConsumer = pauseForConsumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] bytes = new byte[this.readSize];
            try {
                Streamer streamer = this;
                synchronized (streamer) {
                    this.running = true;
                }
                while (!this.done) {
                    int len;
                    if (this.pauseForConsumer) {
                        this.waitForReader();
                    }
                    if ((len = this.in.read(bytes)) >= 0) {
                        this.buf.write(bytes, len);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Trace.ignored((Throwable)e);
            }
            finally {
                this.done = true;
            }
        }

        private boolean waitForRunning() {
            while (!this.running) {
                try {
                    this.wait(10L);
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readAvailable() {
            Streamer streamer = this;
            synchronized (streamer) {
                if (!this.waitForRunning()) {
                    return new byte[0];
                }
            }
            byte[] ret = this.buf.chunkRead(this.readSize);
            if (this.pauseForConsumer) {
                Streamer streamer2 = this;
                synchronized (streamer2) {
                    this.notifyAll();
                }
            }
            if (this.done && (ret == null || ret.length == 0)) {
                return null;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForReader() {
            while (this.buf.availableToWrite() < this.readSize) {
                Streamer streamer = this;
                synchronized (streamer) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

