/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CPCallbackHandler;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.security.DeployURLClassPath;
import com.sun.deploy.security.DeployURLClassPathCallback;
import com.sun.deploy.security.Resource;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.StringUtils;
import com.sun.deploy.util.URLUtil;
import java.awt.AWTPermission;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyPermission;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class Plugin2ClassLoader
extends DeployURLClassLoader {
    protected static final boolean DEBUG = Config.getDebug();
    protected static final String APPLET_CODE_REWRITE_KEY = "applet-code-rewrite-";
    protected URL base;
    protected CodeSource codesource;
    protected AccessControlContext _acc;
    private AppContext appContext;
    private ThreadGroup threadGroup;
    private boolean codebaseLookup = true;
    private boolean codebaseLookupInitialized = false;
    private boolean securityCheck = false;
    private Plugin2ClassLoader pclParent;
    private List<URL> addedURLs = new ArrayList<URL>();
    private CPCallbackHandler cpHandler;
    private DeployURLClassPathCallback.Element codebaseElement;
    protected ClassLoader parent;
    private static final String UNSIGNED_MESSAGE = " because the class is not signed.";
    private boolean shadowClassLoader = false;
    private Preloader preloader = null;
    private static CodeSource lastBadCertCodeSource = null;
    private TrustedResult sandboxResult = new TrustedResult(false);
    private TrustedResult allPermResult = new TrustedResult(true);
    protected static final ThreadLocal<ClassNotFoundException> cnfeThreadLocal = new ThreadLocal();
    private boolean ssvDialogShown;

    protected Plugin2ClassLoader(URL[] urls, URL base) {
        super(urls);
        this.base = base;
        this.codesource = new CodeSource(base, (Certificate[])null);
        this._acc = AccessController.getContext();
        this.parent = this.getParent();
    }

    protected Plugin2ClassLoader(URL[] urls, URL base, ClassLoader parent) {
        super(urls, parent);
        if (parent instanceof Plugin2ClassLoader) {
            this.pclParent = (Plugin2ClassLoader)((Object)parent);
            this.shadowClassLoader = true;
        }
        this.setDeployURLClassPath(new DeployURLClassPath(urls, this.shadowClassLoader));
        this.parent = parent;
        this.base = base;
        this.codesource = new CodeSource(base, (Certificate[])null);
        this._acc = AccessController.getContext();
    }

    boolean isShadowClassLoader() {
        return this.shadowClassLoader;
    }

    public void close() throws IOException {
        if (Config.isJavaVersionAtLeast17()) {
            super.close();
        }
        this.setDeployURLClassPath(null);
        if (this.pclParent != null) {
            this.pclParent.close();
        }
    }

    public void setPreloader(Preloader p) {
        this.preloader = p;
    }

    public Preloader getPreloader() {
        return this.preloader;
    }

    public abstract boolean wantsAllPerms(CodeSource var1);

    protected abstract Class<?> findClass(String var1, boolean var2) throws ClassNotFoundException;

    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false);
    }

    protected synchronized Class<?> loadClass(String name, boolean resolve, boolean delegated) throws ClassNotFoundException {
        if (name.contains("\u0000")) {
            return null;
        }
        this.checkPackageAccess(name);
        return this.loadClass0(name, resolve, delegated);
    }

    private Class<?> loadClass0(String name, boolean resolve, boolean delegated) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.pclParent != null ? this.pclParent.loadClass(name, false, true) : this.parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.findClass(name, delegated);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permissions csPerms = null;
        String host = this.getBaseURL().getHost();
        if (host != null && host.length() > 0) {
            if (!URLUtil.sameBase((URL)this.getBaseURL(), (URL)codesource.getLocation())) {
                if (DownloadEngine.isKnownRedirectedHost((String)host, (String)codesource.getLocation().getHost())) {
                    csPerms = new Permissions();
                    SandboxSecurity.addConnectPermission((PermissionCollection)csPerms, (URL)codesource.getLocation());
                    Trace.println((String)("Grant connect perm for " + codesource.getLocation() + " : " + csPerms), (TraceLevel)TraceLevel.SECURITY);
                } else {
                    Trace.println((String)("Connect perm was not granted " + codesource.getLocation()), (TraceLevel)TraceLevel.SECURITY);
                }
            } else {
                csPerms = new Permissions();
                SandboxSecurity.addConnectPermission((PermissionCollection)csPerms, (URL)codesource.getLocation());
                Trace.println((String)("Grant connect perm for " + codesource.getLocation() + " : " + csPerms), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        Permissions perms = csPerms == null ? new Permissions() : csPerms;
        URL url = codesource.getLocation();
        Plugin2ClassLoader.addDefaultPermissions(perms);
        TrustedResult result = this.isTrustedByTrustDecider(codesource);
        if (result.allPerms) {
            CeilingPolicy.addTrustedPermissions((PermissionCollection)perms);
            Trace.println((String)"Plugin2ClassLoader.getPermissions CeilingPolicy allPerms", (TraceLevel)TraceLevel.BASIC);
        } else if (this.wantsAllPerms(codesource)) {
            if (result.cause instanceof BlockedException) {
                throw (BlockedException)result.cause;
            }
            throw new BlockedException(ResourceManager.getString((String)"trustdecider.user.deny"), result.cause, codesource, this.getAppInfo(codesource.getLocation()));
        }
        Policy newPolicy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
        PermissionCollection perms2 = newPolicy.getPermissions(codesource);
        if (!((PermissionCollection)perms).implies(new AWTPermission("accessClipboard")) && !perms2.implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_CLIPBOARD_ACCESS_KEY", (Object)Boolean.TRUE);
        }
        ((PermissionCollection)perms).add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)codesource.getLocation())));
        if (Plugin2ClassLoader.isUnsigned(codesource)) {
            Object ob = this.getCallbackHandler();
            if (ob instanceof CPCallbackHandler) {
                CPCallbackHandler cb = (CPCallbackHandler)ob;
                cb.addJS2JavaAllowedCodebase(codesource.getLocation());
            }
        } else if (this.isSignedByTrustedCA(codesource, this.wantsAllPerms(codesource), this.getAppInfo(url))) {
            String jarVersion = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + codesource.getLocation().toString()));
            JarFile jar = ResourceProvider.get().getCachedJarFile(codesource.getLocation(), jarVersion);
            this.loadAllowedCodebases(jar);
        }
        return perms;
    }

    private void loadAllowedCodebases(JarFile jar) {
        try {
            String allowedCodebases;
            Attributes attr;
            Manifest man = jar.getManifest();
            if (man != null && (attr = man.getMainAttributes()) != null && (allowedCodebases = attr.getValue(new Attributes.Name("Caller-Allowable-Codebase"))) != null && allowedCodebases.trim().length() > 0) {
                Object ob = null;
                if (this.pclParent == null) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl instanceof Plugin2ClassLoader) {
                        ob = ((Plugin2ClassLoader)((Object)cl)).getCallbackHandler();
                    }
                } else {
                    ob = this.getCallbackHandler();
                }
                if (ob instanceof CPCallbackHandler) {
                    CPCallbackHandler cb = (CPCallbackHandler)ob;
                    cb.addJS2JavaAllowedCodebasePattern(allowedCodebases);
                    cb.setCallerAllowableCodebaseAttributeExists();
                }
            }
        }
        catch (IOException ioe) {
            Trace.ignored((Throwable)ioe);
        }
    }

    private boolean isSignedByTrustedCA(CodeSource cs, boolean allPermissions, AppInfo ai) {
        ValidationState.TYPE type = allPermissions ? ValidationState.TYPE.ALL_PERMISSIONS : ValidationState.TYPE.SANDBOX_PERMISSIONS;
        ValidationState state = TrustDecider.getJarValidationState((CodeSource)cs, (AppInfo)ai, (ValidationState.TYPE)type, (DeploymentRuleSet)this.getDeploymentRuleSet(cs.getLocation()));
        return state.rootCAValid;
    }

    private static boolean isUnsigned(CodeSource cs) {
        Certificate[] certs = cs.getCertificates();
        return certs == null || certs.length == 0;
    }

    private TrustedResult isTrustedByTrustDecider(CodeSource codesource) {
        if (!this.wantsAllPerms(codesource)) {
            SandboxSecurity.isPermissionGranted((CodeSource)codesource, (AppInfo)this.getAppInfo(codesource.getLocation()), (DeploymentRuleSet)this.getDeploymentRuleSet(codesource.getLocation()), (Preloader)this.getPreloader(), (URL)this.getBaseURL());
            return this.sandboxResult;
        }
        TrustedResult result = this.sandboxResult;
        try {
            long pm = TrustDecider.isAllPermissionGranted((CodeSource)codesource, (AppInfo)this.getAppInfo(codesource.getLocation()), (DeploymentRuleSet)this.getDeploymentRuleSet(codesource.getLocation()), null);
            result = pm != 0L ? this.allPermResult : this.sandboxResult;
        }
        catch (CertificateExpiredException e1) {
            this.securityPrintException(e1, ResourceManager.getString((String)"rsa.cert_expired"), ResourceManager.getString((String)"security.dialog.caption"));
        }
        catch (CertificateNotYetValidException e2) {
            this.securityPrintException(e2, ResourceManager.getString((String)"rsa.cert_notyieldvalid"), ResourceManager.getString((String)"security.dialog.caption"));
        }
        catch (BlockedException be) {
            throw be;
        }
        catch (Exception e3) {
            if (!codesource.equals(lastBadCertCodeSource)) {
                lastBadCertCodeSource = codesource;
                BadCertificateDialog.showDialog((CodeSource)codesource, (AppInfo)this.getAppInfo(codesource.getLocation()), (Exception)e3);
            }
            result = new TrustedResult(result.allPerms, e3);
        }
        return result;
    }

    private void securityPrintException(Exception e, String s1, String s2) {
        if (this.shadowClassLoader) {
            Trace.ignored((Throwable)e);
        } else {
            Trace.securityPrintException((Throwable)e, (String)s1, (String)s2);
        }
    }

    public static void addDefaultPermissions(PermissionCollection perms) {
        perms.add(new PropertyPermission("browser", "read"));
        perms.add(new PropertyPermission("browser.version", "read"));
        perms.add(new PropertyPermission("browser.vendor", "read"));
        perms.add(new PropertyPermission("http.agent", "read"));
        perms.add(new PropertyPermission("javapi.*", "read,write"));
        perms.add(new PropertyPermission("javaws.*", "read,write"));
        perms.add(new PropertyPermission("jnlp.*", "read,write"));
        perms.add(new PropertyPermission("javaplugin.version", "read"));
        perms.add(new PropertyPermission("javaplugin.vm.options", "read"));
        perms.add(new PropertyPermission("mrj.version", "read"));
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(AppContext appContext) {
        if (appContext != null && this.appContext != null) {
            throw new IllegalStateException("May not set the AppContext twice");
        }
        if (this.pclParent != null) {
            this.pclParent.setAppContext(appContext);
        }
        this.appContext = appContext;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup != null && this.threadGroup != null) {
            throw new IllegalStateException("May not set the ThreadGroup twice");
        }
        if (this.pclParent != null) {
            this.pclParent.setThreadGroup(threadGroup);
        }
        this.threadGroup = threadGroup;
    }

    public synchronized boolean getCodebaseLookup() {
        if (this.codebaseLookup && !this.codebaseLookupInitialized) {
            Object obj = this.getCallbackHandler();
            if (obj != null) {
                CPCallbackHandler cb = (CPCallbackHandler)obj;
                DeployURLClassPathCallback child = cb.getChildCallback();
                DeployURLClassPathCallback parent = cb.getParentCallback();
                try {
                    this.codebaseLookup = false;
                    parent.openClassPathElement(this.getBaseURL());
                    DeployURLClassPathCallback.Element codebaseElement = child.openClassPathElement(this.getBaseURL());
                    this.setCodebaseElement(codebaseElement);
                    this.codebaseLookup = !codebaseElement.skip();
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.codebaseLookupInitialized = true;
        }
        return this.codebaseLookup;
    }

    public void setCodebaseLookup(boolean codebaseLookup) {
        if (this.pclParent != null) {
            this.pclParent.setCodebaseLookup(false);
        }
        this.codebaseLookup = codebaseLookup;
    }

    void setSecurityCheck(boolean securityCheck) {
        if (this.pclParent != null) {
            this.pclParent.setSecurityCheck(securityCheck);
        }
        this.securityCheck = securityCheck;
    }

    boolean getSecurityCheck() {
        return this.securityCheck;
    }

    public Class loadCode(String name) throws ClassNotFoundException {
        AppContext ac;
        if (name.contains("\u0000")) {
            return null;
        }
        name = StringUtils.replaceSeparators((String)name);
        String cookie = null;
        int index = name.indexOf(";");
        if (index != -1) {
            cookie = name.substring(index, name.length());
            name = name.substring(0, index);
        }
        String fullName = name;
        if (name.endsWith(".class") || name.endsWith(".java")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (cookie != null && (ac = this.getAppContext()) != null) {
            ac.put((Object)(APPLET_CODE_REWRITE_KEY + name), (Object)cookie);
        }
        ClassNotFoundException exc = null;
        try {
            return this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (e.getMessage().contains(UNSIGNED_MESSAGE)) {
                exc = e;
            }
            try {
                return this.loadClass(fullName);
            }
            catch (ClassNotFoundException e2) {
                if (exc != null) {
                    throw exc;
                }
                throw e2;
            }
        }
    }

    boolean isClassLoadedByPluginClassLoader(Class<?> cls) {
        ClassLoader clUsed = cls.getClassLoader();
        if (this.isShadowClassLoader()) {
            return clUsed == this || clUsed == this.pclParent;
        }
        return clUsed == this;
    }

    public void checkUntrustedAccess(URL documentBase, DeploymentRuleSet drs) throws SecurityException {
        if (this.cpHandler != null) {
            this.cpHandler.checkUntrustedAccess(documentBase, drs);
        }
    }

    private void setCallbackHandler(CPCallbackHandler cb) {
        this.cpHandler = cb;
    }

    Object getCallbackHandler() {
        return this.cpHandler;
    }

    private void setCodebaseElement(DeployURLClassPathCallback.Element e) {
        this.codebaseElement = e;
    }

    private Object getCodebaseElement() {
        return this.codebaseElement;
    }

    static boolean setDeployURLClassPathCallbacks(Plugin2ClassLoader parent, Plugin2ClassLoader child) {
        try {
            if (!ResourceProvider.get().hasEnhancedJarAccess()) {
                Trace.println((String)"setDeployURLClassPathCallbacks: no enhanced access", (TraceLevel)TraceLevel.BASIC);
                return false;
            }
            CPCallbackHandler handler = new CPCallbackHandler((DeployURLClassLoader)parent, (DeployURLClassLoader)child);
            parent.getDeployURLClassPath().setDeployURLClassPathCallback(handler.getParentCallback());
            child.getDeployURLClassPath().setDeployURLClassPathCallback(handler.getChildCallback());
            child.setCallbackHandler(handler);
            parent.setCodebaseLookup(false);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Exception e) {
            return false;
        }
        catch (Error err) {
            return false;
        }
        return true;
    }

    void setDeployURLClassPathCallback(DeployURLClassPath ucp) {
        Object obj = this.getCallbackHandler();
        if (obj != null) {
            CPCallbackHandler cb = (CPCallbackHandler)obj;
            ucp.setDeployURLClassPathCallback(cb.getChildCallback());
        }
    }

    void checkResource(String name) throws SecurityException {
        Object obj = this.getCodebaseElement();
        if (obj != null) {
            DeployURLClassPathCallback.Element element = (DeployURLClassPathCallback.Element)obj;
            try {
                element.checkResource(name);
            }
            catch (SecurityException se) {
                Trace.println((String)("resource name \"" + name + "\" in " + this.base + " : " + se), (TraceLevel)TraceLevel.SECURITY);
                throw se;
            }
        }
    }

    public void addURL(URL url) {
        this.addURL(url, false);
    }

    protected void addURL(URL url, boolean skipTargetURLCheck) {
        if (!skipTargetURLCheck && !URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)this.base), (URL)url)) {
            throw new SecurityException("Permission denied: " + url);
        }
        if (this.pclParent != null) {
            Trace.println((String)("Plugin2ClassLoader.addURL parent called for " + url), (TraceLevel)TraceLevel.BASIC);
            this.pclParent.addURL(url, skipTargetURLCheck);
        }
        super.addURL(url);
    }

    void addURL2(URL url) {
        if (!URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)this.base), (URL)url)) {
            throw new SecurityException("Permission denied: " + url);
        }
        if (this.pclParent != null) {
            this.drainPendingURLs();
        } else {
            this.putAddedURL(url);
        }
        Trace.println((String)("Plugin2ClassLoader.addURL2 called for " + url), (TraceLevel)TraceLevel.BASIC);
        super.addURL(url);
    }

    boolean drainPendingURLs() {
        int i;
        List<URL> addURLs = this.pclParent.grabAddedURLs();
        for (i = 0; i < addURLs.size(); ++i) {
            Trace.println((String)("Plugin2ClassLoader.drainPendingURLs addURL called for " + addURLs.get(i)), (TraceLevel)TraceLevel.BASIC);
            super.addURL(addURLs.get(i));
        }
        return i != 0;
    }

    synchronized List<URL> grabAddedURLs() {
        List<URL> urls = this.addedURLs;
        this.addedURLs = new ArrayList<URL>();
        return urls;
    }

    synchronized void putAddedURL(URL url) {
        this.addedURLs.add(url);
    }

    protected Class<?> findClassHelper(String name) throws ClassNotFoundException {
        final String className = name;
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    String path = className.replace('.', '/').concat(".class");
                    DeployURLClassPath ucp = Plugin2ClassLoader.this.getDeployURLClassPath();
                    Resource res = ucp.getResource(path, false);
                    if (res == null) {
                        throw new ClassNotFoundException(className);
                    }
                    WrapResource wrapRes = new WrapResource(res);
                    if (Plugin2ClassLoader.this.getSecurityCheck()) {
                        try {
                            wrapRes.getBytes();
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(className, e);
                        }
                    }
                    if (Plugin2ClassLoader.this.getSecurityCheck() && !Plugin2ClassLoader.this.isAllPermissionGranted(wrapRes, Plugin2ClassLoader.this.getPreloader())) {
                        cnfeThreadLocal.set(Plugin2ClassLoader.newClassNotFoundException(className));
                        throw cnfeThreadLocal.get();
                    }
                    try {
                        return Plugin2ClassLoader.this.defineClass(className, wrapRes);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(className, e);
                    }
                }
            }, this._acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    protected static ClassNotFoundException newClassNotFoundException(String name) {
        return new ClassNotFoundException(name + UNSIGNED_MESSAGE);
    }

    protected boolean isAllPermissionGranted(Resource res, Preloader p) {
        URL url = res.getCodeSourceURL();
        CodeSigner[] signers = res.getCodeSigners();
        CodeSource cs = signers != null ? new CodeSource(url, signers) : new CodeSource(url, res.getCertificates());
        try {
            return TrustDecider.isAllPermissionGranted((CodeSource)cs, (AppInfo)this.getAppInfo(cs.getLocation()), (DeploymentRuleSet)this.getDeploymentRuleSet(cs.getLocation()), (Preloader)p) != 0L;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean getSSVDialogShown() {
        return this.ssvDialogShown;
    }

    public void setSSVDialogShown(boolean shown) {
        this.ssvDialogShown = shown;
    }

    public abstract AppInfo getAppInfo(URL var1);

    public AccessControlContext getACC() {
        return this._acc;
    }

    public URL getBaseURL() {
        return this.base;
    }

    public Resource getResourceAsResource(String name) throws MalformedURLException, FileNotFoundException {
        DeployURLClassPath ucp1;
        Resource res1;
        if (name.contains("\u0000")) {
            return null;
        }
        if (this.pclParent != null) {
            try {
                return this.pclParent.getResourceAsResource(name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((res1 = (ucp1 = this.getDeployURLClassPath()).getResource(name, false)) != null) {
            return res1;
        }
        if (this.getCodebaseLookup()) {
            DeployURLClassPath ucp = new DeployURLClassPath(new URL[]{this.getBaseURL()});
            this.setDeployURLClassPathCallback(ucp);
            Resource res = ucp.getResource(name, false);
            if (res != null) {
                return res;
            }
        }
        throw new FileNotFoundException("Resource " + name + " not found");
    }

    public AccessControlContext getACC(Resource res) {
        CodeSource codeSource = new CodeSource(res.getCodeSourceURL(), res.getCodeSigners());
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, this.getPermissions(codeSource), (ClassLoader)((Object)this), null);
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    private class WrapResource
    extends Resource {
        private Resource res = null;
        private byte[] cbytes;

        public WrapResource(Resource res) {
            this.res = res;
        }

        public String getName() {
            return this.res.getName();
        }

        public URL getURL() {
            return this.res.getURL();
        }

        public URL getCodeSourceURL() {
            return this.res.getCodeSourceURL();
        }

        public InputStream getInputStream() throws IOException {
            return this.res.getInputStream();
        }

        public int getContentLength() throws IOException {
            return this.res.getContentLength();
        }

        public byte[] getBytes() throws IOException {
            if (this.cbytes == null) {
                this.cbytes = super.getBytes();
            }
            return (byte[])this.cbytes.clone();
        }

        public ByteBuffer getByteBuffer() throws IOException {
            return this.res.getByteBuffer();
        }

        public Manifest getManifest() throws IOException {
            return this.res.getManifest();
        }

        public Certificate[] getCertificates() {
            try {
                this.getBytes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.res.getCertificates();
        }

        public CodeSigner[] getCodeSigners() {
            try {
                this.getBytes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.res.getCodeSigners();
        }
    }

    private static class TrustedResult {
        final boolean allPerms;
        final Throwable cause;

        TrustedResult(boolean allPerms) {
            this(allPerms, null);
        }

        TrustedResult(boolean allPerms, Throwable cause) {
            this.allPerms = allPerms;
            this.cause = cause;
        }
    }
}

