/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.plugin2.applet.Applet2ClassLoader;
import sun.plugin2.applet.Applet2Manager;
import sun.plugin2.applet.StopListener;

public class Applet2ClassLoaderCache {
    private static final boolean DEBUG = Config.getDebug();
    private EntryCreator entryCreator;
    private static final boolean IS_IN_USE;
    private Map<String, Entry> cache = new HashMap<String, Entry>();
    private List<SoftReference<Entry>> zombieList = new ArrayList<SoftReference<Entry>>();
    private static final int MAX_ZOMBIES;

    public Applet2ClassLoaderCache(EntryCreator entryCreator) {
        this.entryCreator = entryCreator;
    }

    public boolean isInUse() {
        return IS_IN_USE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(String classLoaderCacheKey, Applet2Manager caller) {
        assert (Thread.holdsLock(caller));
        Entry entry = null;
        Applet2ClassLoaderCache applet2ClassLoaderCache = this;
        synchronized (applet2ClassLoaderCache) {
            boolean mustAdd = false;
            entry = this.cache.get(classLoaderCacheKey);
            if (entry == null) {
                mustAdd = true;
                entry = this.lookupInZombieList(classLoaderCacheKey);
                if (entry == null) {
                    entry = new Entry(classLoaderCacheKey);
                    if (DEBUG) {
                        System.out.println("Applet2ClassLoaderCache created new entry for " + classLoaderCacheKey);
                    }
                } else if (DEBUG) {
                    System.out.println("Applet2ClassLoaderCache using zombie list entry for " + classLoaderCacheKey);
                }
            } else if (DEBUG) {
                System.out.println("Applet2ClassLoaderCache reusing entry for " + classLoaderCacheKey);
            }
            if (mustAdd) {
                this.cache.put(classLoaderCacheKey, entry);
            }
        }
        entry.ref(caller);
        return entry;
    }

    public void release(Entry entry, Applet2Manager caller, StopListener stopListener, long timeToWait) {
        assert (Thread.holdsLock(caller));
        entry.unref(caller, stopListener, timeToWait);
    }

    public synchronized void markNotCacheable(String classLoaderCacheKey) {
        this.cache.remove(classLoaderCacheKey);
        Iterator<SoftReference<Entry>> iter = this.zombieList.iterator();
        while (iter.hasNext()) {
            SoftReference<Entry> ref = iter.next();
            Entry entry = ref.get();
            if (entry == null || !entry.getClassLoaderCacheKey().equals(classLoaderCacheKey)) continue;
            iter.remove();
        }
    }

    public synchronized void markNotCacheable(Entry entry) {
        this.conditionallyRemoveFromCache(entry);
    }

    public synchronized void clear() {
        this.cache.clear();
        this.zombieList.clear();
    }

    public synchronized void dump(PrintWriter ps) {
        ps.println(ResourceManager.getString((String)"console.dump.classloader.cache"));
        for (Entry entry : this.cache.values()) {
            ps.print(ResourceManager.getString((String)"console.dump.classloader.live"));
            entry.dump(ps);
        }
        for (SoftReference softReference : this.zombieList) {
            Entry entry = (Entry)softReference.get();
            if (entry == null) continue;
            ps.print(ResourceManager.getString((String)"console.dump.classloader.zombie"));
            entry.dump(ps);
        }
        ps.println(ResourceManager.getString((String)"console.dump.classloader.done"));
    }

    private Entry conditionallyRemoveFromCache(Entry entry) {
        Entry res = this.cache.remove(entry.getClassLoaderCacheKey());
        if (res == entry) {
            return res;
        }
        return null;
    }

    private void cleanupZombieList() {
        Iterator<SoftReference<Entry>> iter = this.zombieList.iterator();
        while (iter.hasNext()) {
            SoftReference<Entry> ref = iter.next();
            if (ref.get() != null) continue;
            iter.remove();
        }
    }

    private synchronized void moveToZombieList(Entry entry) {
        if ((entry = this.conditionallyRemoveFromCache(entry)) != null) {
            this.cleanupZombieList();
            this.zombieList.add(0, new SoftReference<Entry>(entry));
            if (this.zombieList.size() > MAX_ZOMBIES) {
                this.zombieList.remove(this.zombieList.size() - 1);
            }
        }
    }

    private Entry lookupInZombieList(String classLoaderCacheKey) {
        Iterator<SoftReference<Entry>> iter = this.zombieList.iterator();
        while (iter.hasNext()) {
            SoftReference<Entry> ref = iter.next();
            Entry entry = ref.get();
            if (entry == null || !entry.getClassLoaderCacheKey().equals(classLoaderCacheKey)) continue;
            iter.remove();
            return entry;
        }
        return null;
    }

    public void shutdown() {
        if (DEBUG) {
            System.out.println("Classloader Cache shuting down...");
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(this.cache.values());
        for (Entry entry : entries) {
            Entry entry2;
            Entry o = entry;
            if (!(o instanceof Entry) || (entry2 = o) == null || entry2.getClassLoader() == null) continue;
            try {
                entry2.getClassLoader().close();
            }
            catch (IOException ex) {
                Trace.ignored((Throwable)ex);
            }
        }
        for (SoftReference softReference : this.zombieList) {
            Entry entry;
            if (softReference == null || (entry = (Entry)softReference.get()) == null || entry.getClassLoader() == null) continue;
            try {
                entry.getClassLoader().close();
            }
            catch (IOException ex) {
                Trace.ignored((Throwable)ex);
            }
        }
        this.clear();
    }

    static {
        String value = SystemPropertyUtil.getProperty((String)"javaplugin.classloader.cache.enabled");
        IS_IN_USE = value == null || value.equals("true");
        int zombies = SystemPropertyUtil.getIntProperty((String)"javaplugin.classloader.cache.sizes", (int)4);
        if (zombies > 4) {
            zombies = 4;
        }
        MAX_ZOMBIES = zombies;
    }

    public class Entry {
        private String classLoaderCacheKey;
        private int refCount;
        private Applet2ClassLoader classLoader;
        private AppContext appContext;
        private ThreadGroup threadGroup;

        private Entry(String classLoaderCacheKey) {
            this.classLoaderCacheKey = classLoaderCacheKey;
        }

        public String getClassLoaderCacheKey() {
            return this.classLoaderCacheKey;
        }

        public void setClassLoader(Applet2ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public Applet2ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setAppContext(AppContext appContext) {
            this.appContext = appContext;
        }

        public AppContext getAppContext() {
            return this.appContext;
        }

        public void setThreadGroup(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        public ThreadGroup getThreadGroup() {
            return this.threadGroup;
        }

        private synchronized void ref(Applet2Manager caller) {
            assert (!Thread.holdsLock(Applet2ClassLoaderCache.this));
            if (++this.refCount == 1) {
                if (this.classLoader == null) {
                    Applet2ClassLoaderCache.this.entryCreator.createAll(caller, this);
                } else {
                    Applet2ClassLoaderCache.this.entryCreator.createThreadGroupAndAppContext(caller, this);
                }
            }
        }

        private synchronized void unref(Applet2Manager caller, StopListener stopListener, long timeToWait) {
            assert (!Thread.holdsLock(Applet2ClassLoaderCache.this));
            if (--this.refCount == 0) {
                Applet2ClassLoaderCache.this.entryCreator.destroyThreadGroupAndAppContext(caller, stopListener, timeToWait, this);
                Applet2ClassLoaderCache.this.moveToZombieList(this);
            }
        }

        private synchronized void dump(PrintWriter ps) {
            ps.println("key=" + this.classLoaderCacheKey + ", refCount=" + this.refCount + ", threadGroup=" + this.threadGroup);
        }
    }

    public static interface EntryCreator {
        public void createAll(Applet2Manager var1, Entry var2);

        public void createThreadGroupAndAppContext(Applet2Manager var1, Entry var2);

        public void destroyThreadGroupAndAppContext(Applet2Manager var1, StopListener var2, long var3, Entry var5);
    }
}

