/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.PrintWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import sun.applet.AppletClassLoader;
import sun.applet.AppletPanel;
import sun.plugin.security.PluginClassLoader;

public class ClassLoaderInfo {
    private URL codebase;
    private String key;
    private int references = 0;
    private HashMap<String, String> jars;
    private boolean locked;
    private boolean isCachable = true;
    private static boolean initialized;
    private static HashMap<String, ArrayList<ClassLoaderInfo>> infos;
    private static int zombieLimit;
    private static ArrayList<ClassLoaderInfo> zombies;
    private LoaderReference loaderRef = null;
    private static ReferenceQueue<Object> refQueue;
    private boolean localJarsLoaded = false;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ClassLoaderInfo.reset();
    }

    public static synchronized void reset() {
        initialized = true;
        zombieLimit = 0;
        String value = SystemPropertyUtil.getProperty((String)"javaplugin.classloader.cache.enabled");
        if (value == null || value.equals("true")) {
            zombieLimit = SystemPropertyUtil.getIntProperty((String)"javaplugin.classloader.cache.sizes", (int)4);
        }
        if (zombieLimit > 4) {
            zombieLimit = 4;
        }
    }

    public static synchronized void clearClassLoaderCache() {
        for (ClassLoaderInfo victim : zombies) {
            if (victim == null) continue;
            infos.remove(victim.key);
            victim.clearLoaderRef();
        }
        zombies.clear();
        Collection<ArrayList<ClassLoaderInfo>> collection = infos.values();
        if (collection != null) {
            Iterator<ArrayList<ClassLoaderInfo>> cliIter = collection.iterator();
            while (cliIter.hasNext()) {
                ClassLoaderInfo target2 = null;
                ArrayList<ClassLoaderInfo> list = cliIter.next();
                if (list == null) continue;
                for (ClassLoaderInfo target2 : list) {
                    if (target2 == null) continue;
                    target2.isCachable = false;
                }
            }
        }
        AppletPanel.flushClassLoaders();
    }

    public static synchronized void dumpClassLoaderCache(PrintWriter ps) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Dump classloader list ...\n");
        Collection<ArrayList<ClassLoaderInfo>> collection = infos.values();
        if (collection != null) {
            for (ArrayList<ClassLoaderInfo> list : collection) {
                if (list == null) continue;
                for (ClassLoaderInfo info : list) {
                    if (info == null || info.loaderRef == null || info.loaderRef.get() == null) continue;
                    boolean isZombie = zombies.contains(info);
                    buffer.append("    codebase=" + info.codebase);
                    buffer.append(", key=" + info.key);
                    buffer.append(", zombie=" + isZombie);
                    buffer.append(", cache=" + info.isCachable);
                    buffer.append(", refcount=" + info.references);
                    buffer.append(", info=" + info);
                    buffer.append("\n");
                }
            }
        }
        buffer.append("Done.");
        ps.println(buffer.toString());
    }

    public static synchronized void markNotCachable(URL codebase, String key) {
        assert (ClassLoaderInfo.checkListsValidity());
        ClassLoaderInfo cli = ClassLoaderInfo.getUsableClassLoaderInfo(key);
        if (cli != null) {
            cli.isCachable = false;
            if (zombies.remove(cli)) {
                ClassLoaderInfo.removeClassLoaderInfo(cli);
            }
            AppletPanel.flushClassLoader((String)key);
        }
        assert (ClassLoaderInfo.checkListsValidity());
    }

    private static synchronized void removeClassLoaderInfo(ClassLoaderInfo cli) {
        ArrayList<ClassLoaderInfo> list = infos.get(cli.key);
        if (list != null) {
            list.remove(cli);
            if (list.isEmpty()) {
                infos.remove(cli.key);
            }
        }
        cli.clearLoaderRef();
    }

    private static synchronized void addClassLoaderInfo(ClassLoaderInfo cli) {
        ArrayList<ClassLoaderInfo> list = infos.get(cli.key);
        if (list == null) {
            list = new ArrayList();
            list.add(cli);
            infos.put(cli.key, list);
        } else {
            list.add(cli);
        }
    }

    private static synchronized ClassLoaderInfo getUsableClassLoaderInfo(String key) {
        ArrayList<ClassLoaderInfo> list = infos.get(key);
        if (list != null) {
            Iterator<ClassLoaderInfo> listIter = list.iterator();
            ClassLoaderInfo cli = null;
            while (listIter.hasNext()) {
                cli = listIter.next();
                if (!cli.isCachable) continue;
                return cli;
            }
        }
        return null;
    }

    public static synchronized ClassLoaderInfo find(URL codebase, String key) {
        assert (ClassLoaderInfo.checkListsValidity());
        ClassLoaderInfo.initialize();
        if (codebase == null) {
            return null;
        }
        ClassLoaderInfo cli = ClassLoaderInfo.getUsableClassLoaderInfo(key);
        if (cli != null) {
            zombies.remove(cli);
        } else {
            cli = new ClassLoaderInfo(codebase, key);
            ClassLoaderInfo.addClassLoaderInfo(cli);
        }
        assert (ClassLoaderInfo.checkListsValidity());
        return cli;
    }

    public synchronized void addReference() {
        ++this.references;
        Trace.msgPrintln((String)"classloaderinfo.referencing", (Object[])new Object[]{this, String.valueOf(this.references)}, (TraceLevel)TraceLevel.BASIC);
    }

    synchronized int removeReference() {
        --this.references;
        Trace.msgPrintln((String)"classloaderinfo.releasing", (Object[])new Object[]{this, String.valueOf(this.references)}, (TraceLevel)TraceLevel.BASIC);
        if (this.references < 0) {
            throw new Error("negative ref count???");
        }
        if (this.references == 0) {
            ClassLoaderInfo.addZombie(this);
        }
        return this.references;
    }

    private static synchronized void addZombie(ClassLoaderInfo cli) {
        assert (ClassLoaderInfo.checkListsValidity());
        AppletPanel.flushClassLoader((String)cli.key);
        if (zombieLimit == 0 || !cli.isCachable) {
            ClassLoaderInfo.removeClassLoaderInfo(cli);
        } else {
            Trace.msgPrintln((String)"classloaderinfo.caching", (Object[])new Object[]{cli}, (TraceLevel)TraceLevel.BASIC);
            AppletClassLoader acl = (AppletClassLoader)cli.loaderRef.get();
            if (acl != null && acl.getExceptionStatus()) {
                cli.clearLoaderRef();
            }
            zombies.add(cli);
            ClassLoaderInfo.cleanupZombies();
            Trace.msgPrintln((String)"classloaderinfo.cachesize", (Object[])new Object[]{zombies.size()}, (TraceLevel)TraceLevel.BASIC);
            if (zombies.size() > zombieLimit) {
                ClassLoaderInfo victim = zombies.get(0);
                Trace.msgPrintln((String)"classloaderinfo.num", (Object[])new Object[]{String.valueOf(zombieLimit), victim}, (TraceLevel)TraceLevel.BASIC);
                zombies.remove(0);
                ClassLoaderInfo.removeClassLoaderInfo(victim);
                victim.clearLoaderRef();
            }
        }
        assert (ClassLoaderInfo.checkListsValidity());
    }

    public synchronized AppletClassLoader getLoader() {
        AppletClassLoader loader = null;
        if (this.loaderRef != null) {
            loader = (AppletClassLoader)this.loaderRef.get();
        }
        if (loader == null) {
            loader = AccessController.doPrivileged(new PrivilegedAction<PluginClassLoader>(){

                @Override
                public PluginClassLoader run() {
                    return new PluginClassLoader(ClassLoaderInfo.this.codebase);
                }
            });
            this.loaderRef = new LoaderReference((ClassLoader)loader);
            this.jars.clear();
            this.localJarsLoaded = false;
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppletClassLoader grabClassLoader() {
        AppletClassLoader loader = null;
        ClassLoaderInfo classLoaderInfo = this;
        synchronized (classLoaderInfo) {
            loader = this.getLoader();
            this.addReference();
        }
        loader.getThreadGroup();
        return loader;
    }

    private synchronized void clearLoaderRef() {
        if (this.loaderRef != null) {
            this.loaderRef.clear();
            this.loaderRef = null;
        }
    }

    private static synchronized void cleanupZombies() {
        LoaderReference ref = (LoaderReference)refQueue.poll();
        while (ref != null) {
            String key = ref.getKey();
            ArrayList<ClassLoaderInfo> list = infos.get(key);
            if (list != null) {
                ArrayList newlist = (ArrayList)list.clone();
                for (ClassLoaderInfo victim : newlist) {
                    if (victim.loaderRef != ref || !zombies.contains(victim)) continue;
                    list.remove(victim);
                    zombies.remove(victim);
                }
            }
            ref = (LoaderReference)refQueue.poll();
        }
    }

    private ClassLoaderInfo(URL codebase, String key) {
        this.codebase = codebase;
        this.key = key;
        this.jars = new HashMap();
    }

    synchronized void addJar(String name) {
        this.jars.put(name, name);
    }

    synchronized boolean hasJar(String name) {
        return this.jars.get(name) != null;
    }

    public boolean getLocalJarsLoaded() {
        return this.localJarsLoaded;
    }

    public void setLocalJarsLoaded(boolean loadedFlag) {
        this.localJarsLoaded = loadedFlag;
    }

    public final synchronized void lock() throws InterruptedException {
        while (this.locked) {
            this.wait();
        }
        this.locked = true;
    }

    public final synchronized void unlock() {
        this.locked = false;
        this.notifyAll();
    }

    public static synchronized boolean checkListsValidity() {
        ClassLoaderInfo cli2 = null;
        Collection<ArrayList<ClassLoaderInfo>> collection = infos.values();
        for (ArrayList<ClassLoaderInfo> list : collection) {
            if (list == null) continue;
            int cachableCount = 0;
            for (ClassLoaderInfo cli2 : list) {
                if (cli2 == null || !cli2.isCachable) continue;
                ++cachableCount;
            }
            if (cachableCount <= true) continue;
            return false;
        }
        for (ClassLoaderInfo cli2 : zombies) {
            if (cli2 == null || cli2.isCachable) continue;
            return false;
        }
        return true;
    }

    static {
        infos = new HashMap();
        zombieLimit = 0;
        zombies = new ArrayList();
        refQueue = new ReferenceQueue();
    }

    private class LoaderReference
    extends SoftReference<Object> {
        public LoaderReference(ClassLoader referrent) {
            super(referrent, refQueue);
        }

        public String getCodebase() {
            return ClassLoaderInfo.this.codebase.toString();
        }

        public String getKey() {
            return ClassLoaderInfo.this.key;
        }
    }
}

