/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.Applet2Adapter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.plugin2.applet.Plugin2Manager;

public class AppletEnumeration {
    private static final Set<WeakReference<Plugin2Manager>> activeManagers = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveStatus(Plugin2Manager manager, boolean active) {
        if (active) {
            activeManagers.add(new WeakReference<Plugin2Manager>(manager));
        } else {
            ArrayList<WeakReference<Plugin2Manager>> deadRefs = null;
            Set<WeakReference<Plugin2Manager>> set = activeManagers;
            synchronized (set) {
                for (WeakReference<Plugin2Manager> ref : activeManagers) {
                    Plugin2Manager referent = (Plugin2Manager)ref.get();
                    if (referent == null) {
                        if (deadRefs == null) {
                            deadRefs = new ArrayList<WeakReference<Plugin2Manager>>();
                        }
                        deadRefs.add(ref);
                        continue;
                    }
                    if (referent != manager) continue;
                    activeManagers.remove(ref);
                    break;
                }
            }
            if (deadRefs != null) {
                for (WeakReference weakReference : deadRefs) {
                    activeManagers.remove(weakReference);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Plugin2Manager> getActiveManagers() {
        ArrayList<Plugin2Manager> managers = new ArrayList<Plugin2Manager>();
        Set<WeakReference<Plugin2Manager>> set = activeManagers;
        synchronized (set) {
            for (WeakReference<Plugin2Manager> ref : activeManagers) {
                Plugin2Manager mgr = (Plugin2Manager)ref.get();
                if (mgr == null) continue;
                managers.add(mgr);
            }
        }
        return managers;
    }

    public Applet2Adapter getApplet2Adapter(Plugin2Manager origin, String name) {
        List<Plugin2Manager> managers = this.getActiveManagers();
        name = name.toLowerCase();
        for (Plugin2Manager mgr : managers) {
            String param = mgr.getParameter("name");
            if (param != null) {
                param = param.toLowerCase();
            }
            if (!name.equals(param) || !mgr.getDocumentBase().equals(origin.getDocumentBase())) continue;
            try {
                if (!this.checkConnect(origin.getCodeBase().getHost(), mgr.getCodeBase().getHost())) {
                    return null;
                }
            }
            catch (InvocationTargetException ee) {
                this.showStatusText(ee.getTargetException().getMessage());
                return null;
            }
            catch (Exception ee) {
                this.showStatusText(ee.getMessage());
                return null;
            }
            return mgr.getApplet2Adapter();
        }
        return null;
    }

    public Enumeration<Applet2Adapter> getApplet2Adapters(Plugin2Manager origin) {
        List<Plugin2Manager> managers = this.getActiveManagers();
        ArrayList<Applet2Adapter> contexts = new ArrayList<Applet2Adapter>();
        for (Plugin2Manager mgr : managers) {
            if (!mgr.getDocumentBase().equals(origin.getDocumentBase())) continue;
            try {
                Applet2Adapter a;
                if (!this.checkConnect(origin.getCodeBase().getHost(), mgr.getCodeBase().getHost()) || !(a = mgr.getApplet2Adapter()).isInstantiated()) continue;
                contexts.add(a);
            }
            catch (InvocationTargetException ee) {
                this.showStatusText(ee.getTargetException().getMessage());
            }
            catch (Exception ee) {
                this.showStatusText(ee.getMessage());
            }
        }
        Applet2Adapter origin_ad = origin.getApplet2Adapter();
        if (origin_ad.isInstantiated() && !contexts.contains(origin_ad)) {
            contexts.add(origin_ad);
        }
        return Collections.enumeration(contexts);
    }

    private boolean checkConnect(String sourceHostName, String targetHostName) throws Exception {
        SocketPermission panelSp = new SocketPermission(sourceHostName, "connect");
        SocketPermission sp = new SocketPermission(targetHostName, "connect");
        return panelSp.implies(sp);
    }

    private void showStatusText(String msg) {
        Trace.msgPrintln((String)msg, null, (TraceLevel)TraceLevel.BASIC);
    }
}

