/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.deploy.trace.Trace;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.plugin2.applet.Applet2ClassLoader;

public final class Applet2ImageFactory {
    public static Image createImage(final URL url) {
        Image img = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                try {
                    Thread t = Thread.currentThread();
                    ClassLoader cl = t.getContextClassLoader();
                    if (cl != null && cl instanceof Applet2ClassLoader) {
                        Applet2ClassLoader pcl = (Applet2ClassLoader)((Object)cl);
                        String clsLoaderURLString = pcl.getBaseURL().toString();
                        String imageURLString = url.toString();
                        int i = imageURLString.indexOf(clsLoaderURLString);
                        if (i == 0) {
                            String imageName;
                            if (imageURLString.length() > clsLoaderURLString.length()) {
                                imageName = imageURLString.charAt(clsLoaderURLString.length()) == '/' ? imageURLString.substring(clsLoaderURLString.length() + 1) : imageURLString.substring(clsLoaderURLString.length());
                            } else {
                                return null;
                            }
                            InputStream is = pcl.getResourceAsStreamFromJar(imageName);
                            if (is != null) {
                                return Applet2ImageFactory.getImage(is);
                            }
                        }
                    }
                    Image image = Toolkit.getDefaultToolkit().createImage(url);
                    return image;
                }
                catch (FileNotFoundException e) {
                    return Toolkit.getDefaultToolkit().createImage(new byte[0]);
                }
                catch (Exception e) {
                    Trace.ignoredException((Exception)e);
                    return null;
                }
            }
        });
        return img;
    }

    private static Image getImage(InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int byteRead = 0;
        while ((byteRead = bis.read(buffer, 0, 8192)) != -1) {
            bos.write(buffer, 0, byteRead);
        }
        bis.close();
        byte[] data = bos.toByteArray();
        if (data != null && data.length > 0) {
            return Toolkit.getDefaultToolkit().createImage(data);
        }
        return null;
    }
}

